/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.delete;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class DeleteMappingRequest
extends AcknowledgedRequest<DeleteMappingRequest> {
    private String[] indices;
    private String type;

    DeleteMappingRequest() {
    }

    public DeleteMappingRequest(String ... indices) {
        this.indices = indices;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.type == null) {
            validationException = ValidateActions.addValidationError("mapping type is missing", validationException);
        }
        return validationException;
    }

    public DeleteMappingRequest indices(String[] indices) {
        this.indices = indices;
        return this;
    }

    public String[] indices() {
        return this.indices;
    }

    public String type() {
        return this.type;
    }

    public DeleteMappingRequest type(String type) {
        this.type = type;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = new String[in.readVInt()];
        for (int i = 0; i < this.indices.length; ++i) {
            this.indices[i] = in.readString();
        }
        if (in.readBoolean()) {
            this.type = in.readString();
        }
        this.readTimeout(in, Version.V_0_90_6);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.indices == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.indices.length);
            for (String index : this.indices) {
                out.writeString(index);
            }
        }
        if (this.type == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeString(this.type);
        }
        this.writeTimeout(out, Version.V_0_90_6);
    }
}

