/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.flush;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.broadcast.BroadcastOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class FlushRequest
extends BroadcastOperationRequest<FlushRequest> {
    private boolean force = false;
    private boolean full = false;

    FlushRequest() {
    }

    public FlushRequest(String ... indices) {
        super(indices);
    }

    public boolean full() {
        return this.full;
    }

    public FlushRequest full(boolean full) {
        this.full = full;
        return this;
    }

    public boolean force() {
        return this.force;
    }

    public FlushRequest force(boolean force2) {
        this.force = force2;
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().onOrBefore(Version.V_0_90_3)) {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.full);
        out.writeBoolean(this.force);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        if (in.getVersion().onOrBefore(Version.V_0_90_3)) {
            in.readBoolean();
        }
        this.full = in.readBoolean();
        this.force = in.readBoolean();
    }
}

