/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.delete;

import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingResponse;
import org.elasticsearch.action.admin.indices.mapping.delete.TransportDeleteMappingAction;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaDataDeleteIndexService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteIndexAction
extends TransportMasterNodeOperationAction<DeleteIndexRequest, DeleteIndexResponse> {
    private final MetaDataDeleteIndexService deleteIndexService;
    private final TransportDeleteMappingAction deleteMappingAction;
    private final boolean disableDeleteAllIndices;

    @Inject
    public TransportDeleteIndexAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataDeleteIndexService deleteIndexService, TransportDeleteMappingAction deleteMappingAction) {
        super(settings, transportService, clusterService, threadPool);
        this.deleteIndexService = deleteIndexService;
        this.deleteMappingAction = deleteMappingAction;
        this.disableDeleteAllIndices = settings.getAsBoolean("action.disable_delete_all_indices", (Boolean)false);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected String transportAction() {
        return "indices/delete";
    }

    @Override
    protected DeleteIndexRequest newRequest() {
        return new DeleteIndexRequest();
    }

    @Override
    protected DeleteIndexResponse newResponse() {
        return new DeleteIndexResponse();
    }

    @Override
    protected void doExecute(DeleteIndexRequest request, ActionListener<DeleteIndexResponse> listener) {
        ClusterState state = this.clusterService.state();
        String[] indicesOrAliases = request.indices();
        request.indices(state.metaData().concreteIndices(request.indices()));
        if (this.disableDeleteAllIndices) {
            if (indicesOrAliases == null || indicesOrAliases.length == 0 || indicesOrAliases.length == 1 && indicesOrAliases[0].equals("_all")) {
                throw new ElasticSearchIllegalArgumentException("deleting all indices is disabled");
            }
            if (request.indices().length == state.metaData().concreteAllIndices().length && indicesOrAliases.length > 0) {
                boolean hasRegex = false;
                for (String indexOrAlias : indicesOrAliases) {
                    if (!Regex.isSimpleMatchPattern(indexOrAlias)) continue;
                    hasRegex = true;
                }
                if (indicesOrAliases.length > 0 && (hasRegex || indicesOrAliases[0].charAt(0) == '-')) {
                    throw new ElasticSearchIllegalArgumentException("deleting all indices is disabled");
                }
            }
        }
        super.doExecute(request, listener);
    }

    @Override
    protected ClusterBlockException checkBlock(DeleteIndexRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA, request.indices());
    }

    @Override
    protected void masterOperation(DeleteIndexRequest request, final ClusterState state, final ActionListener<DeleteIndexResponse> listener) throws ElasticSearchException {
        if (request.indices().length == 0) {
            listener.onResponse(new DeleteIndexResponse(true));
            return;
        }
        final CountDown count2 = new CountDown(request.indices().length);
        for (final String index : request.indices()) {
            this.deleteIndexService.deleteIndex(new MetaDataDeleteIndexService.Request(index).timeout(request.timeout()).masterTimeout(request.masterNodeTimeout()), new MetaDataDeleteIndexService.Listener(){
                private volatile Throwable lastFailure;

                @Override
                public void onResponse(final MetaDataDeleteIndexService.Response response) {
                    IndexMetaData percolatorMetaData = state.metaData().index("_percolator");
                    if (percolatorMetaData != null && percolatorMetaData.mappings().containsKey(index)) {
                        TransportDeleteIndexAction.this.deleteMappingAction.execute(new DeleteMappingRequest("_percolator").type(index), new ActionListener<DeleteMappingResponse>(){

                            @Override
                            public void onResponse(DeleteMappingResponse deleteMappingResponse) {
                                if (count2.countDown()) {
                                    if (lastFailure != null) {
                                        listener.onFailure(lastFailure);
                                    } else {
                                        listener.onResponse(new DeleteIndexResponse(response.acknowledged()));
                                    }
                                }
                            }

                            @Override
                            public void onFailure(Throwable e) {
                                if (count2.countDown()) {
                                    if (lastFailure != null) {
                                        listener.onFailure(lastFailure);
                                    } else {
                                        listener.onResponse(new DeleteIndexResponse(response.acknowledged()));
                                    }
                                }
                            }
                        });
                    } else if (count2.countDown()) {
                        if (this.lastFailure != null) {
                            listener.onFailure(this.lastFailure);
                        } else {
                            listener.onResponse(new DeleteIndexResponse(response.acknowledged()));
                        }
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    TransportDeleteIndexAction.this.logger.debug("[{}] failed to delete index", t, index);
                    this.lastFailure = t;
                    if (count2.countDown()) {
                        listener.onFailure(t);
                    }
                }
            });
        }
    }
}

