/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.alias.get;

import java.util.List;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.get.IndicesGetAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.IndicesGetAliasesResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportIndicesGetAliasesAction
extends TransportMasterNodeOperationAction<IndicesGetAliasesRequest, IndicesGetAliasesResponse> {
    @Inject
    public TransportIndicesGetAliasesAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool) {
        super(settings, transportService, clusterService, threadPool);
    }

    @Override
    protected String transportAction() {
        return "indices/get/aliases";
    }

    @Override
    protected String executor() {
        return "management";
    }

    @Override
    protected IndicesGetAliasesRequest newRequest() {
        return new IndicesGetAliasesRequest();
    }

    @Override
    protected IndicesGetAliasesResponse newResponse() {
        return new IndicesGetAliasesResponse();
    }

    @Override
    protected void masterOperation(IndicesGetAliasesRequest request, ClusterState state, ActionListener<IndicesGetAliasesResponse> listener) throws ElasticSearchException {
        String[] concreteIndices = state.metaData().concreteIndices(request.indices(), request.ignoreIndices(), true);
        request.indices(concreteIndices);
        ImmutableOpenMap<String, List<AliasMetaData>> result2 = state.metaData().findAliases(request.aliases(), request.indices());
        listener.onResponse(new IndicesGetAliasesResponse(result2));
    }
}

