/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.alias.get;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.IgnoreIndices;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class IndicesGetAliasesRequest
extends MasterNodeOperationRequest<IndicesGetAliasesRequest> {
    private String[] indices = Strings.EMPTY_ARRAY;
    private String[] aliases = Strings.EMPTY_ARRAY;
    private IgnoreIndices ignoreIndices = IgnoreIndices.NONE;

    public IndicesGetAliasesRequest(String[] aliases) {
        this.aliases = aliases;
    }

    public IndicesGetAliasesRequest(String alias) {
        this.aliases = new String[]{alias};
    }

    public IndicesGetAliasesRequest() {
    }

    public IndicesGetAliasesRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public IndicesGetAliasesRequest aliases(String ... aliases) {
        this.aliases = aliases;
        return this;
    }

    public IndicesGetAliasesRequest ignoreIndices(IgnoreIndices ignoreIndices) {
        this.ignoreIndices = ignoreIndices;
        return this;
    }

    public String[] indices() {
        return this.indices;
    }

    public String[] aliases() {
        return this.aliases;
    }

    public IgnoreIndices ignoreIndices() {
        return this.ignoreIndices;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = in.readStringArray();
        this.aliases = in.readStringArray();
        this.ignoreIndices = IgnoreIndices.fromId(in.readByte());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        out.writeStringArray(this.aliases);
        out.writeByte(this.ignoreIndices.id());
    }
}

