/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.alias;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.ElasticSearchGenerationException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.cluster.metadata.AliasAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.FilterBuilder;

public class IndicesAliasesRequest
extends AcknowledgedRequest<IndicesAliasesRequest> {
    private List<AliasAction> aliasActions = Lists.newArrayList();

    public IndicesAliasesRequest addAlias(String index, String alias) {
        this.aliasActions.add(new AliasAction(AliasAction.Type.ADD, index, alias));
        return this;
    }

    public IndicesAliasesRequest addAlias(String index, String alias, String filter2) {
        this.aliasActions.add(new AliasAction(AliasAction.Type.ADD, index, alias, filter2));
        return this;
    }

    public IndicesAliasesRequest addAlias(String index, String alias, Map<String, Object> filter2) {
        if (filter2 == null || filter2.isEmpty()) {
            this.aliasActions.add(new AliasAction(AliasAction.Type.ADD, index, alias));
            return this;
        }
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(filter2);
            this.aliasActions.add(new AliasAction(AliasAction.Type.ADD, index, alias, builder.string()));
            return this;
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + filter2 + "]", e);
        }
    }

    public IndicesAliasesRequest addAlias(String index, String alias, FilterBuilder filterBuilder) {
        if (filterBuilder == null) {
            this.aliasActions.add(new AliasAction(AliasAction.Type.ADD, index, alias));
            return this;
        }
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            filterBuilder.toXContent(builder, ToXContent.EMPTY_PARAMS);
            builder.close();
            return this.addAlias(index, alias, builder.string());
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to build json for alias request", e);
        }
    }

    public IndicesAliasesRequest removeAlias(String index, String alias) {
        this.aliasActions.add(new AliasAction(AliasAction.Type.REMOVE, index, alias));
        return this;
    }

    public IndicesAliasesRequest addAliasAction(AliasAction action) {
        this.aliasActions.add(action);
        return this;
    }

    List<AliasAction> aliasActions() {
        return this.aliasActions;
    }

    public List<AliasAction> getAliasActions() {
        return this.aliasActions();
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.aliasActions.isEmpty()) {
            return ValidateActions.addValidationError("Must specify at least one alias action", validationException);
        }
        for (AliasAction aliasAction : this.aliasActions) {
            if (!Strings.hasText(aliasAction.alias())) {
                validationException = ValidateActions.addValidationError("Alias action [" + aliasAction.actionType().name().toLowerCase(Locale.ENGLISH) + "] requires an [alias] to be set", validationException);
            }
            if (Strings.hasText(aliasAction.index())) continue;
            validationException = ValidateActions.addValidationError("Alias action [" + aliasAction.actionType().name().toLowerCase(Locale.ENGLISH) + "] requires an [index] to be set", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size2 = in.readVInt();
        for (int i = 0; i < size2; ++i) {
            this.aliasActions.add(AliasAction.readAliasAction(in));
        }
        this.readTimeout(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.aliasActions.size());
        for (AliasAction aliasAction : this.aliasActions) {
            aliasAction.writeTo(out);
        }
        this.writeTimeout(out);
    }
}

