/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.restart;

import java.io.IOException;
import org.elasticsearch.action.support.nodes.NodesOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public class NodesRestartRequest
extends NodesOperationRequest<NodesRestartRequest> {
    TimeValue delay = TimeValue.timeValueSeconds(1L);

    protected NodesRestartRequest() {
    }

    public NodesRestartRequest(String ... nodesIds) {
        super(nodesIds);
    }

    public NodesRestartRequest delay(TimeValue delay2) {
        this.delay = delay2;
        return this;
    }

    public NodesRestartRequest delay(String delay2) {
        return this.delay(TimeValue.parseTimeValue(delay2, null));
    }

    public TimeValue delay() {
        return this.delay;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.delay = TimeValue.readTimeValue(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.delay.writeTo(out);
    }
}

