/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.health;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.action.admin.cluster.health.ClusterShardHealth;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class ClusterIndexHealth
implements Iterable<ClusterShardHealth>,
Streamable,
ToXContent {
    private String index;
    private int numberOfShards;
    private int numberOfReplicas;
    int activeShards = 0;
    int relocatingShards = 0;
    int initializingShards = 0;
    int unassignedShards = 0;
    int activePrimaryShards = 0;
    ClusterHealthStatus status = ClusterHealthStatus.RED;
    final Map<Integer, ClusterShardHealth> shards = Maps.newHashMap();
    List<String> validationFailures;

    private ClusterIndexHealth() {
    }

    public ClusterIndexHealth(String index, int numberOfShards, int numberOfReplicas, List<String> validationFailures) {
        this.index = index;
        this.numberOfShards = numberOfShards;
        this.numberOfReplicas = numberOfReplicas;
        this.validationFailures = validationFailures;
    }

    public ClusterIndexHealth(IndexMetaData indexMetaData, IndexRoutingTable indexRoutingTable) {
        this.index = indexMetaData.index();
        this.numberOfShards = indexMetaData.getNumberOfShards();
        this.numberOfReplicas = indexMetaData.getNumberOfReplicas();
        this.validationFailures = indexRoutingTable.validate(indexMetaData);
        for (IndexShardRoutingTable shardRoutingTable : indexRoutingTable) {
            ClusterShardHealth shardHealth = new ClusterShardHealth(shardRoutingTable.shardId().id());
            for (ShardRouting shardRouting : shardRoutingTable) {
                if (shardRouting.active()) {
                    ++shardHealth.activeShards;
                    if (shardRouting.relocating()) {
                        ++shardHealth.relocatingShards;
                    }
                    if (!shardRouting.primary()) continue;
                    shardHealth.primaryActive = true;
                    continue;
                }
                if (shardRouting.initializing()) {
                    ++shardHealth.initializingShards;
                    continue;
                }
                if (!shardRouting.unassigned()) continue;
                ++shardHealth.unassignedShards;
            }
            shardHealth.status = shardHealth.primaryActive ? (shardHealth.activeShards == shardRoutingTable.size() ? ClusterHealthStatus.GREEN : ClusterHealthStatus.YELLOW) : ClusterHealthStatus.RED;
            this.shards.put(shardHealth.getId(), shardHealth);
        }
        this.status = ClusterHealthStatus.GREEN;
        for (ClusterShardHealth shardHealth : this.shards.values()) {
            if (shardHealth.isPrimaryActive()) {
                ++this.activePrimaryShards;
            }
            this.activeShards += shardHealth.activeShards;
            this.relocatingShards += shardHealth.relocatingShards;
            this.initializingShards += shardHealth.initializingShards;
            this.unassignedShards += shardHealth.unassignedShards;
            if (shardHealth.getStatus() == ClusterHealthStatus.RED) {
                this.status = ClusterHealthStatus.RED;
                continue;
            }
            if (shardHealth.getStatus() != ClusterHealthStatus.YELLOW || this.status == ClusterHealthStatus.RED) continue;
            this.status = ClusterHealthStatus.YELLOW;
        }
        if (!this.validationFailures.isEmpty()) {
            this.status = ClusterHealthStatus.RED;
        } else if (this.shards.isEmpty()) {
            this.status = ClusterHealthStatus.RED;
        }
    }

    public String getIndex() {
        return this.index;
    }

    public List<String> getValidationFailures() {
        return this.validationFailures;
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    public int getNumberOfReplicas() {
        return this.numberOfReplicas;
    }

    public int getActiveShards() {
        return this.activeShards;
    }

    public int getRelocatingShards() {
        return this.relocatingShards;
    }

    public int getActivePrimaryShards() {
        return this.activePrimaryShards;
    }

    public int getInitializingShards() {
        return this.initializingShards;
    }

    public int getUnassignedShards() {
        return this.unassignedShards;
    }

    public ClusterHealthStatus getStatus() {
        return this.status;
    }

    public Map<Integer, ClusterShardHealth> getShards() {
        return this.shards;
    }

    @Override
    public Iterator<ClusterShardHealth> iterator() {
        return this.shards.values().iterator();
    }

    public static ClusterIndexHealth readClusterIndexHealth(StreamInput in) throws IOException {
        ClusterIndexHealth indexHealth = new ClusterIndexHealth();
        indexHealth.readFrom(in);
        return indexHealth;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int i;
        this.index = in.readString();
        this.numberOfShards = in.readVInt();
        this.numberOfReplicas = in.readVInt();
        this.activePrimaryShards = in.readVInt();
        this.activeShards = in.readVInt();
        this.relocatingShards = in.readVInt();
        this.initializingShards = in.readVInt();
        this.unassignedShards = in.readVInt();
        this.status = ClusterHealthStatus.fromValue(in.readByte());
        int size2 = in.readVInt();
        for (i = 0; i < size2; ++i) {
            ClusterShardHealth shardHealth = ClusterShardHealth.readClusterShardHealth(in);
            this.shards.put(shardHealth.getId(), shardHealth);
        }
        size2 = in.readVInt();
        if (size2 == 0) {
            this.validationFailures = ImmutableList.of();
        } else {
            for (i = 0; i < size2; ++i) {
                this.validationFailures.add(in.readString());
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeVInt(this.numberOfShards);
        out.writeVInt(this.numberOfReplicas);
        out.writeVInt(this.activePrimaryShards);
        out.writeVInt(this.activeShards);
        out.writeVInt(this.relocatingShards);
        out.writeVInt(this.initializingShards);
        out.writeVInt(this.unassignedShards);
        out.writeByte(this.status.value());
        out.writeVInt(this.shards.size());
        for (ClusterShardHealth shardHealth : this) {
            shardHealth.writeTo(out);
        }
        out.writeVInt(this.validationFailures.size());
        for (String failure2 : this.validationFailures) {
            out.writeString(failure2);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Fields.STATUS, this.getStatus().name().toLowerCase(Locale.ROOT));
        builder.field(Fields.NUMBER_OF_SHARDS, this.getNumberOfShards());
        builder.field(Fields.NUMBER_OF_REPLICAS, this.getNumberOfReplicas());
        builder.field(Fields.ACTIVE_PRIMARY_SHARDS, this.getActivePrimaryShards());
        builder.field(Fields.ACTIVE_SHARDS, this.getActiveShards());
        builder.field(Fields.RELOCATING_SHARDS, this.getRelocatingShards());
        builder.field(Fields.INITIALIZING_SHARDS, this.getInitializingShards());
        builder.field(Fields.UNASSIGNED_SHARDS, this.getUnassignedShards());
        if (!this.getValidationFailures().isEmpty()) {
            builder.startArray(Fields.VALIDATION_FAILURES);
            for (String validationFailure : this.getValidationFailures()) {
                builder.value(validationFailure);
            }
            builder.endArray();
        }
        if ("shards".equals(params.param("level", "indices"))) {
            builder.startObject(Fields.SHARDS);
            for (ClusterShardHealth shardHealth : this.shards.values()) {
                builder.startObject(Integer.toString(shardHealth.getId()));
                builder.field(Fields.STATUS, shardHealth.getStatus().name().toLowerCase(Locale.ROOT));
                builder.field(Fields.PRIMARY_ACTIVE, shardHealth.isPrimaryActive());
                builder.field(Fields.ACTIVE_SHARDS, shardHealth.getActiveShards());
                builder.field(Fields.RELOCATING_SHARDS, shardHealth.getRelocatingShards());
                builder.field(Fields.INITIALIZING_SHARDS, shardHealth.getInitializingShards());
                builder.field(Fields.UNASSIGNED_SHARDS, shardHealth.getUnassignedShards());
                builder.endObject();
            }
            builder.endObject();
        }
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString STATUS = new XContentBuilderString("status");
        static final XContentBuilderString NUMBER_OF_SHARDS = new XContentBuilderString("number_of_shards");
        static final XContentBuilderString NUMBER_OF_REPLICAS = new XContentBuilderString("number_of_replicas");
        static final XContentBuilderString ACTIVE_PRIMARY_SHARDS = new XContentBuilderString("active_primary_shards");
        static final XContentBuilderString ACTIVE_SHARDS = new XContentBuilderString("active_shards");
        static final XContentBuilderString RELOCATING_SHARDS = new XContentBuilderString("relocating_shards");
        static final XContentBuilderString INITIALIZING_SHARDS = new XContentBuilderString("initializing_shards");
        static final XContentBuilderString UNASSIGNED_SHARDS = new XContentBuilderString("unassigned_shards");
        static final XContentBuilderString VALIDATION_FAILURES = new XContentBuilderString("validation_failures");
        static final XContentBuilderString SHARDS = new XContentBuilderString("shards");
        static final XContentBuilderString PRIMARY_ACTIVE = new XContentBuilderString("primary_active");

        Fields() {
        }
    }
}

