/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.health;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.action.admin.cluster.health.ClusterIndexHealth;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTableValidation;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.rest.RestStatus;

public class ClusterHealthResponse
extends ActionResponse
implements Iterable<ClusterIndexHealth>,
ToXContent {
    private String clusterName;
    int numberOfNodes = 0;
    int numberOfDataNodes = 0;
    int activeShards = 0;
    int relocatingShards = 0;
    int activePrimaryShards = 0;
    int initializingShards = 0;
    int unassignedShards = 0;
    boolean timedOut = false;
    ClusterHealthStatus status = ClusterHealthStatus.RED;
    private List<String> validationFailures;
    Map<String, ClusterIndexHealth> indices = Maps.newHashMap();

    ClusterHealthResponse() {
    }

    public ClusterHealthResponse(String clusterName, List<String> validationFailures) {
        this.clusterName = clusterName;
        this.validationFailures = validationFailures;
    }

    public ClusterHealthResponse(String clusterName, String[] concreteIndices, ClusterState clusterState) {
        this.clusterName = clusterName;
        RoutingTableValidation validation = clusterState.routingTable().validate(clusterState.metaData());
        this.validationFailures = validation.failures();
        this.numberOfNodes = clusterState.nodes().size();
        this.numberOfDataNodes = clusterState.nodes().dataNodes().size();
        for (String index : concreteIndices) {
            IndexRoutingTable indexRoutingTable = clusterState.routingTable().index(index);
            IndexMetaData indexMetaData = clusterState.metaData().index(index);
            if (indexRoutingTable == null) continue;
            ClusterIndexHealth indexHealth = new ClusterIndexHealth(indexMetaData, indexRoutingTable);
            this.indices.put(indexHealth.getIndex(), indexHealth);
        }
        this.status = ClusterHealthStatus.GREEN;
        for (ClusterIndexHealth indexHealth : this.indices.values()) {
            this.activePrimaryShards += indexHealth.activePrimaryShards;
            this.activeShards += indexHealth.activeShards;
            this.relocatingShards += indexHealth.relocatingShards;
            this.initializingShards += indexHealth.initializingShards;
            this.unassignedShards += indexHealth.unassignedShards;
            if (indexHealth.getStatus() == ClusterHealthStatus.RED) {
                this.status = ClusterHealthStatus.RED;
                continue;
            }
            if (indexHealth.getStatus() != ClusterHealthStatus.YELLOW || this.status == ClusterHealthStatus.RED) continue;
            this.status = ClusterHealthStatus.YELLOW;
        }
        if (!this.validationFailures.isEmpty()) {
            this.status = ClusterHealthStatus.RED;
        } else if (clusterState.blocks().hasGlobalBlock(RestStatus.SERVICE_UNAVAILABLE)) {
            this.status = ClusterHealthStatus.RED;
        }
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public List<String> getValidationFailures() {
        return this.validationFailures;
    }

    public List<String> getAllValidationFailures() {
        ArrayList<String> allFailures = Lists.newArrayList(this.getValidationFailures());
        for (ClusterIndexHealth indexHealth : this.indices.values()) {
            allFailures.addAll(indexHealth.getValidationFailures());
        }
        return allFailures;
    }

    public int getActiveShards() {
        return this.activeShards;
    }

    public int getRelocatingShards() {
        return this.relocatingShards;
    }

    public int getActivePrimaryShards() {
        return this.activePrimaryShards;
    }

    public int getInitializingShards() {
        return this.initializingShards;
    }

    public int getUnassignedShards() {
        return this.unassignedShards;
    }

    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public int getNumberOfDataNodes() {
        return this.numberOfDataNodes;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public ClusterHealthStatus getStatus() {
        return this.status;
    }

    public Map<String, ClusterIndexHealth> getIndices() {
        return this.indices;
    }

    @Override
    public Iterator<ClusterIndexHealth> iterator() {
        return this.indices.values().iterator();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int i;
        super.readFrom(in);
        this.clusterName = in.readString();
        this.activePrimaryShards = in.readVInt();
        this.activeShards = in.readVInt();
        this.relocatingShards = in.readVInt();
        this.initializingShards = in.readVInt();
        this.unassignedShards = in.readVInt();
        this.numberOfNodes = in.readVInt();
        this.numberOfDataNodes = in.readVInt();
        this.status = ClusterHealthStatus.fromValue(in.readByte());
        int size2 = in.readVInt();
        for (i = 0; i < size2; ++i) {
            ClusterIndexHealth indexHealth = ClusterIndexHealth.readClusterIndexHealth(in);
            this.indices.put(indexHealth.getIndex(), indexHealth);
        }
        this.timedOut = in.readBoolean();
        size2 = in.readVInt();
        if (size2 == 0) {
            this.validationFailures = ImmutableList.of();
        } else {
            for (i = 0; i < size2; ++i) {
                this.validationFailures.add(in.readString());
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.clusterName);
        out.writeVInt(this.activePrimaryShards);
        out.writeVInt(this.activeShards);
        out.writeVInt(this.relocatingShards);
        out.writeVInt(this.initializingShards);
        out.writeVInt(this.unassignedShards);
        out.writeVInt(this.numberOfNodes);
        out.writeVInt(this.numberOfDataNodes);
        out.writeByte(this.status.value());
        out.writeVInt(this.indices.size());
        for (ClusterIndexHealth indexHealth : this) {
            indexHealth.writeTo(out);
        }
        out.writeBoolean(this.timedOut);
        out.writeVInt(this.validationFailures.size());
        for (String failure2 : this.validationFailures) {
            out.writeString(failure2);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ClusterHealthResponse - status [").append((Object)this.status).append("]").append("\ntimedOut [").append(this.timedOut).append("]").append("\nclustername [").append(this.clusterName).append("]").append("\nnumberOfNodes [").append(this.numberOfNodes).append("]").append("\nnumberOfDataNodes [").append(this.numberOfDataNodes).append("]").append("\nactiveShards [").append(this.activeShards).append("]").append("\nrelocatingShards [").append(this.relocatingShards).append("]").append("\nactivePrimaryShards [").append(this.activePrimaryShards).append("]").append("\ninitializingShards [").append(this.initializingShards).append("]").append("\nvalidationFailures ").append(this.validationFailures).append("\nindices:");
        for (Map.Entry<String, ClusterIndexHealth> indexEntry : this.indices.entrySet()) {
            builder.append(" [").append(indexEntry.getKey()).append("][").append((Object)indexEntry.getValue().status).append("]");
        }
        return builder.toString();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean outputIndices;
        builder.field(Fields.CLUSTER_NAME, this.getClusterName());
        builder.field(Fields.STATUS, this.getStatus().name().toLowerCase(Locale.ROOT));
        builder.field(Fields.TIMED_OUT, this.isTimedOut());
        builder.field(Fields.NUMBER_OF_NODES, this.getNumberOfNodes());
        builder.field(Fields.NUMBER_OF_DATA_NODES, this.getNumberOfDataNodes());
        builder.field(Fields.ACTIVE_PRIMARY_SHARDS, this.getActivePrimaryShards());
        builder.field(Fields.ACTIVE_SHARDS, this.getActiveShards());
        builder.field(Fields.RELOCATING_SHARDS, this.getRelocatingShards());
        builder.field(Fields.INITIALIZING_SHARDS, this.getInitializingShards());
        builder.field(Fields.UNASSIGNED_SHARDS, this.getUnassignedShards());
        String level = params.param("level", "cluster");
        boolean bl = outputIndices = "indices".equals(level) || "shards".equals(level);
        if (!this.getValidationFailures().isEmpty()) {
            builder.startArray(Fields.VALIDATION_FAILURES);
            for (String validationFailure : this.getValidationFailures()) {
                builder.value(validationFailure);
            }
            if (!outputIndices) {
                for (ClusterIndexHealth indexHealth : this.indices.values()) {
                    builder.startObject(indexHealth.getIndex());
                    if (!indexHealth.getValidationFailures().isEmpty()) {
                        builder.startArray(Fields.VALIDATION_FAILURES);
                        for (String validationFailure : indexHealth.getValidationFailures()) {
                            builder.value(validationFailure);
                        }
                        builder.endArray();
                    }
                    builder.endObject();
                }
            }
            builder.endArray();
        }
        if (outputIndices) {
            builder.startObject(Fields.INDICES);
            for (ClusterIndexHealth indexHealth : this.indices.values()) {
                builder.startObject(indexHealth.getIndex(), XContentBuilder.FieldCaseConversion.NONE);
                indexHealth.toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString CLUSTER_NAME = new XContentBuilderString("cluster_name");
        static final XContentBuilderString STATUS = new XContentBuilderString("status");
        static final XContentBuilderString TIMED_OUT = new XContentBuilderString("timed_out");
        static final XContentBuilderString NUMBER_OF_NODES = new XContentBuilderString("number_of_nodes");
        static final XContentBuilderString NUMBER_OF_DATA_NODES = new XContentBuilderString("number_of_data_nodes");
        static final XContentBuilderString ACTIVE_PRIMARY_SHARDS = new XContentBuilderString("active_primary_shards");
        static final XContentBuilderString ACTIVE_SHARDS = new XContentBuilderString("active_shards");
        static final XContentBuilderString RELOCATING_SHARDS = new XContentBuilderString("relocating_shards");
        static final XContentBuilderString INITIALIZING_SHARDS = new XContentBuilderString("initializing_shards");
        static final XContentBuilderString UNASSIGNED_SHARDS = new XContentBuilderString("unassigned_shards");
        static final XContentBuilderString VALIDATION_FAILURES = new XContentBuilderString("validation_failures");
        static final XContentBuilderString INDICES = new XContentBuilderString("indices");

        Fields() {
        }
    }
}

