/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.support.PlainListenableActionFuture;
import org.elasticsearch.client.internal.InternalGenericClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.transport.TransportRequest;

public abstract class ActionRequestBuilder<Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder> {
    protected final Request request;
    protected final InternalGenericClient client;

    protected ActionRequestBuilder(InternalGenericClient client, Request request) {
        this.client = client;
        this.request = request;
    }

    public Request request() {
        return this.request;
    }

    public final RequestBuilder setListenerThreaded(boolean listenerThreaded) {
        ((ActionRequest)this.request).listenerThreaded(listenerThreaded);
        return (RequestBuilder)this;
    }

    public final RequestBuilder putHeader(String key, Object value2) {
        ((TransportRequest)this.request).putHeader(key, value2);
        return (RequestBuilder)this;
    }

    public ListenableActionFuture<Response> execute() {
        PlainListenableActionFuture future = new PlainListenableActionFuture(((ActionRequest)this.request).listenerThreaded(), this.client.threadPool());
        this.execute(future);
        return future;
    }

    public Response get() throws ElasticSearchException {
        return (Response)((ActionResponse)this.execute().actionGet());
    }

    public Response get(TimeValue timeout) throws ElasticSearchException {
        return (Response)((ActionResponse)this.execute().actionGet(timeout));
    }

    public Response get(String timeout) throws ElasticSearchException {
        return (Response)((ActionResponse)this.execute().actionGet(timeout));
    }

    public void execute(ActionListener<Response> listener) {
        this.doExecute(listener);
    }

    protected abstract void doExecute(ActionListener<Response> var1);
}

