/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.util.Properties;
import org.elasticsearch.common.io.FastStringReader;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.common.joda.time.format.ISODateTimeFormat;

public class Build {
    public static final Build CURRENT;
    private String hash;
    private String hashShort;
    private String timestamp;

    Build(String hash, String hashShort, String timestamp) {
        this.hash = hash;
        this.hashShort = hashShort;
        this.timestamp = timestamp;
    }

    public String hash() {
        return this.hash;
    }

    public String hashShort() {
        return this.hashShort;
    }

    public String timestamp() {
        return this.timestamp;
    }

    static {
        String hash = "NA";
        String hashShort = "NA";
        String timestamp = "NA";
        try {
            String gitTimestampRaw;
            String properties = Streams.copyToStringFromClasspath("/es-build.properties");
            Properties props = new Properties();
            props.load(new FastStringReader(properties));
            hash = props.getProperty("hash", hash);
            if (!hash.equals("NA")) {
                hashShort = hash.substring(0, 7);
            }
            if ((gitTimestampRaw = props.getProperty("timestamp")) != null) {
                timestamp = ISODateTimeFormat.dateTimeNoMillis().withZone(DateTimeZone.UTC).print(Long.parseLong(gitTimestampRaw));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        CURRENT = new Build(hash, hashShort, timestamp);
    }
}

