/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.IllegalAddException;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.Text;
import org.dom4j.tree.AbstractElement;
import org.dom4j.tree.BackedList;
import org.dom4j.tree.ContentListFacade;
import org.dom4j.tree.DefaultText;

public class DefaultElement
extends AbstractElement {
    private static final transient DocumentFactory DOCUMENT_FACTORY = DocumentFactory.getInstance();
    private QName qname;
    private Branch parentBranch;
    private Object content;
    private Object attributes;

    public DefaultElement(String name) {
        this.qname = DOCUMENT_FACTORY.createQName(name);
    }

    public DefaultElement(QName qname) {
        this.qname = qname;
    }

    public DefaultElement(QName qname, int attributeCount) {
        this.qname = qname;
        if (attributeCount > 1) {
            this.attributes = new ArrayList(attributeCount);
        }
    }

    public DefaultElement(String name, Namespace namespace) {
        this.qname = DOCUMENT_FACTORY.createQName(name, namespace);
    }

    public Element getParent() {
        Element result2 = null;
        if (this.parentBranch instanceof Element) {
            result2 = (Element)this.parentBranch;
        }
        return result2;
    }

    public void setParent(Element parent) {
        if (this.parentBranch instanceof Element || parent != null) {
            this.parentBranch = parent;
        }
    }

    public Document getDocument() {
        if (this.parentBranch instanceof Document) {
            return (Document)this.parentBranch;
        }
        if (this.parentBranch instanceof Element) {
            Element parent = (Element)this.parentBranch;
            return parent.getDocument();
        }
        return null;
    }

    public void setDocument(Document document2) {
        if (this.parentBranch instanceof Document || document2 != null) {
            this.parentBranch = document2;
        }
    }

    public boolean supportsParent() {
        return true;
    }

    public QName getQName() {
        return this.qname;
    }

    public void setQName(QName name) {
        this.qname = name;
    }

    public String getText() {
        Object contentShadow = this.content;
        if (contentShadow instanceof List) {
            return super.getText();
        }
        if (contentShadow != null) {
            return this.getContentAsText(contentShadow);
        }
        return "";
    }

    public String getStringValue() {
        Object contentShadow = this.content;
        if (contentShadow instanceof List) {
            List list2 = (List)contentShadow;
            int size2 = list2.size();
            if (size2 > 0) {
                if (size2 == 1) {
                    return this.getContentAsStringValue(list2.get(0));
                }
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < size2; ++i) {
                    Object node = list2.get(i);
                    String string2 = this.getContentAsStringValue(node);
                    if (string2.length() <= 0) continue;
                    buffer.append(string2);
                }
                return buffer.toString();
            }
        } else if (contentShadow != null) {
            return this.getContentAsStringValue(contentShadow);
        }
        return "";
    }

    public Object clone() {
        DefaultElement answer = (DefaultElement)super.clone();
        if (answer != this) {
            answer.content = null;
            answer.attributes = null;
            answer.appendAttributes(this);
            answer.appendContent(this);
        }
        return answer;
    }

    public Namespace getNamespaceForPrefix(String prefix) {
        Namespace answer;
        Element parent;
        Namespace namespace;
        if (prefix == null) {
            prefix = "";
        }
        if (prefix.equals(this.getNamespacePrefix())) {
            return this.getNamespace();
        }
        if (prefix.equals("xml")) {
            return Namespace.XML_NAMESPACE;
        }
        Object contentShadow = this.content;
        if (contentShadow instanceof List) {
            List list2 = (List)contentShadow;
            int size2 = list2.size();
            for (int i = 0; i < size2; ++i) {
                Namespace namespace2;
                Object object = list2.get(i);
                if (!(object instanceof Namespace) || !prefix.equals((namespace2 = (Namespace)object).getPrefix())) continue;
                return namespace2;
            }
        } else if (contentShadow instanceof Namespace && prefix.equals((namespace = (Namespace)contentShadow).getPrefix())) {
            return namespace;
        }
        if ((parent = this.getParent()) != null && (answer = parent.getNamespaceForPrefix(prefix)) != null) {
            return answer;
        }
        if (prefix == null || prefix.length() <= 0) {
            return Namespace.NO_NAMESPACE;
        }
        return null;
    }

    public Namespace getNamespaceForURI(String uri) {
        Element parent;
        Namespace namespace;
        if (uri == null || uri.length() <= 0) {
            return Namespace.NO_NAMESPACE;
        }
        if (uri.equals(this.getNamespaceURI())) {
            return this.getNamespace();
        }
        Object contentShadow = this.content;
        if (contentShadow instanceof List) {
            List list2 = (List)contentShadow;
            int size2 = list2.size();
            for (int i = 0; i < size2; ++i) {
                Namespace namespace2;
                Object object = list2.get(i);
                if (!(object instanceof Namespace) || !uri.equals((namespace2 = (Namespace)object).getURI())) continue;
                return namespace2;
            }
        } else if (contentShadow instanceof Namespace && uri.equals((namespace = (Namespace)contentShadow).getURI())) {
            return namespace;
        }
        if ((parent = this.getParent()) != null) {
            return parent.getNamespaceForURI(uri);
        }
        return null;
    }

    public List declaredNamespaces() {
        BackedList answer = this.createResultList();
        Object contentShadow = this.content;
        if (contentShadow instanceof List) {
            List list2 = (List)contentShadow;
            int size2 = list2.size();
            for (int i = 0; i < size2; ++i) {
                Object object = list2.get(i);
                if (!(object instanceof Namespace)) continue;
                answer.addLocal(object);
            }
        } else if (contentShadow instanceof Namespace) {
            answer.addLocal(contentShadow);
        }
        return answer;
    }

    public List additionalNamespaces() {
        Object contentShadow = this.content;
        if (contentShadow instanceof List) {
            List list2 = (List)contentShadow;
            int size2 = list2.size();
            BackedList answer = this.createResultList();
            for (int i = 0; i < size2; ++i) {
                Namespace namespace;
                Object object = list2.get(i);
                if (!(object instanceof Namespace) || (namespace = (Namespace)object).equals(this.getNamespace())) continue;
                answer.addLocal(namespace);
            }
            return answer;
        }
        if (contentShadow instanceof Namespace) {
            Namespace namespace = (Namespace)contentShadow;
            if (namespace.equals(this.getNamespace())) {
                return this.createEmptyList();
            }
            return this.createSingleResultList(namespace);
        }
        return this.createEmptyList();
    }

    public List additionalNamespaces(String defaultNamespaceURI) {
        Namespace namespace;
        Object contentShadow = this.content;
        if (contentShadow instanceof List) {
            List list2 = (List)contentShadow;
            BackedList answer = this.createResultList();
            int size2 = list2.size();
            for (int i = 0; i < size2; ++i) {
                Namespace namespace2;
                Object object = list2.get(i);
                if (!(object instanceof Namespace) || defaultNamespaceURI.equals((namespace2 = (Namespace)object).getURI())) continue;
                answer.addLocal(namespace2);
            }
            return answer;
        }
        if (contentShadow instanceof Namespace && !defaultNamespaceURI.equals((namespace = (Namespace)contentShadow).getURI())) {
            return this.createSingleResultList(namespace);
        }
        return this.createEmptyList();
    }

    public List processingInstructions() {
        Object contentShadow = this.content;
        if (contentShadow instanceof List) {
            List list2 = (List)contentShadow;
            BackedList answer = this.createResultList();
            int size2 = list2.size();
            for (int i = 0; i < size2; ++i) {
                Object object = list2.get(i);
                if (!(object instanceof ProcessingInstruction)) continue;
                answer.addLocal(object);
            }
            return answer;
        }
        if (contentShadow instanceof ProcessingInstruction) {
            return this.createSingleResultList(contentShadow);
        }
        return this.createEmptyList();
    }

    public List processingInstructions(String target) {
        ProcessingInstruction pi;
        Object shadow = this.content;
        if (shadow instanceof List) {
            List list2 = (List)shadow;
            BackedList answer = this.createResultList();
            int size2 = list2.size();
            for (int i = 0; i < size2; ++i) {
                ProcessingInstruction pi2;
                Object object = list2.get(i);
                if (!(object instanceof ProcessingInstruction) || !target.equals((pi2 = (ProcessingInstruction)object).getName())) continue;
                answer.addLocal(pi2);
            }
            return answer;
        }
        if (shadow instanceof ProcessingInstruction && target.equals((pi = (ProcessingInstruction)shadow).getName())) {
            return this.createSingleResultList(pi);
        }
        return this.createEmptyList();
    }

    public ProcessingInstruction processingInstruction(String target) {
        ProcessingInstruction pi;
        Object shadow = this.content;
        if (shadow instanceof List) {
            List list2 = (List)shadow;
            int size2 = list2.size();
            for (int i = 0; i < size2; ++i) {
                ProcessingInstruction pi2;
                Object object = list2.get(i);
                if (!(object instanceof ProcessingInstruction) || !target.equals((pi2 = (ProcessingInstruction)object).getName())) continue;
                return pi2;
            }
        } else if (shadow instanceof ProcessingInstruction && target.equals((pi = (ProcessingInstruction)shadow).getName())) {
            return pi;
        }
        return null;
    }

    public boolean removeProcessingInstruction(String target) {
        ProcessingInstruction pi;
        Object shadow = this.content;
        if (shadow instanceof List) {
            List list2 = (List)shadow;
            Iterator iter2 = list2.iterator();
            while (iter2.hasNext()) {
                ProcessingInstruction pi2;
                Object object = iter2.next();
                if (!(object instanceof ProcessingInstruction) || !target.equals((pi2 = (ProcessingInstruction)object).getName())) continue;
                iter2.remove();
                return true;
            }
        } else if (shadow instanceof ProcessingInstruction && target.equals((pi = (ProcessingInstruction)shadow).getName())) {
            this.content = null;
            return true;
        }
        return false;
    }

    public Element element(String name) {
        Element element;
        Object contentShadow = this.content;
        if (contentShadow instanceof List) {
            List list2 = (List)contentShadow;
            int size2 = list2.size();
            for (int i = 0; i < size2; ++i) {
                Element element2;
                Object object = list2.get(i);
                if (!(object instanceof Element) || !name.equals((element2 = (Element)object).getName())) continue;
                return element2;
            }
        } else if (contentShadow instanceof Element && name.equals((element = (Element)contentShadow).getName())) {
            return element;
        }
        return null;
    }

    public Element element(QName qName) {
        Element element;
        Object contentShadow = this.content;
        if (contentShadow instanceof List) {
            List list2 = (List)contentShadow;
            int size2 = list2.size();
            for (int i = 0; i < size2; ++i) {
                Element element2;
                Object object = list2.get(i);
                if (!(object instanceof Element) || !qName.equals((element2 = (Element)object).getQName())) continue;
                return element2;
            }
        } else if (contentShadow instanceof Element && qName.equals((element = (Element)contentShadow).getQName())) {
            return element;
        }
        return null;
    }

    public Element element(String name, Namespace namespace) {
        return this.element(this.getDocumentFactory().createQName(name, namespace));
    }

    public void setContent(List content) {
        this.contentRemoved();
        if (content instanceof ContentListFacade) {
            content = ((ContentListFacade)content).getBackingList();
        }
        if (content == null) {
            this.content = null;
        } else {
            int size2 = content.size();
            List newContent = this.createContentList(size2);
            for (int i = 0; i < size2; ++i) {
                Object object = content.get(i);
                if (object instanceof Node) {
                    Node node = (Node)object;
                    Element parent = node.getParent();
                    if (parent != null && parent != this) {
                        node = (Node)node.clone();
                    }
                    newContent.add(node);
                    this.childAdded(node);
                    continue;
                }
                if (object == null) continue;
                String text2 = object.toString();
                Text node = this.getDocumentFactory().createText(text2);
                newContent.add(node);
                this.childAdded(node);
            }
            this.content = newContent;
        }
    }

    public void clearContent() {
        if (this.content != null) {
            this.contentRemoved();
            this.content = null;
        }
    }

    public Node node(int index) {
        if (index >= 0) {
            Object node;
            Object contentShadow = this.content;
            if (contentShadow instanceof List) {
                List list2 = (List)contentShadow;
                if (index >= list2.size()) {
                    return null;
                }
                node = list2.get(index);
            } else {
                Object object = node = index == 0 ? contentShadow : null;
            }
            if (node != null) {
                if (node instanceof Node) {
                    return (Node)node;
                }
                return new DefaultText(node.toString());
            }
        }
        return null;
    }

    public int indexOf(Node node) {
        Object contentShadow = this.content;
        if (contentShadow instanceof List) {
            List list2 = (List)contentShadow;
            return list2.indexOf(node);
        }
        if (contentShadow != null && contentShadow.equals(node)) {
            return 0;
        }
        return -1;
    }

    public int nodeCount() {
        Object contentShadow = this.content;
        if (contentShadow instanceof List) {
            List list2 = (List)contentShadow;
            return list2.size();
        }
        return contentShadow != null ? 1 : 0;
    }

    public Iterator nodeIterator() {
        Object contentShadow = this.content;
        if (contentShadow instanceof List) {
            List list2 = (List)contentShadow;
            return list2.iterator();
        }
        if (contentShadow != null) {
            return this.createSingleIterator(contentShadow);
        }
        return EMPTY_ITERATOR;
    }

    public List attributes() {
        return new ContentListFacade(this, this.attributeList());
    }

    public void setAttributes(List attributes) {
        if (attributes instanceof ContentListFacade) {
            attributes = ((ContentListFacade)attributes).getBackingList();
        }
        this.attributes = attributes;
    }

    public Iterator attributeIterator() {
        Object attributesShadow = this.attributes;
        if (attributesShadow instanceof List) {
            List list2 = (List)attributesShadow;
            return list2.iterator();
        }
        if (attributesShadow != null) {
            return this.createSingleIterator(attributesShadow);
        }
        return EMPTY_ITERATOR;
    }

    public Attribute attribute(int index) {
        Object attributesShadow = this.attributes;
        if (attributesShadow instanceof List) {
            List list2 = (List)attributesShadow;
            return (Attribute)list2.get(index);
        }
        if (attributesShadow != null && index == 0) {
            return (Attribute)attributesShadow;
        }
        return null;
    }

    public int attributeCount() {
        Object attributesShadow = this.attributes;
        if (attributesShadow instanceof List) {
            List list2 = (List)attributesShadow;
            return list2.size();
        }
        return attributesShadow != null ? 1 : 0;
    }

    public Attribute attribute(String name) {
        Attribute attribute;
        Object attributesShadow = this.attributes;
        if (attributesShadow instanceof List) {
            List list2 = (List)attributesShadow;
            int size2 = list2.size();
            for (int i = 0; i < size2; ++i) {
                Attribute attribute2 = (Attribute)list2.get(i);
                if (!name.equals(attribute2.getName())) continue;
                return attribute2;
            }
        } else if (attributesShadow != null && name.equals((attribute = (Attribute)attributesShadow).getName())) {
            return attribute;
        }
        return null;
    }

    public Attribute attribute(QName qName) {
        Attribute attribute;
        Object attributesShadow = this.attributes;
        if (attributesShadow instanceof List) {
            List list2 = (List)attributesShadow;
            int size2 = list2.size();
            for (int i = 0; i < size2; ++i) {
                Attribute attribute2 = (Attribute)list2.get(i);
                if (!qName.equals(attribute2.getQName())) continue;
                return attribute2;
            }
        } else if (attributesShadow != null && qName.equals((attribute = (Attribute)attributesShadow).getQName())) {
            return attribute;
        }
        return null;
    }

    public Attribute attribute(String name, Namespace namespace) {
        return this.attribute(this.getDocumentFactory().createQName(name, namespace));
    }

    public void add(Attribute attribute) {
        if (attribute.getParent() != null) {
            String message = "The Attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"";
            throw new IllegalAddException(this, (Node)attribute, message);
        }
        if (attribute.getValue() == null) {
            Attribute oldAttribute = this.attribute(attribute.getQName());
            if (oldAttribute != null) {
                this.remove(oldAttribute);
            }
        } else {
            if (this.attributes == null) {
                this.attributes = attribute;
            } else {
                this.attributeList().add(attribute);
            }
            this.childAdded(attribute);
        }
    }

    public boolean remove(Attribute attribute) {
        boolean answer = false;
        Object attributesShadow = this.attributes;
        if (attributesShadow instanceof List) {
            Attribute copy;
            List list2 = (List)attributesShadow;
            answer = list2.remove(attribute);
            if (!answer && (copy = this.attribute(attribute.getQName())) != null) {
                list2.remove(copy);
                answer = true;
            }
        } else if (attributesShadow != null) {
            if (attribute.equals(attributesShadow)) {
                this.attributes = null;
                answer = true;
            } else {
                Attribute other = (Attribute)attributesShadow;
                if (attribute.getQName().equals(other.getQName())) {
                    this.attributes = null;
                    answer = true;
                }
            }
        }
        if (answer) {
            this.childRemoved(attribute);
        }
        return answer;
    }

    protected void addNewNode(Node node) {
        Object contentShadow = this.content;
        if (contentShadow == null) {
            this.content = node;
        } else if (contentShadow instanceof List) {
            List list2 = (List)contentShadow;
            list2.add(node);
        } else {
            List list3 = this.createContentList();
            list3.add(contentShadow);
            list3.add(node);
            this.content = list3;
        }
        this.childAdded(node);
    }

    protected boolean removeNode(Node node) {
        boolean answer = false;
        Object contentShadow = this.content;
        if (contentShadow != null) {
            if (contentShadow == node) {
                this.content = null;
                answer = true;
            } else if (contentShadow instanceof List) {
                List list2 = (List)contentShadow;
                answer = list2.remove(node);
            }
        }
        if (answer) {
            this.childRemoved(node);
        }
        return answer;
    }

    protected List contentList() {
        Object contentShadow = this.content;
        if (contentShadow instanceof List) {
            return (List)contentShadow;
        }
        List list2 = this.createContentList();
        if (contentShadow != null) {
            list2.add(contentShadow);
        }
        this.content = list2;
        return list2;
    }

    protected List attributeList() {
        Object attributesShadow = this.attributes;
        if (attributesShadow instanceof List) {
            return (List)attributesShadow;
        }
        if (attributesShadow != null) {
            List list2 = this.createAttributeList();
            list2.add(attributesShadow);
            this.attributes = list2;
            return list2;
        }
        List list3 = this.createAttributeList();
        this.attributes = list3;
        return list3;
    }

    protected List attributeList(int size2) {
        Object attributesShadow = this.attributes;
        if (attributesShadow instanceof List) {
            return (List)attributesShadow;
        }
        if (attributesShadow != null) {
            List list2 = this.createAttributeList(size2);
            list2.add(attributesShadow);
            this.attributes = list2;
            return list2;
        }
        List list3 = this.createAttributeList(size2);
        this.attributes = list3;
        return list3;
    }

    protected void setAttributeList(List attributeList) {
        this.attributes = attributeList;
    }

    protected DocumentFactory getDocumentFactory() {
        DocumentFactory factory = this.qname.getDocumentFactory();
        return factory != null ? factory : DOCUMENT_FACTORY;
    }
}

