/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.stc;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.ast.tools.WideningCategories;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.runtime.m12n.ExtensionModule;
import org.codehaus.groovy.runtime.m12n.ExtensionModuleScanner;
import org.codehaus.groovy.runtime.m12n.MetaInfExtensionModule;
import org.codehaus.groovy.runtime.metaclass.MetaClassRegistryImpl;
import org.codehaus.groovy.tools.GroovyClass;
import org.codehaus.groovy.transform.stc.ExtensionMethodNode;
import org.codehaus.groovy.transform.stc.UnionTypeClassNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StaticTypeCheckingSupport {
    protected static final ClassNode Collection_TYPE = ClassHelper.makeWithoutCaching(Collection.class);
    protected static final ClassNode Deprecated_TYPE = ClassHelper.makeWithoutCaching(Deprecated.class);
    protected static final ClassNode Matcher_TYPE = ClassHelper.makeWithoutCaching(Matcher.class);
    protected static final ClassNode ArrayList_TYPE = ClassHelper.makeWithoutCaching(ArrayList.class);
    protected static final ExtensionMethodCache EXTENSION_METHOD_CACHE = new ExtensionMethodCache();
    protected static final Map<ClassNode, Integer> NUMBER_TYPES = Collections.unmodifiableMap(new HashMap<ClassNode, Integer>(){
        {
            this.put(ClassHelper.byte_TYPE, 0);
            this.put(ClassHelper.Byte_TYPE, 0);
            this.put(ClassHelper.short_TYPE, 1);
            this.put(ClassHelper.Short_TYPE, 1);
            this.put(ClassHelper.int_TYPE, 2);
            this.put(ClassHelper.Integer_TYPE, 2);
            this.put(ClassHelper.Long_TYPE, 3);
            this.put(ClassHelper.long_TYPE, 3);
            this.put(ClassHelper.float_TYPE, 4);
            this.put(ClassHelper.Float_TYPE, 4);
            this.put(ClassHelper.double_TYPE, 5);
            this.put(ClassHelper.Double_TYPE, 5);
        }
    });
    protected static final ClassNode GSTRING_STRING_CLASSNODE = WideningCategories.lowestUpperBound(ClassHelper.STRING_TYPE, ClassHelper.GSTRING_TYPE);
    protected static final ClassNode UNKNOWN_PARAMETER_TYPE = ClassHelper.make("<unknown parameter type>");
    protected static final Comparator<MethodNode> DGM_METHOD_NODE_COMPARATOR = new Comparator<MethodNode>(){

        @Override
        public int compare(MethodNode o1, MethodNode o2) {
            if (o1.getName().equals(o2.getName())) {
                Parameter[] o2ps;
                Parameter[] o1ps = o1.getParameters();
                if (o1ps.length == (o2ps = o2.getParameters()).length) {
                    boolean allEqual = true;
                    for (int i = 0; i < o1ps.length && allEqual; ++i) {
                        allEqual = o1ps[i].getType().equals(o2ps[i].getType());
                    }
                    if (allEqual) {
                        if (o1 instanceof ExtensionMethodNode && o2 instanceof ExtensionMethodNode) {
                            return this.compare(((ExtensionMethodNode)o1).getExtensionMethodNode(), ((ExtensionMethodNode)o2).getExtensionMethodNode());
                        }
                        return 0;
                    }
                } else {
                    return o1ps.length - o2ps.length;
                }
            }
            return 1;
        }
    };

    protected static boolean isArrayAccessExpression(Expression expression) {
        return expression instanceof BinaryExpression && StaticTypeCheckingSupport.isArrayOp(((BinaryExpression)expression).getOperation().getType());
    }

    public static boolean isWithCall(String name, Expression callArguments) {
        boolean isWithCall;
        boolean bl = isWithCall = "with".equals(name) && callArguments instanceof ArgumentListExpression;
        if (isWithCall) {
            ArgumentListExpression argList = (ArgumentListExpression)callArguments;
            List<Expression> expressions = argList.getExpressions();
            isWithCall = expressions.size() == 1 && expressions.get(0) instanceof ClosureExpression;
        }
        return isWithCall;
    }

    protected static Variable findTargetVariable(VariableExpression ve) {
        Variable accessedVariable;
        Variable variable = accessedVariable = ve.getAccessedVariable() != null ? ve.getAccessedVariable() : ve;
        if (accessedVariable != ve && accessedVariable instanceof VariableExpression) {
            return StaticTypeCheckingSupport.findTargetVariable(accessedVariable);
        }
        return accessedVariable;
    }

    @Deprecated
    protected static Set<MethodNode> findDGMMethodsForClassNode(ClassNode clazz, String name) {
        return StaticTypeCheckingSupport.findDGMMethodsForClassNode(MetaClassRegistryImpl.class.getClassLoader(), clazz, name);
    }

    protected static Set<MethodNode> findDGMMethodsForClassNode(ClassLoader loader, ClassNode clazz, String name) {
        TreeSet<MethodNode> accumulator = new TreeSet<MethodNode>(DGM_METHOD_NODE_COMPARATOR);
        StaticTypeCheckingSupport.findDGMMethodsForClassNode(loader, clazz, name, accumulator);
        return accumulator;
    }

    @Deprecated
    protected static void findDGMMethodsForClassNode(ClassNode clazz, String name, TreeSet<MethodNode> accumulator) {
        StaticTypeCheckingSupport.findDGMMethodsForClassNode(MetaClassRegistryImpl.class.getClassLoader(), clazz, name, accumulator);
    }

    protected static void findDGMMethodsForClassNode(ClassLoader loader, ClassNode clazz, String name, TreeSet<MethodNode> accumulator) {
        ClassNode componentClass;
        List<MethodNode> fromDGM = EXTENSION_METHOD_CACHE.getExtensionMethods(loader).get(clazz.getName());
        if (fromDGM != null) {
            for (MethodNode node : fromDGM) {
                if (!node.getName().equals(name)) continue;
                accumulator.add(node);
            }
        }
        for (ClassNode node : clazz.getInterfaces()) {
            StaticTypeCheckingSupport.findDGMMethodsForClassNode(loader, node, name, accumulator);
        }
        if (clazz.isArray() && !(componentClass = clazz.getComponentType()).equals(ClassHelper.OBJECT_TYPE) && !ClassHelper.isPrimitiveType(componentClass)) {
            if (componentClass.isInterface()) {
                StaticTypeCheckingSupport.findDGMMethodsForClassNode(loader, ClassHelper.OBJECT_TYPE.makeArray(), name, accumulator);
            } else {
                StaticTypeCheckingSupport.findDGMMethodsForClassNode(loader, componentClass.getSuperClass().makeArray(), name, accumulator);
            }
        }
        if (clazz.getSuperClass() != null) {
            StaticTypeCheckingSupport.findDGMMethodsForClassNode(loader, clazz.getSuperClass(), name, accumulator);
        } else if (!clazz.equals(ClassHelper.OBJECT_TYPE)) {
            StaticTypeCheckingSupport.findDGMMethodsForClassNode(loader, ClassHelper.OBJECT_TYPE, name, accumulator);
        }
    }

    public static int allParametersAndArgumentsMatch(Parameter[] params, ClassNode[] args) {
        if (params == null) {
            params = Parameter.EMPTY_ARRAY;
        }
        int dist = 0;
        if (args.length < params.length) {
            return -1;
        }
        for (int i = 0; i < params.length; ++i) {
            ClassNode argType = args[i];
            ClassNode paramType = params[i].getType();
            if (!StaticTypeCheckingSupport.isAssignableTo(argType, paramType)) {
                return -1;
            }
            if (paramType.equals(argType)) continue;
            dist += StaticTypeCheckingSupport.getDistance(argType, paramType);
        }
        return dist;
    }

    static int allParametersAndArgumentsMatchWithDefaultParams(Parameter[] params, ClassNode[] args) {
        int dist = 0;
        ClassNode ptype = null;
        int j = 0;
        for (int i = 0; i < params.length; ++i) {
            ClassNode arg;
            Parameter param2 = params[i];
            ClassNode paramType = param2.getType();
            ClassNode classNode = arg = j >= args.length ? null : args[j];
            if (arg == null || !StaticTypeCheckingSupport.isAssignableTo(arg, paramType)) {
                if (!(param2.hasInitialExpression() || ptype != null && ptype.equals(paramType))) {
                    return -1;
                }
                ptype = null;
                continue;
            }
            ++j;
            if (!paramType.equals(arg)) {
                dist += StaticTypeCheckingSupport.getDistance(arg, paramType);
            }
            ptype = param2.hasInitialExpression() ? arg : null;
        }
        return dist;
    }

    static int excessArgumentsMatchesVargsParameter(Parameter[] params, ClassNode[] args) {
        int dist = 0;
        ClassNode vargsBase = params[params.length - 1].getType().getComponentType();
        for (int i = params.length; i < args.length; ++i) {
            if (!StaticTypeCheckingSupport.isAssignableTo(args[i], vargsBase)) {
                return -1;
            }
            if (args[i].equals(vargsBase)) continue;
            dist += StaticTypeCheckingSupport.getDistance(args[i], vargsBase);
        }
        return dist;
    }

    static int lastArgMatchesVarg(Parameter[] params, ClassNode ... args) {
        if (!StaticTypeCheckingSupport.isVargs(params)) {
            return -1;
        }
        ClassNode ptype = params[params.length - 1].getType().getComponentType();
        ClassNode arg = args[args.length - 1];
        if (ClassHelper.isNumberType(ptype) && ClassHelper.isNumberType(arg) && !ptype.equals(arg)) {
            return -1;
        }
        return StaticTypeCheckingSupport.isAssignableTo(arg, ptype) ? StaticTypeCheckingSupport.getDistance(arg, ptype) : -1;
    }

    static boolean isAssignableTo(ClassNode type, ClassNode toBeAssignedTo) {
        if (UNKNOWN_PARAMETER_TYPE == type) {
            return true;
        }
        if (type == toBeAssignedTo) {
            return true;
        }
        if (toBeAssignedTo.redirect() == ClassHelper.STRING_TYPE && type.redirect() == ClassHelper.GSTRING_TYPE) {
            return true;
        }
        if (ClassHelper.isPrimitiveType(toBeAssignedTo)) {
            toBeAssignedTo = ClassHelper.getWrapper(toBeAssignedTo);
        }
        if (ClassHelper.isPrimitiveType(type)) {
            type = ClassHelper.getWrapper(type);
        }
        if (ClassHelper.Double_TYPE == toBeAssignedTo) {
            return type.isDerivedFrom(ClassHelper.Number_TYPE);
        }
        if (ClassHelper.Float_TYPE == toBeAssignedTo) {
            return type.isDerivedFrom(ClassHelper.Number_TYPE) && ClassHelper.Double_TYPE != type.redirect();
        }
        if (ClassHelper.Long_TYPE == toBeAssignedTo) {
            return type.isDerivedFrom(ClassHelper.Number_TYPE) && ClassHelper.Double_TYPE != type.redirect() && ClassHelper.Float_TYPE != type.redirect();
        }
        if (ClassHelper.Integer_TYPE == toBeAssignedTo) {
            return type.isDerivedFrom(ClassHelper.Number_TYPE) && ClassHelper.Double_TYPE != type.redirect() && ClassHelper.Float_TYPE != type.redirect() && ClassHelper.Long_TYPE != type.redirect();
        }
        if (ClassHelper.Short_TYPE == toBeAssignedTo) {
            return type.isDerivedFrom(ClassHelper.Number_TYPE) && ClassHelper.Double_TYPE != type.redirect() && ClassHelper.Float_TYPE != type.redirect() && ClassHelper.Long_TYPE != type.redirect() && ClassHelper.Integer_TYPE != type.redirect();
        }
        if (ClassHelper.Byte_TYPE == toBeAssignedTo) {
            return type.redirect() == ClassHelper.Byte_TYPE;
        }
        if (type.isArray() && toBeAssignedTo.isArray()) {
            return StaticTypeCheckingSupport.isAssignableTo(type.getComponentType(), toBeAssignedTo.getComponentType());
        }
        if (type.isDerivedFrom(ClassHelper.GSTRING_TYPE) && ClassHelper.STRING_TYPE.equals(toBeAssignedTo)) {
            return true;
        }
        if (toBeAssignedTo.isDerivedFrom(ClassHelper.GSTRING_TYPE) && ClassHelper.STRING_TYPE.equals(type)) {
            return true;
        }
        if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(type, toBeAssignedTo)) {
            if (ClassHelper.OBJECT_TYPE.equals(toBeAssignedTo)) {
                return true;
            }
            if (toBeAssignedTo.isUsingGenerics()) {
                GenericsType gt = GenericsUtils.buildWildcardType(toBeAssignedTo);
                return gt.isCompatibleWith(type);
            }
            return true;
        }
        return false;
    }

    static boolean isVargs(Parameter[] params) {
        if (params.length == 0) {
            return false;
        }
        return params[params.length - 1].getType().isArray();
    }

    static boolean isCompareToBoolean(int op) {
        return op == 126 || op == 127 || op == 124 || op == 125;
    }

    static boolean isArrayOp(int op) {
        return op == 30;
    }

    static boolean isBoolIntrinsicOp(int op) {
        return op == 164 || op == 162 || op == 94 || op == 544;
    }

    static boolean isPowerOperator(int op) {
        return op == 206 || op == 216;
    }

    static String getOperationName(int op) {
        switch (op) {
            case 120: 
            case 123: {
                return "equals";
            }
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: {
                return "compareTo";
            }
            case 341: 
            case 351: {
                return "and";
            }
            case 340: 
            case 350: {
                return "or";
            }
            case 342: 
            case 352: {
                return "xor";
            }
            case 200: 
            case 210: {
                return "plus";
            }
            case 201: 
            case 211: {
                return "minus";
            }
            case 202: 
            case 212: {
                return "multiply";
            }
            case 203: 
            case 213: {
                return "div";
            }
            case 204: 
            case 214: {
                return "intdiv";
            }
            case 205: 
            case 215: {
                return "mod";
            }
            case 206: 
            case 216: {
                return "power";
            }
            case 280: 
            case 285: {
                return "leftShift";
            }
            case 281: 
            case 286: {
                return "rightShift";
            }
            case 282: 
            case 287: {
                return "rightShiftUnsigned";
            }
            case 573: {
                return "isCase";
            }
        }
        return null;
    }

    static boolean isShiftOperation(String name) {
        return "leftShift".equals(name) || "rightShift".equals(name) || "rightShiftUnsigned".equals(name);
    }

    static boolean isOperationInGroup(int op) {
        switch (op) {
            case 200: 
            case 201: 
            case 202: 
            case 210: 
            case 211: 
            case 212: {
                return true;
            }
        }
        return false;
    }

    static boolean isBitOperator(int op) {
        switch (op) {
            case 340: 
            case 341: 
            case 342: 
            case 350: 
            case 351: 
            case 352: {
                return true;
            }
        }
        return false;
    }

    public static boolean isAssignment(int op) {
        switch (op) {
            case 100: 
            case 166: 
            case 168: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 285: 
            case 286: 
            case 287: 
            case 350: 
            case 351: 
            case 352: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkCompatibleAssignmentTypes(ClassNode left, ClassNode right) {
        return StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(left, right, null);
    }

    public static boolean checkCompatibleAssignmentTypes(ClassNode left, ClassNode right, Expression rightExpression) {
        return StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(left, right, rightExpression, true);
    }

    public static boolean checkCompatibleAssignmentTypes(ClassNode left, ClassNode right, Expression rightExpression, boolean allowConstructorCoercion) {
        boolean rightExpressionIsNull;
        ClassNode rightRedirect;
        ClassNode leftRedirect = left.redirect();
        if (leftRedirect == (rightRedirect = right.redirect())) {
            return true;
        }
        if (leftRedirect.isArray() && rightRedirect.isArray()) {
            return StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(leftRedirect.getComponentType(), rightRedirect.getComponentType(), rightExpression, allowConstructorCoercion);
        }
        if (right == ClassHelper.VOID_TYPE || right == ClassHelper.void_WRAPPER_TYPE) {
            return left == ClassHelper.VOID_TYPE || left == ClassHelper.void_WRAPPER_TYPE;
        }
        if (ClassHelper.isNumberType(rightRedirect) || WideningCategories.isNumberCategory(rightRedirect)) {
            if (ClassHelper.BigDecimal_TYPE == leftRedirect) {
                return true;
            }
            if (ClassHelper.BigInteger_TYPE == leftRedirect) {
                return WideningCategories.isBigIntCategory(ClassHelper.getUnwrapper(rightRedirect));
            }
        }
        boolean bl = rightExpressionIsNull = rightExpression instanceof ConstantExpression && ((ConstantExpression)rightExpression).getValue() == null;
        if (rightExpressionIsNull && !ClassHelper.isPrimitiveType(left)) {
            return true;
        }
        if (!(!StaticTypeCheckingSupport.isWildcardLeftHandSide(leftRedirect) || ClassHelper.boolean_TYPE.equals(left) && rightExpressionIsNull)) {
            return true;
        }
        if (leftRedirect == ClassHelper.char_TYPE && rightRedirect == ClassHelper.STRING_TYPE && rightExpression != null && rightExpression instanceof ConstantExpression) {
            String value2 = rightExpression.getText();
            return value2.length() == 1;
        }
        if (leftRedirect == ClassHelper.Character_TYPE && (rightRedirect == ClassHelper.STRING_TYPE || rightExpressionIsNull)) {
            return rightExpressionIsNull || rightExpression instanceof ConstantExpression && rightExpression.getText().length() == 1;
        }
        if (leftRedirect.isDerivedFrom(ClassHelper.Enum_Type) && (rightRedirect == ClassHelper.GSTRING_TYPE || rightRedirect == ClassHelper.STRING_TYPE)) {
            return true;
        }
        if (allowConstructorCoercion && (rightRedirect.implementsInterface(ClassHelper.MAP_TYPE) || rightRedirect.implementsInterface(Collection_TYPE) || rightRedirect.equals(ClassHelper.MAP_TYPE) || rightRedirect.equals(Collection_TYPE) || rightRedirect.isArray())) {
            if (leftRedirect.isArray() && rightRedirect.isArray()) {
                return StaticTypeCheckingSupport.checkCompatibleAssignmentTypes(leftRedirect.getComponentType(), rightRedirect.getComponentType());
            }
            return !rightRedirect.isArray() || leftRedirect.isArray();
        }
        if (right.isDerivedFrom(left) || left.isInterface() && right.implementsInterface(left)) {
            return true;
        }
        if (ClassHelper.isPrimitiveType(leftRedirect) && ClassHelper.isPrimitiveType(rightRedirect)) {
            return true;
        }
        if (ClassHelper.isNumberType(leftRedirect) && ClassHelper.isNumberType(rightRedirect)) {
            return true;
        }
        if (WideningCategories.isFloatingCategory(leftRedirect) && ClassHelper.BigDecimal_TYPE.equals(rightRedirect)) {
            return true;
        }
        return ClassHelper.GROOVY_OBJECT_TYPE.equals(leftRedirect) && StaticTypeCheckingSupport.isBeingCompiled(right);
    }

    public static boolean isWildcardLeftHandSide(ClassNode node) {
        return ClassHelper.OBJECT_TYPE.equals(node) || ClassHelper.STRING_TYPE.equals(node) || ClassHelper.boolean_TYPE.equals(node) || ClassHelper.Boolean_TYPE.equals(node) || ClassHelper.CLASS_Type.equals(node);
    }

    public static boolean isBeingCompiled(ClassNode node) {
        return node.getCompileUnit() != null;
    }

    static boolean checkPossibleLooseOfPrecision(ClassNode left, ClassNode right, Expression rightExpr) {
        int rightIndex;
        if (left == right || left.equals(right)) {
            return false;
        }
        int leftIndex = NUMBER_TYPES.get(left);
        if (leftIndex >= (rightIndex = NUMBER_TYPES.get(right).intValue())) {
            return false;
        }
        if (rightExpr instanceof ConstantExpression) {
            Object value2 = ((ConstantExpression)rightExpr).getValue();
            if (!(value2 instanceof Number)) {
                return true;
            }
            Number number2 = (Number)value2;
            switch (leftIndex) {
                case 0: {
                    byte val = number2.byteValue();
                    if (number2 instanceof Short) {
                        return !Short.valueOf(val).equals(number2);
                    }
                    if (number2 instanceof Integer) {
                        return !Integer.valueOf(val).equals(number2);
                    }
                    if (number2 instanceof Long) {
                        return !Long.valueOf(val).equals(number2);
                    }
                    if (number2 instanceof Float) {
                        return !Float.valueOf(val).equals(number2);
                    }
                    return !Double.valueOf(val).equals(number2);
                }
                case 1: {
                    short val = number2.shortValue();
                    if (number2 instanceof Integer) {
                        return !Integer.valueOf(val).equals(number2);
                    }
                    if (number2 instanceof Long) {
                        return !Long.valueOf(val).equals(number2);
                    }
                    if (number2 instanceof Float) {
                        return !Float.valueOf(val).equals(number2);
                    }
                    return !Double.valueOf(val).equals(number2);
                }
                case 2: {
                    int val = number2.intValue();
                    if (number2 instanceof Long) {
                        return !Long.valueOf(val).equals(number2);
                    }
                    if (number2 instanceof Float) {
                        return !Float.valueOf(val).equals(number2);
                    }
                    return !Double.valueOf(val).equals(number2);
                }
                case 3: {
                    long val = number2.longValue();
                    if (number2 instanceof Float) {
                        return !Float.valueOf(val).equals(number2);
                    }
                    return !Double.valueOf(val).equals(number2);
                }
                case 4: {
                    float val = number2.floatValue();
                    return !Double.valueOf(val).equals(number2);
                }
            }
            return false;
        }
        return true;
    }

    static String toMethodParametersString(String methodName, ClassNode ... parameters) {
        StringBuilder sb = new StringBuilder();
        sb.append(methodName).append("(");
        if (parameters != null) {
            int parametersLength = parameters.length;
            for (int i = 0; i < parametersLength; ++i) {
                ClassNode parameter = parameters[i];
                sb.append(StaticTypeCheckingSupport.prettyPrintType(parameter));
                if (i >= parametersLength - 1) continue;
                sb.append(", ");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    static String prettyPrintType(ClassNode type) {
        if (type.isArray()) {
            return StaticTypeCheckingSupport.prettyPrintType(type.getComponentType()) + "[]";
        }
        return type.toString(false);
    }

    public static boolean implementsInterfaceOrIsSubclassOf(ClassNode type, ClassNode superOrInterface) {
        boolean result2;
        boolean bl = result2 = type.equals(superOrInterface) || type.isDerivedFrom(superOrInterface) || type.implementsInterface(superOrInterface) || type == UNKNOWN_PARAMETER_TYPE;
        if (result2) {
            return true;
        }
        if (superOrInterface instanceof WideningCategories.LowestUpperBoundClassNode) {
            WideningCategories.LowestUpperBoundClassNode cn = (WideningCategories.LowestUpperBoundClassNode)superOrInterface;
            result2 = StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(type, cn.getSuperClass());
            if (result2) {
                ClassNode interfaceNode;
                ClassNode[] arr$ = cn.getInterfaces();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (result2 = type.implementsInterface(interfaceNode = arr$[i$])); ++i$) {
                }
            }
            if (result2) {
                return true;
            }
        } else if (superOrInterface instanceof UnionTypeClassNode) {
            UnionTypeClassNode union2 = (UnionTypeClassNode)superOrInterface;
            for (ClassNode delegate : union2.getDelegates()) {
                if (!StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(type, delegate)) continue;
                return true;
            }
        }
        if (type.isArray() && superOrInterface.isArray()) {
            return StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(type.getComponentType(), superOrInterface.getComponentType());
        }
        return ClassHelper.GROOVY_OBJECT_TYPE.equals(superOrInterface) && !type.isInterface() && StaticTypeCheckingSupport.isBeingCompiled(type);
    }

    static int getPrimitiveDistance(ClassNode primA, ClassNode primB) {
        return Math.abs(NUMBER_TYPES.get(primA) - NUMBER_TYPES.get(primB));
    }

    static int getDistance(ClassNode receiver, ClassNode compare) {
        int dist = 0;
        ClassNode unwrapReceiver = ClassHelper.getUnwrapper(receiver);
        ClassNode unwrapCompare = ClassHelper.getUnwrapper(compare);
        if (ClassHelper.isPrimitiveType(unwrapReceiver) && ClassHelper.isPrimitiveType(unwrapCompare) && unwrapReceiver != unwrapCompare) {
            dist = StaticTypeCheckingSupport.getPrimitiveDistance(unwrapReceiver, unwrapCompare);
        }
        if (ClassHelper.isPrimitiveType(receiver) && !ClassHelper.isPrimitiveType(compare)) {
            dist = dist + 1 << 1;
        }
        if (unwrapCompare.equals(unwrapReceiver)) {
            return dist;
        }
        if (receiver.isArray() && !compare.isArray()) {
            dist += 256;
        }
        if (receiver == UNKNOWN_PARAMETER_TYPE) {
            return dist;
        }
        ClassNode ref = receiver;
        while (ref != null && !compare.equals(ref)) {
            if (compare.isInterface() && ref.implementsInterface(compare)) {
                dist += StaticTypeCheckingSupport.getMaximumInterfaceDistance(ref, compare);
                break;
            }
            ref = ref.getSuperClass();
            ++dist;
            if (ref == null) {
                ++dist;
            }
            dist = dist + 1 << 1;
        }
        return dist;
    }

    private static int getMaximumInterfaceDistance(ClassNode c, ClassNode interfaceClass) {
        if (c == null) {
            return -1;
        }
        if (c.equals(interfaceClass)) {
            return 0;
        }
        ClassNode[] interfaces = c.getInterfaces();
        int max2 = -1;
        for (ClassNode anInterface : interfaces) {
            int sub = StaticTypeCheckingSupport.getMaximumInterfaceDistance(anInterface, interfaceClass);
            if (sub != -1) {
                ++sub;
            }
            max2 = Math.max(max2, sub);
        }
        int superClassMax = StaticTypeCheckingSupport.getMaximumInterfaceDistance(c.getSuperClass(), interfaceClass);
        return Math.max(max2, superClassMax);
    }

    @Deprecated
    public static List<MethodNode> findDGMMethodsByNameAndArguments(ClassNode receiver, String name, ClassNode[] args) {
        return StaticTypeCheckingSupport.findDGMMethodsByNameAndArguments(MetaClassRegistryImpl.class.getClassLoader(), receiver, name, args);
    }

    public static List<MethodNode> findDGMMethodsByNameAndArguments(ClassLoader loader, ClassNode receiver, String name, ClassNode[] args) {
        return StaticTypeCheckingSupport.findDGMMethodsByNameAndArguments(loader, receiver, name, args, new LinkedList<MethodNode>());
    }

    @Deprecated
    public static List<MethodNode> findDGMMethodsByNameAndArguments(ClassNode receiver, String name, ClassNode[] args, List<MethodNode> methods) {
        return StaticTypeCheckingSupport.findDGMMethodsByNameAndArguments(MetaClassRegistryImpl.class.getClassLoader(), receiver, name, args, methods);
    }

    public static List<MethodNode> findDGMMethodsByNameAndArguments(ClassLoader loader, ClassNode receiver, String name, ClassNode[] args, List<MethodNode> methods) {
        methods.addAll(StaticTypeCheckingSupport.findDGMMethodsForClassNode(loader, receiver, name));
        List<MethodNode> chosen = StaticTypeCheckingSupport.chooseBestMethod(receiver, methods, args);
        Iterator<MethodNode> iterator2 = chosen.iterator();
        while (iterator2.hasNext()) {
            Parameter[] parameters;
            ClassNode dgmOwnerType;
            ExtensionMethodNode emn = (ExtensionMethodNode)iterator2.next();
            MethodNode dgmMethod = emn.getExtensionMethodNode();
            GenericsType[] methodGenericTypes = dgmMethod.getGenericsTypes();
            if (methodGenericTypes == null || methodGenericTypes.length <= 0 || !(dgmOwnerType = (parameters = dgmMethod.getParameters())[0].getOriginType()).isGenericsPlaceHolder() && (!dgmOwnerType.isArray() || !dgmOwnerType.getComponentType().isGenericsPlaceHolder())) continue;
            ClassNode receiverBase = receiver.isArray() ? receiver.getComponentType() : receiver;
            ClassNode receiverBaseRedirect = dgmOwnerType.isArray() ? dgmOwnerType.getComponentType() : dgmOwnerType;
            boolean mismatch = false;
            for (int i = 1; i < parameters.length && !mismatch; ++i) {
                int j;
                int k = i - 1;
                ClassNode type = parameters[i].getOriginType();
                if (!StaticTypeCheckingSupport.isUsingGenericsOrIsArrayUsingGenerics(type)) continue;
                String receiverPlaceholder = receiverBaseRedirect.getGenericsTypes()[0].getName();
                ClassNode parameterBaseType = args[k].isArray() ? args[k].getComponentType() : args[k];
                ClassNode parameterBaseTypeRedirect = type.isArray() ? type.getComponentType() : type;
                GenericsType[] paramRedirectGenericsTypes = parameterBaseTypeRedirect.getGenericsTypes();
                Object[] paramGenericTypes = parameterBaseType.getGenericsTypes();
                if (paramGenericTypes == null) {
                    paramGenericTypes = new GenericsType[paramRedirectGenericsTypes.length];
                    Arrays.fill(paramGenericTypes, new GenericsType(ClassHelper.OBJECT_TYPE));
                } else {
                    for (j = 0; j < paramGenericTypes.length; ++j) {
                        GenericsType paramGenericType = paramGenericTypes[j];
                        if (!paramGenericType.isWildcard() && !paramGenericType.isPlaceholder()) continue;
                        paramGenericTypes[j] = new GenericsType(ClassHelper.OBJECT_TYPE);
                    }
                }
                int genericsTypesLength = paramRedirectGenericsTypes.length;
                block3: for (j = 0; j < genericsTypesLength && !mismatch; ++j) {
                    GenericsType gt = paramRedirectGenericsTypes[j];
                    if (!gt.isPlaceholder()) continue;
                    LinkedList<GenericsType> fromMethodGenerics = new LinkedList<GenericsType>();
                    for (GenericsType methodGenericType : methodGenericTypes) {
                        if (!methodGenericType.getName().equals(gt.getName())) continue;
                        fromMethodGenerics.add(methodGenericType);
                        break;
                    }
                    while (!fromMethodGenerics.isEmpty()) {
                        GenericsType test2 = (GenericsType)fromMethodGenerics.remove(0);
                        if (test2.getName().equals(receiverPlaceholder)) {
                            if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(ClassHelper.getWrapper(args[k]), ClassHelper.getWrapper(receiverBase))) continue;
                            mismatch = true;
                            continue block3;
                        }
                        if (test2.getUpperBounds() == null) continue;
                        for (ClassNode classNode : test2.getUpperBounds()) {
                            GenericsType[] genericsTypes = classNode.getGenericsTypes();
                            if (genericsTypes == null) continue;
                            block7: for (GenericsType genericsType : genericsTypes) {
                                if (!genericsType.isPlaceholder()) continue;
                                for (GenericsType methodGenericType : methodGenericTypes) {
                                    if (!methodGenericType.getName().equals(genericsType.getName())) continue;
                                    fromMethodGenerics.add(methodGenericType);
                                    continue block7;
                                }
                            }
                        }
                    }
                }
                if (!mismatch) continue;
                iterator2.remove();
            }
        }
        return chosen;
    }

    public static List<MethodNode> chooseBestMethod(ClassNode receiver, Collection<MethodNode> methods, ClassNode ... args) {
        if (methods.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<MethodNode> bestChoices = new LinkedList<MethodNode>();
        int bestDist = Integer.MAX_VALUE;
        Collection<MethodNode> choicesLeft = StaticTypeCheckingSupport.removeCovariants(methods);
        for (MethodNode m : choicesLeft) {
            ClassNode declaringClass = m.getDeclaringClass();
            ClassNode actualReceiver = receiver != null ? receiver : declaringClass;
            Parameter[] params = StaticTypeCheckingSupport.parameterizeArguments(actualReceiver, m);
            if (params.length == args.length) {
                int dist;
                int lastArgMatch;
                int allPMatch = StaticTypeCheckingSupport.allParametersAndArgumentsMatch(params, args);
                boolean firstParamMatches = true;
                if (args.length > 0) {
                    Parameter[] firstParams = new Parameter[params.length - 1];
                    System.arraycopy(params, 0, firstParams, 0, firstParams.length);
                    firstParamMatches = StaticTypeCheckingSupport.allParametersAndArgumentsMatch(firstParams, args) >= 0;
                }
                int n = lastArgMatch = StaticTypeCheckingSupport.isVargs(params) && firstParamMatches ? StaticTypeCheckingSupport.lastArgMatchesVarg(params, args) : -1;
                if (lastArgMatch >= 0) {
                    lastArgMatch += 256 - params.length;
                }
                int n2 = dist = allPMatch >= 0 ? Math.max(allPMatch, lastArgMatch) : lastArgMatch;
                if (dist >= 0 && !actualReceiver.equals(declaringClass)) {
                    dist += StaticTypeCheckingSupport.getDistance(actualReceiver, declaringClass);
                }
                if (dist >= 0 && dist < bestDist) {
                    bestChoices.clear();
                    bestChoices.add(m);
                    bestDist = dist;
                    continue;
                }
                if (dist < 0 || dist != bestDist) continue;
                bestChoices.add(m);
                continue;
            }
            if (!StaticTypeCheckingSupport.isVargs(params)) continue;
            boolean firstParamMatches = true;
            int dist = -1;
            if (args.length > 0) {
                Parameter[] firstParams = new Parameter[params.length - 1];
                System.arraycopy(params, 0, firstParams, 0, firstParams.length);
                dist = StaticTypeCheckingSupport.allParametersAndArgumentsMatch(firstParams, args);
                firstParamMatches = dist >= 0;
            } else {
                dist = 0;
            }
            if (!firstParamMatches) continue;
            if (params.length == args.length + 1) {
                if (dist >= 0) {
                    dist += 256 - params.length;
                }
                if (bestDist <= 1 + dist) continue;
                bestChoices.clear();
                bestChoices.add(m);
                bestDist = 1 + dist;
                continue;
            }
            if ((dist += StaticTypeCheckingSupport.excessArgumentsMatchesVargsParameter(params, args)) >= 0 && !actualReceiver.equals(declaringClass)) {
                dist += StaticTypeCheckingSupport.getDistance(actualReceiver, declaringClass);
            }
            if (params.length >= args.length || (dist += 256 - params.length) < 0) continue;
            if (dist >= 0 && dist < bestDist) {
                bestChoices.clear();
                bestChoices.add(m);
                bestDist = dist;
                continue;
            }
            if (dist < 0 || dist != bestDist) continue;
            bestChoices.add(m);
        }
        return bestChoices;
    }

    private static Collection<MethodNode> removeCovariants(Collection<MethodNode> collection) {
        if (collection.size() <= 1) {
            return collection;
        }
        LinkedList<MethodNode> toBeRemoved = new LinkedList<MethodNode>();
        LinkedList<MethodNode> list2 = new LinkedList<MethodNode>(new HashSet<MethodNode>(collection));
        for (int i = 0; i < list2.size() - 1; ++i) {
            MethodNode one = (MethodNode)list2.get(i);
            if (toBeRemoved.contains(one)) continue;
            for (int j = i + 1; j < list2.size(); ++j) {
                Parameter[] twoPars;
                Parameter[] onePars;
                MethodNode two = (MethodNode)list2.get(j);
                if (toBeRemoved.contains(two) || !one.getName().equals(two.getName()) || one.getDeclaringClass() != two.getDeclaringClass() || (onePars = one.getParameters()).length != (twoPars = two.getParameters()).length) continue;
                boolean sameTypes = true;
                for (int k = 0; k < onePars.length; ++k) {
                    Parameter onePar = onePars[k];
                    Parameter twoPar = twoPars[k];
                    if (onePar.getType().equals(twoPar.getType())) continue;
                    sameTypes = false;
                    break;
                }
                if (sameTypes) {
                    ClassNode twoRT;
                    ClassNode oneRT = one.getReturnType();
                    if (oneRT.isDerivedFrom(twoRT = two.getReturnType()) || oneRT.implementsInterface(twoRT)) {
                        toBeRemoved.add(two);
                        continue;
                    }
                    if (!twoRT.isDerivedFrom(oneRT) && !twoRT.implementsInterface(oneRT)) continue;
                    toBeRemoved.add(one);
                    continue;
                }
                if (one.isSynthetic() && !two.isSynthetic()) {
                    toBeRemoved.add(one);
                    continue;
                }
                if (!two.isSynthetic() || one.isSynthetic()) continue;
                toBeRemoved.add(two);
            }
        }
        if (toBeRemoved.isEmpty()) {
            return list2;
        }
        LinkedList<MethodNode> result2 = new LinkedList<MethodNode>(list2);
        result2.removeAll(toBeRemoved);
        return result2;
    }

    public static Parameter[] parameterizeArguments(ClassNode receiver, MethodNode m) {
        MethodNode mn = m;
        ClassNode actualReceiver = receiver;
        ArrayList redirectTypes = new ArrayList();
        if (actualReceiver.redirect().getGenericsTypes() != null) {
            Collections.addAll(redirectTypes, actualReceiver.redirect().getGenericsTypes());
        }
        if (redirectTypes.isEmpty()) {
            return m.getParameters();
        }
        GenericsType[] redirectReceiverTypes = redirectTypes.toArray(new GenericsType[redirectTypes.size()]);
        Parameter[] methodParameters = mn.getParameters();
        Parameter[] params = new Parameter[methodParameters.length];
        GenericsType[] receiverParameterizedTypes = actualReceiver.getGenericsTypes();
        if (receiverParameterizedTypes == null) {
            receiverParameterizedTypes = redirectReceiverTypes;
        }
        for (int i = 0; i < methodParameters.length; ++i) {
            Parameter methodParameter = methodParameters[i];
            ClassNode paramType = methodParameter.getType();
            if (paramType.isUsingGenerics()) {
                GenericsType[] alignmentTypes = paramType.getGenericsTypes();
                GenericsType[] genericsTypes = GenericsUtils.alignGenericTypes(redirectReceiverTypes, receiverParameterizedTypes, alignmentTypes);
                if (genericsTypes.length == 1) {
                    ClassNode parameterizedCN;
                    if (paramType.equals(ClassHelper.OBJECT_TYPE)) {
                        parameterizedCN = genericsTypes[0].getType();
                    } else {
                        parameterizedCN = paramType.getPlainNodeReference();
                        parameterizedCN.setGenericsTypes(genericsTypes);
                    }
                    params[i] = new Parameter(parameterizedCN, methodParameter.getName());
                    continue;
                }
                params[i] = methodParameter;
                continue;
            }
            params[i] = methodParameter;
        }
        return params;
    }

    static boolean isUsingGenericsOrIsArrayUsingGenerics(ClassNode cn) {
        return cn.isUsingGenerics() && cn.getGenericsTypes() != null || cn.isArray() && cn.getComponentType().isUsingGenerics();
    }

    public static boolean isGStringOrGStringStringLUB(ClassNode node) {
        return ClassHelper.GSTRING_TYPE.equals(node) || GSTRING_STRING_CLASSNODE.equals(node);
    }

    public static boolean isParameterizedWithGStringOrGStringString(ClassNode node) {
        GenericsType[] genericsTypes;
        if (node.isArray()) {
            return StaticTypeCheckingSupport.isParameterizedWithGStringOrGStringString(node.getComponentType());
        }
        if (node.isUsingGenerics() && (genericsTypes = node.getGenericsTypes()) != null) {
            for (GenericsType genericsType : genericsTypes) {
                if (!StaticTypeCheckingSupport.isGStringOrGStringStringLUB(genericsType.getType())) continue;
                return true;
            }
        }
        return node.getSuperClass() != null && StaticTypeCheckingSupport.isParameterizedWithGStringOrGStringString(node.getUnresolvedSuperClass());
    }

    public static boolean isParameterizedWithString(ClassNode node) {
        GenericsType[] genericsTypes;
        if (node.isArray()) {
            return StaticTypeCheckingSupport.isParameterizedWithString(node.getComponentType());
        }
        if (node.isUsingGenerics() && (genericsTypes = node.getGenericsTypes()) != null) {
            for (GenericsType genericsType : genericsTypes) {
                if (!ClassHelper.STRING_TYPE.equals(genericsType.getType())) continue;
                return true;
            }
        }
        return node.getSuperClass() != null && StaticTypeCheckingSupport.isParameterizedWithString(node.getUnresolvedSuperClass());
    }

    public static boolean missesGenericsTypes(ClassNode cn) {
        if (cn.isArray()) {
            return StaticTypeCheckingSupport.missesGenericsTypes(cn.getComponentType());
        }
        GenericsType[] cnTypes = cn.getGenericsTypes();
        GenericsType[] rnTypes = cn.redirect().getGenericsTypes();
        if (rnTypes != null && cnTypes == null) {
            return true;
        }
        if (cnTypes != null) {
            for (GenericsType genericsType : cnTypes) {
                if (!genericsType.isPlaceholder()) continue;
                return true;
            }
        }
        return false;
    }

    public static Object evaluateExpression(Expression expr, CompilerConfiguration config) {
        String className = "Expression$" + UUID.randomUUID().toString().replace('-', '$');
        ClassNode node = new ClassNode(className, 1, ClassHelper.OBJECT_TYPE);
        ReturnStatement code = new ReturnStatement(expr);
        node.addMethod(new MethodNode("eval", 9, ClassHelper.OBJECT_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, code));
        CompilerConfiguration copyConf = new CompilerConfiguration(config);
        CompilationUnit cu = new CompilationUnit(copyConf);
        cu.addClassNode(node);
        cu.compile();
        List classes = cu.getClasses();
        Class aClass = cu.getClassLoader().defineClass(className, ((GroovyClass)classes.get(0)).getBytes());
        try {
            return aClass.getMethod("eval", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new GroovyBugError(e);
        }
        catch (InvocationTargetException e) {
            throw new GroovyBugError(e);
        }
        catch (NoSuchMethodException e) {
            throw new GroovyBugError(e);
        }
    }

    public static Set<ClassNode> collectAllInterfaces(ClassNode node) {
        HashSet<ClassNode> result2 = new HashSet<ClassNode>();
        StaticTypeCheckingSupport.collectAllInterfaces(node, result2);
        return result2;
    }

    private static void collectAllInterfaces(ClassNode node, Set<ClassNode> out) {
        if (node == null) {
            return;
        }
        Set<ClassNode> allInterfaces = node.getAllInterfaces();
        out.addAll(allInterfaces);
        StaticTypeCheckingSupport.collectAllInterfaces(node.getSuperClass(), out);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtensionMethodCache {
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        private List<ExtensionModule> modules = Collections.emptyList();
        private Map<String, List<MethodNode>> cachedMethods = null;
        private WeakReference<ClassLoader> origin = new WeakReference<Object>(null);

        private ExtensionMethodCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, List<MethodNode>> getExtensionMethods(ClassLoader loader) {
            this.lock.readLock().lock();
            if (loader != this.origin.get()) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    final LinkedList<ExtensionModule> modules = new LinkedList<ExtensionModule>();
                    ExtensionModuleScanner scanner = new ExtensionModuleScanner(new ExtensionModuleScanner.ExtensionModuleListener(){

                        public void onModule(ExtensionModule module) {
                            boolean skip = false;
                            for (ExtensionModule extensionModule : modules) {
                                if (!extensionModule.getName().equals(module.getName())) continue;
                                skip = true;
                                break;
                            }
                            if (!skip) {
                                modules.add(module);
                            }
                        }
                    }, loader);
                    scanner.scanClasspathModules();
                    this.cachedMethods = ExtensionMethodCache.getDGMMethods(modules);
                    this.origin = new WeakReference<ClassLoader>(loader);
                }
                finally {
                    this.lock.writeLock().unlock();
                    this.lock.readLock().lock();
                }
            }
            try {
                Map<String, List<MethodNode>> map2 = Collections.unmodifiableMap(this.cachedMethods);
                return map2;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        private static Map<String, List<MethodNode>> getDGMMethods(List<ExtensionModule> modules) {
            LinkedHashSet<Class<ObjectArrayStaticTypesHelper>> instanceExtClasses = new LinkedHashSet<Class<ObjectArrayStaticTypesHelper>>();
            LinkedHashSet<Class<DefaultGroovyStaticMethods>> staticExtClasses = new LinkedHashSet<Class<DefaultGroovyStaticMethods>>();
            for (ExtensionModule module : modules) {
                if (!(module instanceof MetaInfExtensionModule)) continue;
                MetaInfExtensionModule extensionModule = (MetaInfExtensionModule)module;
                instanceExtClasses.addAll(extensionModule.getInstanceMethodsExtensionClasses());
                staticExtClasses.addAll(extensionModule.getStaticMethodsExtensionClasses());
            }
            HashMap<String, List<MethodNode>> methods = new HashMap<String, List<MethodNode>>();
            Collections.addAll(instanceExtClasses, DefaultGroovyMethods.DGM_LIKE_CLASSES);
            Collections.addAll(instanceExtClasses, DefaultGroovyMethods.additionals);
            staticExtClasses.add(DefaultGroovyStaticMethods.class);
            instanceExtClasses.add(ObjectArrayStaticTypesHelper.class);
            ArrayList<Class> allClasses = new ArrayList<Class>(instanceExtClasses.size() + staticExtClasses.size());
            allClasses.addAll(instanceExtClasses);
            allClasses.addAll(staticExtClasses);
            for (Class dgmLikeClass : allClasses) {
                ClassNode cn = ClassHelper.makeWithoutCaching(dgmLikeClass, true);
                for (MethodNode metaMethod : cn.getMethods()) {
                    Parameter[] types = metaMethod.getParameters();
                    if (!metaMethod.isStatic() || !metaMethod.isPublic() || types.length <= 0 || !metaMethod.getAnnotations(Deprecated_TYPE).isEmpty()) continue;
                    Parameter[] parameters = new Parameter[types.length - 1];
                    System.arraycopy(types, 1, parameters, 0, parameters.length);
                    ExtensionMethodNode node = new ExtensionMethodNode(metaMethod, metaMethod.getName(), metaMethod.getModifiers(), metaMethod.getReturnType(), parameters, ClassNode.EMPTY_ARRAY, null, staticExtClasses.contains(dgmLikeClass));
                    node.setGenericsTypes(metaMethod.getGenericsTypes());
                    ClassNode declaringClass = types[0].getType();
                    String declaringClassName = declaringClass.getName();
                    node.setDeclaringClass(declaringClass);
                    LinkedList<ExtensionMethodNode> nodes = (LinkedList<ExtensionMethodNode>)methods.get(declaringClassName);
                    if (nodes == null) {
                        nodes = new LinkedList<ExtensionMethodNode>();
                        methods.put(declaringClassName, nodes);
                    }
                    nodes.add(node);
                }
            }
            return methods;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectArrayStaticTypesHelper {
        private ObjectArrayStaticTypesHelper() {
        }

        public static <T> T getAt(T[] arr, int index) {
            return null;
        }

        public static <T, U extends T> void putAt(T[] arr, int index, U object) {
        }
    }
}

