/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.stc;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.classgen.asm.InvocationWriter;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.transform.stc.DelegationMetadata;
import org.codehaus.groovy.transform.stc.ExtensionMethodNode;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingVisitor;
import org.codehaus.groovy.transform.stc.TypeCheckingContext;
import org.codehaus.groovy.transform.stc.TypeCheckingExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyTypeCheckingExtensionSupport
extends TypeCheckingExtension {
    private static final Map<String, String> METHOD_ALIASES = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("onMethodSelection", "onMethodSelection");
            this.put("afterMethodCall", "afterMethodCall");
            this.put("beforeMethodCall", "beforeMethodCall");
            this.put("unresolvedVariable", "handleUnresolvedVariableExpression");
            this.put("unresolvedProperty", "handleUnresolvedProperty");
            this.put("unresolvedAttribute", "handleUnresolvedAttribute");
            this.put("methodNotFound", "handleMissingMethod");
            this.put("afterVisitMethod", "afterVisitMethod");
            this.put("beforeVisitMethod", "beforeVisitMethod");
            this.put("afterVisitClass", "afterVisitClass");
            this.put("beforeVisitClass", "beforeVisitClass");
            this.put("incompatibleAssignment", "handleIncompatibleAssignment");
            this.put("setup", "setup");
            this.put("finish", "finish");
        }
    });
    private final Set<MethodNode> generatedMethods = new LinkedHashSet<MethodNode>();
    private final LinkedList<TypeCheckingScope> scopeData = new LinkedList();
    private final Map<String, List<Closure>> eventHandlers = new HashMap<String, List<Closure>>();
    private final String scriptPath;
    private final TypeCheckingContext context;
    private boolean handled = false;
    private final CompilationUnit compilationUnit;

    public GroovyTypeCheckingExtensionSupport(StaticTypeCheckingVisitor typeCheckingVisitor, String scriptPath, CompilationUnit compilationUnit) {
        super(typeCheckingVisitor);
        this.scriptPath = scriptPath;
        this.context = typeCheckingVisitor.typeCheckingContext;
        this.compilationUnit = compilationUnit;
    }

    @Override
    public void setup() {
        CompilerConfiguration config = new CompilerConfiguration();
        config.setScriptBaseClass("org.codehaus.groovy.transform.stc.GroovyTypeCheckingExtensionSupport.TypeCheckingDSL");
        ImportCustomizer ic = new ImportCustomizer();
        ic.addStarImports("org.codehaus.groovy.ast.expr");
        ic.addStaticStars("org.codehaus.groovy.ast.ClassHelper");
        ic.addStaticStars("org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport");
        config.addCompilationCustomizers(ic);
        GroovyClassLoader transformLoader = this.compilationUnit != null ? this.compilationUnit.getTransformLoader() : this.typeCheckingVisitor.getSourceUnit().getClassLoader();
        ClassLoader cl = this.typeCheckingVisitor.getSourceUnit().getClassLoader();
        InputStream is = ((ClassLoader)transformLoader).getResourceAsStream(this.scriptPath);
        if (is == null) {
            is = cl.getResourceAsStream(this.scriptPath);
        }
        if (is == null) {
            cl = GroovyTypeCheckingExtensionSupport.class.getClassLoader();
            is = cl.getResourceAsStream(this.scriptPath);
        }
        if (is == null) {
            this.context.getErrorCollector().addFatalError(new SimpleMessage("Static type checking extension '" + this.scriptPath + "' was not found on the classpath.", config.getDebug(), this.typeCheckingVisitor.getSourceUnit()));
        }
        try {
            GroovyShell shell = new GroovyShell(transformLoader, new Binding(), config);
            TypeCheckingDSL parse = (TypeCheckingDSL)shell.parse(new InputStreamReader(is, this.typeCheckingVisitor.getSourceUnit().getConfiguration().getSourceEncoding()));
            parse.extension = this;
            parse.run();
            List<Closure> list2 = this.eventHandlers.get("setup");
            if (list2 != null) {
                for (Closure closure : list2) {
                    this.safeCall(closure, new Object[0]);
                }
            }
        }
        catch (CompilationFailedException e) {
            throw new GroovyBugError("An unexpected error was thrown during custom type checking", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new GroovyBugError("Unsupported encoding found in compiler configuration", e);
        }
    }

    @Override
    public void finish() {
        List<Closure> list2 = this.eventHandlers.get("finish");
        if (list2 != null) {
            for (Closure closure : list2) {
                this.safeCall(closure, new Object[0]);
            }
        }
    }

    public void setHandled(boolean handled) {
        this.handled = handled;
    }

    public TypeCheckingScope newScope() {
        TypeCheckingScope scope = new TypeCheckingScope(this.scopeData.peek());
        this.scopeData.addFirst(scope);
        return scope;
    }

    public TypeCheckingScope newScope(Closure code) {
        TypeCheckingScope scope = this.newScope();
        Closure callback = code.rehydrate(scope, this, this);
        callback.call();
        return scope;
    }

    public TypeCheckingScope scopeExit() {
        return this.scopeData.removeFirst();
    }

    public TypeCheckingScope getCurrentScope() {
        return this.scopeData.peek();
    }

    public TypeCheckingScope scopeExit(Closure code) {
        TypeCheckingScope scope = this.scopeData.peek();
        Closure copy = code.rehydrate(scope, this, this);
        copy.call();
        return this.scopeExit();
    }

    public boolean isGenerated(MethodNode node) {
        return this.generatedMethods.contains(node);
    }

    public List<MethodNode> unique(MethodNode node) {
        return Collections.singletonList(node);
    }

    public MethodNode newMethod(String name, Class returnType) {
        return this.newMethod(name, ClassHelper.make(returnType));
    }

    public MethodNode newMethod(String name, ClassNode returnType) {
        MethodNode node = new MethodNode(name, 1, returnType, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, EmptyStatement.INSTANCE);
        this.generatedMethods.add(node);
        return node;
    }

    public MethodNode newMethod(String name, final Callable<ClassNode> returnType) {
        MethodNode node = new MethodNode(name, 1, ClassHelper.OBJECT_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, EmptyStatement.INSTANCE){

            public ClassNode getReturnType() {
                try {
                    return (ClassNode)returnType.call();
                }
                catch (Exception e) {
                    return super.getReturnType();
                }
            }
        };
        this.generatedMethods.add(node);
        return node;
    }

    public void delegatesTo(ClassNode type) {
        this.delegatesTo(type, 0);
    }

    public void delegatesTo(ClassNode type, int strategy) {
        this.delegatesTo(type, strategy, this.typeCheckingVisitor.typeCheckingContext.delegationMetadata);
    }

    public void delegatesTo(ClassNode type, int strategy, DelegationMetadata parent) {
        this.typeCheckingVisitor.typeCheckingContext.delegationMetadata = new DelegationMetadata(type, strategy, parent);
    }

    public boolean isAnnotatedBy(ASTNode node, Class annotation) {
        return this.isAnnotatedBy(node, ClassHelper.make(annotation));
    }

    public boolean isAnnotatedBy(ASTNode node, ClassNode annotation) {
        return node instanceof AnnotatedNode && !((AnnotatedNode)node).getAnnotations(annotation).isEmpty();
    }

    public boolean isDynamic(VariableExpression var) {
        return var.getAccessedVariable() instanceof DynamicVariable;
    }

    public boolean isExtensionMethod(MethodNode node) {
        return node instanceof ExtensionMethodNode;
    }

    public ArgumentListExpression getArguments(MethodCall call) {
        return InvocationWriter.makeArgumentList(call.getArguments());
    }

    private Object safeCall(Closure closure, Object ... args) {
        try {
            return closure.call(args);
        }
        catch (Exception err2) {
            this.typeCheckingVisitor.getSourceUnit().addException(err2);
            return null;
        }
    }

    @Override
    public void onMethodSelection(Expression expression, MethodNode target) {
        List<Closure> onMethodSelection = this.eventHandlers.get("onMethodSelection");
        if (onMethodSelection != null) {
            for (Closure closure : onMethodSelection) {
                this.safeCall(closure, expression, target);
            }
        }
    }

    @Override
    public void afterMethodCall(MethodCall call) {
        List<Closure> onMethodSelection = this.eventHandlers.get("afterMethodCall");
        if (onMethodSelection != null) {
            for (Closure closure : onMethodSelection) {
                this.safeCall(closure, call);
            }
        }
    }

    @Override
    public boolean beforeMethodCall(MethodCall call) {
        this.setHandled(false);
        List<Closure> onMethodSelection = this.eventHandlers.get("beforeMethodCall");
        if (onMethodSelection != null) {
            for (Closure closure : onMethodSelection) {
                this.safeCall(closure, call);
            }
        }
        return this.handled;
    }

    @Override
    public boolean handleUnresolvedVariableExpression(VariableExpression vexp) {
        this.setHandled(false);
        List<Closure> onMethodSelection = this.eventHandlers.get("handleUnresolvedVariableExpression");
        if (onMethodSelection != null) {
            for (Closure closure : onMethodSelection) {
                this.safeCall(closure, vexp);
            }
        }
        return this.handled;
    }

    @Override
    public boolean handleUnresolvedProperty(PropertyExpression pexp) {
        this.setHandled(false);
        List<Closure> list2 = this.eventHandlers.get("handleUnresolvedProperty");
        if (list2 != null) {
            for (Closure closure : list2) {
                this.safeCall(closure, pexp);
            }
        }
        return this.handled;
    }

    @Override
    public boolean handleUnresolvedAttribute(AttributeExpression aexp) {
        this.setHandled(false);
        List<Closure> list2 = this.eventHandlers.get("handleUnresolvedAttribute");
        if (list2 != null) {
            for (Closure closure : list2) {
                this.safeCall(closure, aexp);
            }
        }
        return this.handled;
    }

    @Override
    public void afterVisitMethod(MethodNode node) {
        List<Closure> list2 = this.eventHandlers.get("afterVisitMethod");
        if (list2 != null) {
            for (Closure closure : list2) {
                this.safeCall(closure, node);
            }
        }
    }

    @Override
    public boolean beforeVisitClass(ClassNode node) {
        this.setHandled(false);
        List<Closure> list2 = this.eventHandlers.get("beforeVisitClass");
        if (list2 != null) {
            for (Closure closure : list2) {
                this.safeCall(closure, node);
            }
        }
        return this.handled;
    }

    @Override
    public void afterVisitClass(ClassNode node) {
        List<Closure> list2 = this.eventHandlers.get("afterVisitClass");
        if (list2 != null) {
            for (Closure closure : list2) {
                this.safeCall(closure, node);
            }
        }
    }

    @Override
    public boolean beforeVisitMethod(MethodNode node) {
        this.setHandled(false);
        List<Closure> list2 = this.eventHandlers.get("beforeVisitMethod");
        if (list2 != null) {
            for (Closure closure : list2) {
                this.safeCall(closure, node);
            }
        }
        return this.handled;
    }

    @Override
    public boolean handleIncompatibleAssignment(ClassNode lhsType, ClassNode rhsType, Expression assignmentExpression) {
        this.setHandled(false);
        List<Closure> list2 = this.eventHandlers.get("handleIncompatibleAssignment");
        if (list2 != null) {
            for (Closure closure : list2) {
                this.safeCall(closure, lhsType, rhsType, assignmentExpression);
            }
        }
        return this.handled;
    }

    @Override
    public List<MethodNode> handleMissingMethod(ClassNode receiver, String name, ArgumentListExpression argumentList, ClassNode[] argumentTypes, MethodCall call) {
        List<Closure> onMethodSelection = this.eventHandlers.get("handleMissingMethod");
        LinkedList<MethodNode> methodList = new LinkedList<MethodNode>();
        if (onMethodSelection != null) {
            for (Closure closure : onMethodSelection) {
                Object result2 = this.safeCall(closure, receiver, name, argumentList, argumentTypes, call);
                if (result2 == null) continue;
                if (result2 instanceof MethodNode) {
                    methodList.add((MethodNode)result2);
                    continue;
                }
                if (result2 instanceof Collection) {
                    methodList.addAll((Collection)result2);
                    continue;
                }
                throw new GroovyBugError("Type checking extension returned unexpected method list: " + result2);
            }
        }
        return methodList;
    }

    public boolean isMethodCall(Object o) {
        return o instanceof MethodCallExpression;
    }

    public boolean argTypesMatches(ClassNode[] argTypes, Class ... classes) {
        if (classes == null) {
            return argTypes == null || argTypes.length == 0;
        }
        if (argTypes.length != classes.length) {
            return false;
        }
        boolean match = true;
        for (int i = 0; i < argTypes.length && match; ++i) {
            match = this.matchWithOrWithourBoxing(argTypes[i], classes[i]);
        }
        return match;
    }

    private boolean matchWithOrWithourBoxing(ClassNode argType, Class aClass) {
        ClassNode type = ClassHelper.make(aClass);
        if (ClassHelper.isPrimitiveType(type) && !ClassHelper.isPrimitiveType(argType)) {
            type = ClassHelper.getWrapper(type);
        } else if (ClassHelper.isPrimitiveType(argType) && !ClassHelper.isPrimitiveType(type)) {
            type = ClassHelper.getUnwrapper(type);
        }
        boolean match = argType.equals(type);
        return match;
    }

    public boolean argTypesMatches(MethodCall call, Class ... classes) {
        ArgumentListExpression argumentListExpression = InvocationWriter.makeArgumentList(call.getArguments());
        ClassNode[] argumentTypes = this.typeCheckingVisitor.getArgumentTypes(argumentListExpression);
        return this.argTypesMatches(argumentTypes, classes);
    }

    public boolean firstArgTypesMatches(ClassNode[] argTypes, Class ... classes) {
        if (classes == null) {
            return argTypes == null || argTypes.length == 0;
        }
        if (argTypes.length < classes.length) {
            return false;
        }
        boolean match = true;
        for (int i = 0; i < classes.length && match; ++i) {
            match = this.matchWithOrWithourBoxing(argTypes[i], classes[i]);
        }
        return match;
    }

    public boolean firstArgTypesMatches(MethodCall call, Class ... classes) {
        ArgumentListExpression argumentListExpression = InvocationWriter.makeArgumentList(call.getArguments());
        ClassNode[] argumentTypes = this.typeCheckingVisitor.getArgumentTypes(argumentListExpression);
        return this.firstArgTypesMatches(argumentTypes, classes);
    }

    public boolean argTypeMatches(ClassNode[] argTypes, int index, Class clazz) {
        if (index >= argTypes.length) {
            return false;
        }
        return this.matchWithOrWithourBoxing(argTypes[index], clazz);
    }

    public boolean argTypeMatches(MethodCall call, int index, Class clazz) {
        ArgumentListExpression argumentListExpression = InvocationWriter.makeArgumentList(call.getArguments());
        ClassNode[] argumentTypes = this.typeCheckingVisitor.getArgumentTypes(argumentListExpression);
        return this.argTypeMatches(argumentTypes, index, clazz);
    }

    public <R> R withTypeChecker(Closure<R> code) {
        Closure clone2 = (Closure)code.clone();
        clone2.setDelegate(this.typeCheckingVisitor);
        clone2.setResolveStrategy(1);
        return (R)clone2.call();
    }

    public BinaryExpression getEnclosingBinaryExpression() {
        return this.context.getEnclosingBinaryExpression();
    }

    public void pushEnclosingBinaryExpression(BinaryExpression binaryExpression) {
        this.context.pushEnclosingBinaryExpression(binaryExpression);
    }

    public void pushEnclosingClosureExpression(ClosureExpression closureExpression) {
        this.context.pushEnclosingClosureExpression(closureExpression);
    }

    public Expression getEnclosingMethodCall() {
        return this.context.getEnclosingMethodCall();
    }

    public Expression popEnclosingMethodCall() {
        return this.context.popEnclosingMethodCall();
    }

    public MethodNode popEnclosingMethod() {
        return this.context.popEnclosingMethod();
    }

    public ClassNode getEnclosingClassNode() {
        return this.context.getEnclosingClassNode();
    }

    public List<MethodNode> getEnclosingMethods() {
        return this.context.getEnclosingMethods();
    }

    public MethodNode getEnclosingMethod() {
        return this.context.getEnclosingMethod();
    }

    public void popTemporaryTypeInfo() {
        this.context.popTemporaryTypeInfo();
    }

    public void pushEnclosingClassNode(ClassNode classNode) {
        this.context.pushEnclosingClassNode(classNode);
    }

    public BinaryExpression popEnclosingBinaryExpression() {
        return this.context.popEnclosingBinaryExpression();
    }

    public List<ClassNode> getEnclosingClassNodes() {
        return this.context.getEnclosingClassNodes();
    }

    public List<TypeCheckingContext.EnclosingClosure> getEnclosingClosureStack() {
        return this.context.getEnclosingClosureStack();
    }

    public ClassNode popEnclosingClassNode() {
        return this.context.popEnclosingClassNode();
    }

    public void pushEnclosingMethod(MethodNode methodNode) {
        this.context.pushEnclosingMethod(methodNode);
    }

    public List<BinaryExpression> getEnclosingBinaryExpressionStack() {
        return this.context.getEnclosingBinaryExpressionStack();
    }

    public TypeCheckingContext.EnclosingClosure getEnclosingClosure() {
        return this.context.getEnclosingClosure();
    }

    public List<Expression> getEnclosingMethodCalls() {
        return this.context.getEnclosingMethodCalls();
    }

    public void pushEnclosingMethodCall(Expression call) {
        this.context.pushEnclosingMethodCall(call);
    }

    public TypeCheckingContext.EnclosingClosure popEnclosingClosure() {
        return this.context.popEnclosingClosure();
    }

    public void pushTemporaryTypeInfo() {
        this.context.pushTemporaryTypeInfo();
    }

    public static abstract class TypeCheckingDSL
    extends Script {
        private GroovyTypeCheckingExtensionSupport extension;

        public Object getProperty(String property) {
            try {
                return InvokerHelper.getProperty(this.extension, property);
            }
            catch (Exception e) {
                return super.getProperty(property);
            }
        }

        public void setProperty(String property, Object newValue) {
            try {
                InvokerHelper.setProperty(this.extension, property, newValue);
            }
            catch (Exception e) {
                super.setProperty(property, newValue);
            }
        }

        public Object invokeMethod(String name, Object args) {
            if (name.startsWith("is") && name.endsWith("Expression") && args instanceof Object[] && ((Object[])args).length == 1) {
                String type = name.substring(2);
                Object target = ((Object[])args)[0];
                if (target == null) {
                    return false;
                }
                try {
                    Class<?> typeClass = Class.forName("org.codehaus.groovy.ast.expr." + type);
                    return typeClass.isAssignableFrom(target.getClass());
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
            }
            if (args instanceof Object[] && ((Object[])args).length == 1 && ((Object[])args)[0] instanceof Closure) {
                Object[] argsArray = (Object[])args;
                String methodName = (String)METHOD_ALIASES.get(name);
                if (methodName == null) {
                    return InvokerHelper.invokeMethod(this.extension, name, args);
                }
                LinkedList<Closure> closures = (LinkedList<Closure>)this.extension.eventHandlers.get(methodName);
                if (closures == null) {
                    closures = new LinkedList<Closure>();
                    this.extension.eventHandlers.put(methodName, closures);
                }
                closures.add((Closure)argsArray[0]);
                return null;
            }
            return InvokerHelper.invokeMethod(this.extension, name, args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TypeCheckingScope
    extends LinkedHashMap<String, Object> {
        private final TypeCheckingScope parent;

        private TypeCheckingScope(TypeCheckingScope parentScope) {
            this.parent = parentScope;
        }

        public TypeCheckingScope getParent() {
            return this.parent;
        }
    }
}

