/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.ToString;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.transform.AbstractASTTransformUtil;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.CanonicalASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class ToStringASTTransformation
extends AbstractASTTransformation {
    static final Class MY_CLASS = ToString.class;
    static final ClassNode MY_TYPE = ClassHelper.make(MY_CLASS);
    static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    private static final ClassNode STRINGBUILDER_TYPE = ClassHelper.make(StringBuilder.class);
    private static final ClassNode INVOKER_TYPE = ClassHelper.make(InvokerHelper.class);

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.init(nodes, source);
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode anno = (AnnotationNode)nodes[0];
        if (!MY_TYPE.equals(anno.getClassNode())) {
            return;
        }
        if (parent instanceof ClassNode) {
            boolean includePackage;
            ClassNode cNode = (ClassNode)parent;
            this.checkNotInterface(cNode, MY_TYPE_NAME);
            boolean includeSuper = this.memberHasValue(anno, "includeSuper", true);
            boolean cacheToString = this.memberHasValue(anno, "cache", true);
            if (includeSuper && cNode.getSuperClass().getName().equals("java.lang.Object")) {
                this.addError("Error during " + MY_TYPE_NAME + " processing: includeSuper=true but '" + cNode.getName() + "' has no super class.", anno);
            }
            boolean includeNames = this.memberHasValue(anno, "includeNames", true);
            boolean includeFields = this.memberHasValue(anno, "includeFields", true);
            List<String> excludes = this.getMemberList(anno, "excludes");
            List<String> includes = this.getMemberList(anno, "includes");
            boolean ignoreNulls = this.memberHasValue(anno, "ignoreNulls", true);
            boolean bl = includePackage = !this.memberHasValue(anno, "includePackage", false);
            if (this.hasAnnotation(cNode, CanonicalASTTransformation.MY_TYPE)) {
                AnnotationNode canonical = cNode.getAnnotations(CanonicalASTTransformation.MY_TYPE).get(0);
                if (excludes == null || excludes.isEmpty()) {
                    excludes = this.getMemberList(canonical, "excludes");
                }
                if (includes == null || includes.isEmpty()) {
                    includes = this.getMemberList(canonical, "includes");
                }
            }
            if (includes != null && !includes.isEmpty() && excludes != null && !excludes.isEmpty()) {
                this.addError("Error during " + MY_TYPE_NAME + " processing: Only one of 'includes' and 'excludes' should be supplied not both.", anno);
            }
            ToStringASTTransformation.createToString(cNode, includeSuper, includeFields, excludes, includes, includeNames, ignoreNulls, includePackage, cacheToString);
        }
    }

    public static void createToString(ClassNode cNode, boolean includeSuper, boolean includeFields, List<String> excludes, List<String> includes, boolean includeNames) {
        ToStringASTTransformation.createToString(cNode, includeSuper, includeFields, excludes, includes, includeNames, false);
    }

    public static void createToString(ClassNode cNode, boolean includeSuper, boolean includeFields, List<String> excludes, List<String> includes, boolean includeNames, boolean ignoreNulls) {
        ToStringASTTransformation.createToString(cNode, includeSuper, includeFields, excludes, includes, includeNames, ignoreNulls, true);
    }

    public static void createToString(ClassNode cNode, boolean includeSuper, boolean includeFields, List<String> excludes, List<String> includes, boolean includeNames, boolean ignoreNulls, boolean includePackage) {
        ToStringASTTransformation.createToString(cNode, includeSuper, includeFields, excludes, includes, includeNames, ignoreNulls, includePackage, false);
    }

    public static void createToString(ClassNode cNode, boolean includeSuper, boolean includeFields, List<String> excludes, List<String> includes, boolean includeNames, boolean ignoreNulls, boolean includePackage, boolean cache) {
        Expression tempToString;
        boolean hasExistingToString = AbstractASTTransformUtil.hasDeclaredMethod(cNode, "toString", 0);
        if (hasExistingToString && AbstractASTTransformUtil.hasDeclaredMethod(cNode, "_toString", 0)) {
            return;
        }
        BlockStatement body = new BlockStatement();
        if (cache) {
            FieldNode cacheField = cNode.addField("$to$string", 4098, ClassHelper.STRING_TYPE, null);
            VariableExpression savedToString = new VariableExpression(cacheField);
            body.addStatement(new IfStatement(AbstractASTTransformUtil.equalsNullExpr(savedToString), AbstractASTTransformUtil.assignStatement(savedToString, ToStringASTTransformation.calculateToStringStatements(cNode, includeSuper, includeFields, excludes, includes, includeNames, ignoreNulls, includePackage, body)), new EmptyStatement()));
            tempToString = savedToString;
        } else {
            tempToString = ToStringASTTransformation.calculateToStringStatements(cNode, includeSuper, includeFields, excludes, includes, includeNames, ignoreNulls, includePackage, body);
        }
        body.addStatement(new ReturnStatement(tempToString));
        cNode.addMethod(new MethodNode(hasExistingToString ? "_toString" : "toString", hasExistingToString ? 2 : 1, ClassHelper.STRING_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, body));
    }

    private static Expression calculateToStringStatements(ClassNode cNode, boolean includeSuper, boolean includeFields, List<String> excludes, List<String> includes, boolean includeNames, boolean ignoreNulls, boolean includePackage, BlockStatement body) {
        VariableExpression result2 = new VariableExpression("_result");
        ConstructorCallExpression init2 = new ConstructorCallExpression(STRINGBUILDER_TYPE, MethodCallExpression.NO_ARGUMENTS);
        body.addStatement(AbstractASTTransformUtil.declStatement(result2, init2));
        VariableExpression first = new VariableExpression("$toStringFirst");
        body.addStatement(AbstractASTTransformUtil.declStatement(first, ConstantExpression.TRUE));
        String className = includePackage ? cNode.getName() : cNode.getNameWithoutPackage();
        body.addStatement(ToStringASTTransformation.append(result2, new ConstantExpression(className + "(")));
        List<PropertyNode> pList = AbstractASTTransformUtil.getInstanceProperties(cNode);
        for (PropertyNode pNode : pList) {
            if (ToStringASTTransformation.shouldSkip(pNode.getName(), excludes, includes)) continue;
            String getterName = "get" + Verifier.capitalize(pNode.getName());
            MethodCallExpression getter2 = new MethodCallExpression((Expression)VariableExpression.THIS_EXPRESSION, getterName, MethodCallExpression.NO_ARGUMENTS);
            ToStringASTTransformation.appendValue(body, result2, first, getter2, pNode.getName(), includeNames, ignoreNulls);
        }
        if (includeFields) {
            ArrayList<FieldNode> fList = new ArrayList<FieldNode>();
            fList.addAll(AbstractASTTransformUtil.getInstanceNonPropertyFields(cNode));
            for (FieldNode fNode : fList) {
                if (ToStringASTTransformation.shouldSkip(fNode.getName(), excludes, includes)) continue;
                ToStringASTTransformation.appendValue(body, result2, first, new VariableExpression(fNode), fNode.getName(), includeNames, ignoreNulls);
            }
        }
        if (includeSuper) {
            ToStringASTTransformation.appendCommaIfNotFirst(body, result2, first);
            ToStringASTTransformation.appendPrefix(body, result2, "super", includeNames);
            body.addStatement(ToStringASTTransformation.append(result2, new MethodCallExpression((Expression)VariableExpression.SUPER_EXPRESSION, "toString", MethodCallExpression.NO_ARGUMENTS)));
        }
        body.addStatement(ToStringASTTransformation.append(result2, new ConstantExpression(")")));
        MethodCallExpression toString2 = new MethodCallExpression((Expression)result2, "toString", MethodCallExpression.NO_ARGUMENTS);
        toString2.setImplicitThis(false);
        return toString2;
    }

    private static void appendValue(BlockStatement body, Expression result2, VariableExpression first, Expression value2, String name, boolean includeNames, boolean ignoreNulls) {
        BlockStatement thenBlock = new BlockStatement();
        Statement appendValue = ignoreNulls ? new IfStatement(AbstractASTTransformUtil.notNullExpr(value2), thenBlock, EmptyStatement.INSTANCE) : thenBlock;
        ToStringASTTransformation.appendCommaIfNotFirst(thenBlock, result2, first);
        ToStringASTTransformation.appendPrefix(thenBlock, result2, name, includeNames);
        thenBlock.addStatement(new IfStatement(AbstractASTTransformUtil.identicalExpr(value2, VariableExpression.THIS_EXPRESSION), ToStringASTTransformation.append(result2, new ConstantExpression("(this)")), ToStringASTTransformation.append(result2, new StaticMethodCallExpression(INVOKER_TYPE, "toString", value2))));
        body.addStatement(appendValue);
    }

    private static void appendCommaIfNotFirst(BlockStatement body, Expression result2, VariableExpression first) {
        body.addStatement(new IfStatement(new BooleanExpression(first), AbstractASTTransformUtil.assignStatement(first, ConstantExpression.FALSE), ToStringASTTransformation.append(result2, new ConstantExpression(", "))));
    }

    private static void appendPrefix(BlockStatement body, Expression result2, String name, boolean includeNames) {
        if (includeNames) {
            body.addStatement(ToStringASTTransformation.toStringPropertyName(result2, name));
        }
    }

    private static Statement toStringPropertyName(Expression result2, String fName) {
        BlockStatement body = new BlockStatement();
        body.addStatement(ToStringASTTransformation.append(result2, new ConstantExpression(fName + ":")));
        return body;
    }

    private static ExpressionStatement append(Expression result2, Expression expr) {
        MethodCallExpression append2 = new MethodCallExpression(result2, "append", expr);
        append2.setImplicitThis(false);
        return new ExpressionStatement(append2);
    }

    private static boolean shouldSkip(String name, List<String> excludes, List<String> includes) {
        return excludes != null && excludes.contains(name) || name.contains("$") || includes != null && !includes.isEmpty() && !includes.contains(name);
    }
}

