/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovyjarjarasm.asm.Opcodes;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class SingletonASTTransformation
implements ASTTransformation,
Opcodes {
    private String propertyName = "instance";

    public void visit(ASTNode[] nodes, SourceUnit source) {
        if (!(nodes[0] instanceof AnnotationNode) || !(nodes[1] instanceof AnnotatedNode)) {
            throw new RuntimeException(String.format("Internal error: wrong types: %s / %s. Expected: AnnotationNode / AnnotatedNode", nodes[0].getClass(), nodes[1].getClass()));
        }
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode node = (AnnotationNode)nodes[0];
        if (parent instanceof ClassNode) {
            Expression member;
            ClassNode classNode = (ClassNode)parent;
            Expression fieldNameAttribute = node.getMember("property");
            if (fieldNameAttribute instanceof ConstantExpression) {
                this.propertyName = (String)((ConstantExpression)fieldNameAttribute).getValue();
            }
            if ((member = node.getMember("lazy")) instanceof ConstantExpression && ((ConstantExpression)member).getValue().equals(true)) {
                this.createLazy(classNode);
            } else {
                this.createNonLazy(classNode);
            }
        }
    }

    private void createNonLazy(ClassNode classNode) {
        FieldNode fieldNode = classNode.addField(this.propertyName, 25, classNode.getPlainNodeReference(), new ConstructorCallExpression(classNode, new ArgumentListExpression()));
        this.createConstructor(classNode, fieldNode);
        BlockStatement body = new BlockStatement();
        body.addStatement(new ReturnStatement(new VariableExpression(fieldNode)));
        classNode.addMethod(this.getGetterName(), 9, classNode.getPlainNodeReference(), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, body);
    }

    private String getGetterName() {
        return "get" + Character.toUpperCase(this.propertyName.charAt(0)) + this.propertyName.substring(1);
    }

    private void createLazy(ClassNode classNode) {
        FieldNode fieldNode = classNode.addField(this.propertyName, 74, classNode.getPlainNodeReference(), null);
        this.createConstructor(classNode, fieldNode);
        BlockStatement body = new BlockStatement();
        VariableExpression instanceExpression = new VariableExpression(fieldNode);
        body.addStatement(new IfStatement(new BooleanExpression(new BinaryExpression(instanceExpression, Token.newSymbol("!=", -1, -1), ConstantExpression.NULL)), new ReturnStatement(instanceExpression), new SynchronizedStatement(new ClassExpression(classNode), new IfStatement(new BooleanExpression(new BinaryExpression(instanceExpression, Token.newSymbol("!=", -1, -1), ConstantExpression.NULL)), new ReturnStatement(instanceExpression), new ReturnStatement(new BinaryExpression(instanceExpression, Token.newSymbol("=", -1, -1), new ConstructorCallExpression(classNode, new ArgumentListExpression())))))));
        classNode.addMethod(this.getGetterName(), 9, classNode.getPlainNodeReference(), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, body);
    }

    private void createConstructor(ClassNode classNode, FieldNode field2) {
        List<ConstructorNode> list2 = classNode.getDeclaredConstructors();
        MethodNode found = null;
        for (MethodNode methodNode : list2) {
            Parameter[] parameters = methodNode.getParameters();
            if (parameters != null && parameters.length != 0) continue;
            found = methodNode;
            break;
        }
        if (found == null) {
            BlockStatement body = new BlockStatement();
            body.addStatement(new IfStatement(new BooleanExpression(new BinaryExpression(new VariableExpression(field2), Token.newSymbol("!=", -1, -1), ConstantExpression.NULL)), new ThrowStatement(new ConstructorCallExpression(ClassHelper.make(RuntimeException.class), new ArgumentListExpression(new ConstantExpression("Can't instantiate singleton " + classNode.getName() + ". Use " + classNode.getName() + "." + this.propertyName)))), new EmptyStatement()));
            classNode.addConstructor(new ConstructorNode(2, body));
        }
    }
}

