/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.WithReadLock;
import groovy.transform.WithWriteLock;
import groovyjarjarasm.asm.Opcodes;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class ReadWriteLockASTTransformation
implements ASTTransformation,
Opcodes {
    private static final ClassNode READ_LOCK_TYPE = ClassHelper.make(WithReadLock.class);
    private static final ClassNode WRITE_LOCK_TYPE = ClassHelper.make(WithWriteLock.class);
    private static final ClassNode LOCK_TYPE = ClassHelper.make(ReentrantReadWriteLock.class);
    private static final Token ASSIGN = Token.newSymbol("=", -1, -1);

    public void visit(ASTNode[] nodes, SourceUnit source) {
        ConstantExpression ce;
        Object valueObject;
        boolean isWriteLock;
        if (nodes.length != 2 || !(nodes[0] instanceof AnnotationNode) || !(nodes[1] instanceof AnnotatedNode)) {
            throw new RuntimeException("Internal error: expecting [AnnotationNode, AnnotatedNode] but got: " + Arrays.asList(nodes));
        }
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode node = (AnnotationNode)nodes[0];
        if (READ_LOCK_TYPE.equals(node.getClassNode())) {
            isWriteLock = false;
        } else if (WRITE_LOCK_TYPE.equals(node.getClassNode())) {
            isWriteLock = true;
        } else {
            throw new RuntimeException("Internal error: expecting [" + READ_LOCK_TYPE.getName() + ", " + WRITE_LOCK_TYPE.getName() + "]" + " but got: " + node.getClassNode().getName());
        }
        String myTypeName = "@" + node.getClassNode().getNameWithoutPackage();
        Expression valueExpr = node.getMember("value");
        String value2 = null;
        if (valueExpr instanceof ConstantExpression && (valueObject = (ce = (ConstantExpression)valueExpr).getValue()) != null) {
            value2 = valueObject.toString();
        }
        if (parent instanceof MethodNode) {
            MethodNode mNode = (MethodNode)parent;
            ClassNode cNode = mNode.getDeclaringClass();
            String lockExpr = this.determineLock(value2, cNode, mNode.isStatic(), myTypeName);
            MethodCallExpression lockType = isWriteLock ? new MethodCallExpression((Expression)new VariableExpression(lockExpr), "writeLock", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS) : new MethodCallExpression((Expression)new VariableExpression(lockExpr), "readLock", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
            MethodCallExpression acquireLock = new MethodCallExpression((Expression)lockType, "lock", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
            MethodCallExpression releaseLock = new MethodCallExpression((Expression)lockType, "unlock", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
            Statement originalCode = mNode.getCode();
            BlockStatement body = new BlockStatement();
            body.addStatement(new ExpressionStatement(acquireLock));
            body.addStatement(new TryCatchStatement(originalCode, new ExpressionStatement(releaseLock)));
            mNode.setCode(body);
        }
    }

    private String determineLock(String value2, ClassNode targetClass, boolean isStatic, String myTypeName) {
        if (value2 != null && value2.length() > 0 && !value2.equalsIgnoreCase("$reentrantlock")) {
            if (targetClass.getDeclaredField(value2) == null) {
                throw new RuntimeException("Error during " + myTypeName + " processing: lock field with name '" + value2 + "' not found in class " + targetClass.getName());
            }
            if (targetClass.getDeclaredField(value2).isStatic() != isStatic) {
                throw new RuntimeException("Error during " + myTypeName + " processing: lock field with name '" + value2 + "' should " + (isStatic ? "" : "not ") + "be static");
            }
            return value2;
        }
        if (isStatic) {
            FieldNode field2 = targetClass.getDeclaredField("$REENTRANTLOCK");
            if (field2 == null) {
                int visibility = 26;
                targetClass.addField("$REENTRANTLOCK", visibility, LOCK_TYPE, this.createLockObject());
            } else if (!field2.isStatic()) {
                throw new RuntimeException("Error during " + myTypeName + " processing: $REENTRANTLOCK field must be static");
            }
            return "$REENTRANTLOCK";
        }
        FieldNode field3 = targetClass.getDeclaredField("$reentrantlock");
        if (field3 == null) {
            int visibility = 18;
            targetClass.addField("$reentrantlock", visibility, LOCK_TYPE, this.createLockObject());
        } else if (field3.isStatic()) {
            throw new RuntimeException("Error during " + myTypeName + " processing: $reentrantlock field must not be static");
        }
        return "$reentrantlock";
    }

    private Expression createLockObject() {
        return new ConstructorCallExpression(LOCK_TYPE, MethodCallExpression.NO_ARGUMENTS);
    }
}

