/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import groovy.lang.Closure;
import groovy.lang.EmptyRange;
import groovy.lang.GString;
import groovy.lang.IntRange;
import groovy.lang.Range;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyMethodsSupport;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.RegexSupport;
import org.codehaus.groovy.runtime.StringBufferWriter;
import org.codehaus.groovy.runtime.callsite.BooleanClosureWrapper;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringGroovyMethods
extends DefaultGroovyMethodsSupport {
    static String lineSeparator = null;

    public static boolean asBoolean(CharSequence string2) {
        return string2.length() > 0;
    }

    public static boolean asBoolean(Matcher matcher) {
        RegexSupport.setLastMatcher(matcher);
        return matcher.find();
    }

    public static <T> T asType(CharSequence self, Class<T> c) {
        return StringGroovyMethods.asType(self.toString(), c);
    }

    public static <T> T asType(GString self, Class<T> c) {
        if (c == File.class) {
            return (T)new File(self.toString());
        }
        if (Number.class.isAssignableFrom(c) || c.isPrimitive()) {
            return StringGroovyMethods.asType(self.toString(), c);
        }
        return DefaultGroovyMethods.asType((Object)self, c);
    }

    public static <T> T asType(String self, Class<T> c) {
        if (c == List.class) {
            return (T)StringGroovyMethods.toList(self);
        }
        if (c == BigDecimal.class) {
            return (T)StringGroovyMethods.toBigDecimal(self);
        }
        if (c == BigInteger.class) {
            return (T)StringGroovyMethods.toBigInteger(self);
        }
        if (c == Long.class || c == Long.TYPE) {
            return (T)StringGroovyMethods.toLong(self);
        }
        if (c == Integer.class || c == Integer.TYPE) {
            return (T)StringGroovyMethods.toInteger(self);
        }
        if (c == Short.class || c == Short.TYPE) {
            return (T)StringGroovyMethods.toShort(self);
        }
        if (c == Byte.class || c == Byte.TYPE) {
            return (T)Byte.valueOf(self.trim());
        }
        if (c == Character.class || c == Character.TYPE) {
            return (T)StringGroovyMethods.toCharacter(self);
        }
        if (c == Double.class || c == Double.TYPE) {
            return (T)StringGroovyMethods.toDouble(self);
        }
        if (c == Float.class || c == Float.TYPE) {
            return (T)StringGroovyMethods.toFloat(self);
        }
        if (c == File.class) {
            return (T)new File(self);
        }
        if (DefaultTypeTransformation.isEnumSubclass(c)) {
            return (T)InvokerHelper.invokeMethod(c, "valueOf", new Object[]{self});
        }
        return DefaultGroovyMethods.asType((Object)self, c);
    }

    public static Pattern bitwiseNegate(CharSequence self) {
        return Pattern.compile(self.toString());
    }

    public static Pattern bitwiseNegate(String self) {
        return Pattern.compile(self);
    }

    public static CharSequence capitalize(CharSequence self) {
        return StringGroovyMethods.capitalize(self.toString());
    }

    public static String capitalize(String self) {
        if (self == null || self.length() == 0) {
            return self;
        }
        return Character.toUpperCase(self.charAt(0)) + self.substring(1);
    }

    public static CharSequence center(CharSequence self, Number numberOfChars) {
        return StringGroovyMethods.center(self.toString(), numberOfChars);
    }

    public static CharSequence center(CharSequence self, Number numberOfChars, CharSequence padding2) {
        return StringGroovyMethods.center(self.toString(), numberOfChars, padding2.toString());
    }

    public static String center(String self, Number numberOfChars) {
        return StringGroovyMethods.center(self, numberOfChars, " ");
    }

    public static String center(String self, Number numberOfChars, String padding2) {
        String semiPad;
        int numChars = numberOfChars.intValue();
        if (numChars <= self.length()) {
            return self;
        }
        int charsToAdd = numChars - self.length();
        String string2 = semiPad = charsToAdd % 2 == 1 ? StringGroovyMethods.getPadding(padding2, charsToAdd / 2 + 1) : StringGroovyMethods.getPadding(padding2, charsToAdd / 2);
        if (charsToAdd % 2 == 0) {
            return semiPad + self + semiPad;
        }
        return semiPad.substring(0, charsToAdd / 2) + self + semiPad;
    }

    public static boolean contains(CharSequence self, CharSequence text2) {
        return StringGroovyMethods.contains(self.toString(), text2.toString());
    }

    public static boolean contains(String self, String text2) {
        int idx = self.indexOf(text2);
        return idx >= 0;
    }

    public static int count(CharSequence self, CharSequence text2) {
        return StringGroovyMethods.count(self.toString(), text2.toString());
    }

    public static int count(String self, String text2) {
        int answer = 0;
        int idx = 0;
        while ((idx = self.indexOf(text2, idx)) >= answer) {
            ++answer;
            ++idx;
        }
        return answer;
    }

    private static StringBufferWriter createStringBufferWriter(StringBuffer self) {
        return new StringBufferWriter(self);
    }

    private static StringWriter createStringWriter(String self) {
        StringWriter answer = new StringWriter();
        answer.write(self);
        return answer;
    }

    public static CharSequence denormalize(CharSequence self) {
        return StringGroovyMethods.denormalize(self.toString());
    }

    public static String denormalize(String self) {
        int len;
        if (lineSeparator == null) {
            StringWriter sw = new StringWriter(2);
            try {
                BufferedWriter bw = new BufferedWriter(sw);
                bw.newLine();
                bw.flush();
                lineSeparator = sw.toString();
            }
            catch (IOException ioe) {
                lineSeparator = "\n";
            }
        }
        if ((len = self.length()) < 1) {
            return self;
        }
        StringBuilder sb = new StringBuilder(110 * len / 100);
        int i = 0;
        block6: while (i < len) {
            char ch = self.charAt(i++);
            switch (ch) {
                case '\r': {
                    sb.append(lineSeparator);
                    if (i >= len || self.charAt(i) != '\n') continue block6;
                    ++i;
                    continue block6;
                }
                case '\n': {
                    sb.append(lineSeparator);
                    continue block6;
                }
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static CharSequence drop(CharSequence self, int num) {
        if (num <= 0) {
            return self;
        }
        if (self.length() <= num) {
            return self.subSequence(0, 0);
        }
        return self.subSequence(num, self.length());
    }

    public static CharSequence dropWhile(CharSequence self, Closure condition) {
        int num;
        BooleanClosureWrapper bcw = new BooleanClosureWrapper(condition);
        for (num = 0; num < self.length(); ++num) {
            char value2 = self.charAt(num);
            if (!bcw.call(Character.valueOf(value2))) break;
        }
        return StringGroovyMethods.drop(self, num);
    }

    public static <T> T eachLine(CharSequence self, Closure<T> closure) throws IOException {
        return StringGroovyMethods.eachLine(self.toString(), closure);
    }

    public static <T> T eachLine(CharSequence self, int firstLine, Closure<T> closure) throws IOException {
        return StringGroovyMethods.eachLine(self.toString(), firstLine, closure);
    }

    public static <T> T eachLine(String self, Closure<T> closure) throws IOException {
        return StringGroovyMethods.eachLine(self, 0, closure);
    }

    public static <T> T eachLine(String self, int firstLine, Closure<T> closure) throws IOException {
        int count2 = firstLine;
        T result2 = null;
        for (String line : StringGroovyMethods.readLines(self)) {
            result2 = DefaultGroovyMethods.callClosureForLine(closure, line, count2);
            ++count2;
        }
        return result2;
    }

    public static String collectReplacements(String orig, Closure<String> transform2) {
        if (orig == null) {
            return orig;
        }
        StringBuilder sb = null;
        int len = orig.length();
        for (int i = 0; i < len; ++i) {
            char ch = orig.charAt(i);
            String replacement = transform2.call((Object)Character.valueOf(ch));
            if (replacement != null) {
                if (sb == null) {
                    sb = new StringBuilder((int)(1.1 * (double)len));
                    sb.append(orig.substring(0, i));
                }
                sb.append(replacement);
                continue;
            }
            if (sb == null) continue;
            sb.append(ch);
        }
        return sb == null ? orig : sb.toString();
    }

    public static String eachMatch(CharSequence self, CharSequence regex, Closure closure) {
        return StringGroovyMethods.eachMatch(self.toString(), regex.toString(), closure);
    }

    public static String eachMatch(CharSequence self, Pattern pattern, Closure closure) {
        return StringGroovyMethods.eachMatch(self.toString(), pattern, closure);
    }

    public static String eachMatch(String self, Pattern pattern, Closure closure) {
        Matcher m = pattern.matcher(self);
        DefaultGroovyMethods.each(m, closure);
        return self;
    }

    public static String eachMatch(String self, String regex, Closure closure) {
        return StringGroovyMethods.eachMatch(self, Pattern.compile(regex), closure);
    }

    public static CharSequence expand(CharSequence self) {
        return StringGroovyMethods.expand(self.toString(), 8);
    }

    public static CharSequence expand(CharSequence self, int tabStop) {
        return StringGroovyMethods.expand(self.toString(), tabStop);
    }

    public static String expand(String self) {
        return StringGroovyMethods.expand(self, 8);
    }

    public static String expand(String self, int tabStop) {
        if (self.length() == 0) {
            return self;
        }
        try {
            StringBuilder builder = new StringBuilder();
            for (String line : StringGroovyMethods.readLines(self)) {
                builder.append(StringGroovyMethods.expandLine(line, tabStop));
                builder.append("\n");
            }
            if (!self.endsWith("\n")) {
                builder.deleteCharAt(builder.length() - 1);
            }
            return builder.toString();
        }
        catch (IOException iOException) {
            return self;
        }
    }

    public static CharSequence expandLine(CharSequence self, int tabStop) {
        return StringGroovyMethods.expandLine(self.toString(), tabStop);
    }

    public static String expandLine(String self, int tabStop) {
        int index;
        while ((index = self.indexOf(9)) != -1) {
            StringBuilder builder = new StringBuilder(self);
            int count2 = tabStop - index % tabStop;
            builder.deleteCharAt(index);
            for (int i = 0; i < count2; ++i) {
                builder.insert(index, " ");
            }
            self = builder.toString();
        }
        return self;
    }

    public static CharSequence find(CharSequence self, CharSequence regex) {
        return StringGroovyMethods.find(self.toString(), Pattern.compile(regex.toString()));
    }

    public static CharSequence find(CharSequence self, CharSequence regex, Closure closure) {
        return StringGroovyMethods.find(self.toString(), Pattern.compile(regex.toString()), closure);
    }

    public static CharSequence find(CharSequence self, Pattern pattern) {
        return StringGroovyMethods.find(self.toString(), pattern);
    }

    public static CharSequence find(CharSequence self, Pattern pattern, Closure closure) {
        return StringGroovyMethods.find(self.toString(), pattern, closure);
    }

    public static String find(String self, Pattern pattern) {
        Matcher matcher = pattern.matcher(self);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return null;
    }

    public static String find(String self, Pattern pattern, Closure closure) {
        Matcher matcher = pattern.matcher(self);
        if (matcher.find()) {
            if (StringGroovyMethods.hasGroup(matcher)) {
                int count2 = matcher.groupCount();
                ArrayList<String> groups = new ArrayList<String>(count2);
                for (int i = 0; i <= count2; ++i) {
                    groups.add(matcher.group(i));
                }
                return InvokerHelper.toString(closure.call((Object)groups));
            }
            return InvokerHelper.toString(closure.call((Object)matcher.group(0)));
        }
        return null;
    }

    public static String find(String self, String regex) {
        return StringGroovyMethods.find(self, Pattern.compile(regex));
    }

    public static String find(String self, String regex, Closure closure) {
        return StringGroovyMethods.find(self, Pattern.compile(regex), closure);
    }

    public static List<CharSequence> findAll(CharSequence self, CharSequence regex) {
        return new ArrayList<CharSequence>(StringGroovyMethods.findAll(self.toString(), regex.toString()));
    }

    public static <T> List<T> findAll(CharSequence self, CharSequence regex, Closure<T> closure) {
        return StringGroovyMethods.findAll(self.toString(), regex.toString(), closure);
    }

    public static List<CharSequence> findAll(CharSequence self, Pattern pattern) {
        return new ArrayList<CharSequence>(StringGroovyMethods.findAll(self.toString(), pattern));
    }

    public static <T> List<T> findAll(CharSequence self, Pattern pattern, Closure<T> closure) {
        return StringGroovyMethods.findAll(self.toString(), pattern, closure);
    }

    public static List<String> findAll(String self, Pattern pattern) {
        Matcher matcher = pattern.matcher(self);
        ArrayList<String> list2 = new ArrayList<String>();
        Iterator iter2 = StringGroovyMethods.iterator(matcher);
        while (iter2.hasNext()) {
            if (StringGroovyMethods.hasGroup(matcher)) {
                list2.add((String)((List)iter2.next()).get(0));
                continue;
            }
            list2.add((String)iter2.next());
        }
        return list2;
    }

    public static <T> List<T> findAll(String self, Pattern pattern, Closure<T> closure) {
        Matcher matcher = pattern.matcher(self);
        return DefaultGroovyMethods.collect(matcher, closure);
    }

    public static List<String> findAll(String self, String regex) {
        return StringGroovyMethods.findAll(self, Pattern.compile(regex));
    }

    public static <T> List<T> findAll(String self, String regex, Closure<T> closure) {
        return StringGroovyMethods.findAll(self, Pattern.compile(regex), closure);
    }

    private static int findMinimumLeadingSpaces(String line, int count2) {
        int index;
        int length = line.length();
        for (index = 0; index < length && index < count2 && Character.isWhitespace(line.charAt(index)); ++index) {
        }
        return index;
    }

    public static CharSequence getAt(CharSequence self, Collection indices) {
        StringBuilder answer = new StringBuilder();
        for (Object value2 : indices) {
            if (value2 instanceof Range) {
                answer.append(StringGroovyMethods.getAt(self, (Range)value2));
                continue;
            }
            if (value2 instanceof Collection) {
                answer.append(StringGroovyMethods.getAt(self, (Collection)value2));
                continue;
            }
            int idx = DefaultTypeTransformation.intUnbox(value2);
            answer.append(StringGroovyMethods.getAt(self, idx));
        }
        return answer.toString();
    }

    public static CharSequence getAt(CharSequence text2, EmptyRange range2) {
        return "";
    }

    public static CharSequence getAt(CharSequence text2, int index) {
        index = StringGroovyMethods.normaliseIndex(index, text2.length());
        return text2.subSequence(index, index + 1);
    }

    public static CharSequence getAt(CharSequence text2, IntRange range2) {
        return StringGroovyMethods.getAt(text2, (Range)range2);
    }

    public static CharSequence getAt(CharSequence text2, Range range2) {
        int from2 = StringGroovyMethods.normaliseIndex(DefaultTypeTransformation.intUnbox(range2.getFrom()), text2.length());
        int to2 = StringGroovyMethods.normaliseIndex(DefaultTypeTransformation.intUnbox(range2.getTo()), text2.length());
        boolean reverse2 = range2.isReverse();
        if (from2 > to2) {
            int tmp = from2;
            from2 = to2;
            to2 = tmp;
            reverse2 = !reverse2;
        }
        CharSequence sequence2 = text2.subSequence(from2, to2 + 1);
        return reverse2 ? StringGroovyMethods.reverse((String)sequence2) : sequence2;
    }

    public static List getAt(Matcher self, Collection indices) {
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (Object value2 : indices) {
            if (value2 instanceof Range) {
                result2.addAll(StringGroovyMethods.getAt(self, (Collection)((Range)value2)));
                continue;
            }
            int idx = DefaultTypeTransformation.intUnbox(value2);
            result2.add(StringGroovyMethods.getAt(self, idx));
        }
        return result2;
    }

    public static Object getAt(Matcher matcher, int idx) {
        try {
            int count2 = StringGroovyMethods.getCount(matcher);
            if (idx < -count2 || idx >= count2) {
                throw new IndexOutOfBoundsException("index is out of range " + -count2 + ".." + (count2 - 1) + " (index = " + idx + ")");
            }
            idx = StringGroovyMethods.normaliseIndex(idx, count2);
            Iterator iter2 = StringGroovyMethods.iterator(matcher);
            Object result2 = null;
            for (int i = 0; i <= idx; ++i) {
                result2 = iter2.next();
            }
            return result2;
        }
        catch (IllegalStateException ex) {
            return null;
        }
    }

    public static boolean matchesPartially(Matcher matcher) {
        return matcher.matches() || matcher.hitEnd();
    }

    public static String getAt(String self, Collection indices) {
        return (String)StringGroovyMethods.getAt((CharSequence)self, indices);
    }

    public static String getAt(String text2, EmptyRange range2) {
        return "";
    }

    public static String getAt(String text2, int index) {
        index = StringGroovyMethods.normaliseIndex(index, text2.length());
        return text2.substring(index, index + 1);
    }

    public static String getAt(String text2, IntRange range2) {
        return StringGroovyMethods.getAt(text2, (Range)range2);
    }

    public static String getAt(String text2, Range range2) {
        int from2 = StringGroovyMethods.normaliseIndex(DefaultTypeTransformation.intUnbox(range2.getFrom()), text2.length());
        int to2 = StringGroovyMethods.normaliseIndex(DefaultTypeTransformation.intUnbox(range2.getTo()), text2.length());
        boolean reverse2 = range2.isReverse();
        if (from2 > to2) {
            int tmp = to2;
            to2 = from2;
            from2 = tmp;
            reverse2 = !reverse2;
        }
        String answer = text2.substring(from2, to2 + 1);
        if (reverse2) {
            answer = StringGroovyMethods.reverse(answer);
        }
        return answer;
    }

    public static char[] getChars(CharSequence self) {
        return StringGroovyMethods.getChars(self.toString());
    }

    public static char[] getChars(String self) {
        return self.toCharArray();
    }

    public static int getCount(Matcher matcher) {
        int counter = 0;
        matcher.reset();
        while (matcher.find()) {
            ++counter;
        }
        return counter;
    }

    private static String getPadding(String padding2, int length) {
        if (padding2.length() < length) {
            return StringGroovyMethods.multiply(padding2, (Number)(length / padding2.length() + 1)).substring(0, length);
        }
        return padding2.substring(0, length);
    }

    private static String getReplacement(Matcher matcher, Closure closure) {
        if (!StringGroovyMethods.hasGroup(matcher)) {
            return InvokerHelper.toString(closure.call((Object)matcher.group()));
        }
        int count2 = matcher.groupCount();
        ArrayList<String> groups = new ArrayList<String>();
        for (int i = 0; i <= count2; ++i) {
            groups.add(matcher.group(i));
        }
        if (closure.getParameterTypes().length == 1 && closure.getParameterTypes()[0] == Object[].class) {
            return InvokerHelper.toString(closure.call(groups.toArray()));
        }
        return InvokerHelper.toString(closure.call((Object)groups));
    }

    public static boolean hasGroup(Matcher matcher) {
        return matcher.groupCount() > 0;
    }

    public static boolean isAllWhitespace(CharSequence self) {
        return StringGroovyMethods.isAllWhitespace(self.toString());
    }

    public static boolean isAllWhitespace(String self) {
        for (int i = 0; i < self.length(); ++i) {
            if (Character.isWhitespace(self.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBigDecimal(CharSequence self) {
        return StringGroovyMethods.isBigDecimal(self.toString());
    }

    public static boolean isBigDecimal(String self) {
        try {
            new BigDecimal(self.trim());
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static boolean isBigInteger(CharSequence self) {
        return StringGroovyMethods.isBigInteger(self.toString());
    }

    public static boolean isBigInteger(String self) {
        try {
            new BigInteger(self.trim());
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static boolean isCase(CharSequence caseValue, Object switchValue) {
        return StringGroovyMethods.isCase(caseValue.toString(), switchValue);
    }

    public static boolean isCase(GString caseValue, Object switchValue) {
        return StringGroovyMethods.isCase(caseValue.toString(), switchValue);
    }

    public static boolean isCase(Pattern caseValue, Object switchValue) {
        if (switchValue == null) {
            return caseValue == null;
        }
        Matcher matcher = caseValue.matcher(switchValue.toString());
        if (matcher.matches()) {
            RegexSupport.setLastMatcher(matcher);
            return true;
        }
        return false;
    }

    public static boolean isCase(String caseValue, Object switchValue) {
        if (switchValue == null) {
            return caseValue == null;
        }
        return caseValue.equals(switchValue.toString());
    }

    public static boolean isDouble(CharSequence self) {
        return StringGroovyMethods.isDouble(self.toString());
    }

    public static boolean isDouble(String self) {
        try {
            Double.valueOf(self.trim());
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static boolean isFloat(CharSequence self) {
        return StringGroovyMethods.isFloat(self.toString());
    }

    public static boolean isFloat(String self) {
        try {
            Float.valueOf(self.trim());
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static boolean isInteger(CharSequence self) {
        return StringGroovyMethods.isInteger(self.toString());
    }

    public static boolean isInteger(String self) {
        try {
            Integer.valueOf(self.trim());
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static boolean isLong(CharSequence self) {
        return StringGroovyMethods.isLong(self.toString());
    }

    public static boolean isLong(String self) {
        try {
            Long.valueOf(self.trim());
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static boolean isNumber(CharSequence self) {
        return StringGroovyMethods.isNumber(self.toString());
    }

    public static boolean isNumber(String self) {
        return StringGroovyMethods.isBigDecimal(self);
    }

    public static Iterator iterator(final Matcher matcher) {
        matcher.reset();
        return new Iterator(){
            private boolean found;
            private boolean done;

            public boolean hasNext() {
                if (this.done) {
                    return false;
                }
                if (!this.found) {
                    this.found = matcher.find();
                    if (!this.found) {
                        this.done = true;
                    }
                }
                return this.found;
            }

            public Object next() {
                if (!this.found && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.found = false;
                if (StringGroovyMethods.hasGroup(matcher)) {
                    ArrayList<String> list2 = new ArrayList<String>(matcher.groupCount());
                    for (int i = 0; i <= matcher.groupCount(); ++i) {
                        list2.add(matcher.group(i));
                    }
                    return list2;
                }
                return matcher.group();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static StringBuilder leftShift(CharSequence self, Object value2) {
        return new StringBuilder(self).append(value2);
    }

    public static StringBuffer leftShift(String self, Object value2) {
        return new StringBuffer(self).append(value2);
    }

    public static StringBuffer leftShift(StringBuffer self, Object value2) {
        self.append(value2);
        return self;
    }

    public static StringBuilder leftShift(StringBuilder self, Object value2) {
        self.append(value2);
        return self;
    }

    public static boolean matches(CharSequence self, Pattern pattern) {
        return pattern.matcher(self).matches();
    }

    public static boolean matches(String self, Pattern pattern) {
        return pattern.matcher(self).matches();
    }

    public static CharSequence minus(CharSequence self, Object target) {
        return StringGroovyMethods.minus(self.toString(), target);
    }

    public static String minus(String self, Object target) {
        if (target instanceof Pattern) {
            return ((Pattern)target).matcher(self).replaceFirst("");
        }
        String text2 = DefaultGroovyMethods.toString(target);
        int index = self.indexOf(text2);
        if (index == -1) {
            return self;
        }
        int end = index + text2.length();
        if (self.length() > end) {
            return self.substring(0, index) + self.substring(end);
        }
        return self.substring(0, index);
    }

    public static CharSequence multiply(CharSequence self, Number factor) {
        return StringGroovyMethods.multiply(self.toString(), factor);
    }

    public static String multiply(String self, Number factor) {
        int size2 = factor.intValue();
        if (size2 == 0) {
            return "";
        }
        if (size2 < 0) {
            throw new IllegalArgumentException("multiply() should be called with a number of 0 or greater not: " + size2);
        }
        StringBuilder answer = new StringBuilder(self);
        for (int i = 1; i < size2; ++i) {
            answer.append(self);
        }
        return answer.toString();
    }

    public static CharSequence next(CharSequence self) {
        return StringGroovyMethods.next(self.toString());
    }

    public static String next(String self) {
        StringBuilder buffer = new StringBuilder(self);
        if (buffer.length() == 0) {
            buffer.append('\u0000');
        } else {
            char last2 = buffer.charAt(buffer.length() - 1);
            if (last2 == '\uffff') {
                buffer.append('\u0000');
            } else {
                char next2 = last2;
                next2 = (char)(next2 + '\u0001');
                buffer.setCharAt(buffer.length() - 1, next2);
            }
        }
        return buffer.toString();
    }

    public static CharSequence normalize(CharSequence self) {
        return StringGroovyMethods.normalize(self.toString());
    }

    public static String normalize(String self) {
        int nx = self.indexOf(13);
        if (nx < 0) {
            return self;
        }
        int len = self.length();
        StringBuilder sb = new StringBuilder(len);
        int i = 0;
        do {
            sb.append(self, i, nx);
            sb.append('\n');
        } while ((i = nx + 1) < len && (self.charAt(i) != '\n' || ++i < len) && (nx = self.indexOf(13, i)) > 0);
        sb.append(self, i, len);
        return sb.toString();
    }

    public static CharSequence padLeft(CharSequence self, Number numberOfChars) {
        return StringGroovyMethods.padLeft(self, numberOfChars, (CharSequence)" ");
    }

    public static CharSequence padLeft(CharSequence self, Number numberOfChars, CharSequence padding2) {
        return StringGroovyMethods.padLeft(self.toString(), numberOfChars, padding2.toString());
    }

    public static String padLeft(String self, Number numberOfChars) {
        return StringGroovyMethods.padLeft(self, numberOfChars, " ");
    }

    public static String padLeft(String self, Number numberOfChars, String padding2) {
        int numChars = numberOfChars.intValue();
        if (numChars <= self.length()) {
            return self;
        }
        return StringGroovyMethods.getPadding(padding2, numChars - self.length()) + self;
    }

    public static CharSequence padRight(CharSequence self, Number numberOfChars) {
        return StringGroovyMethods.padRight(self.toString(), numberOfChars);
    }

    public static CharSequence padRight(CharSequence self, Number numberOfChars, CharSequence padding2) {
        return StringGroovyMethods.padRight(self.toString(), numberOfChars, padding2.toString());
    }

    public static String padRight(String self, Number numberOfChars) {
        return StringGroovyMethods.padRight(self, numberOfChars, " ");
    }

    public static String padRight(String self, Number numberOfChars, String padding2) {
        int numChars = numberOfChars.intValue();
        if (numChars <= self.length()) {
            return self;
        }
        return self + StringGroovyMethods.getPadding(padding2, numChars - self.length());
    }

    public static CharSequence plus(CharSequence left, Object value2) {
        return left + DefaultGroovyMethods.toString(value2);
    }

    public static String plus(Number value2, String right) {
        return DefaultGroovyMethods.toString(value2) + right;
    }

    public static String plus(String left, Object value2) {
        return left + DefaultGroovyMethods.toString(value2);
    }

    public static String plus(StringBuffer left, String value2) {
        return left + value2;
    }

    public static CharSequence previous(CharSequence self) {
        return StringGroovyMethods.previous(self.toString());
    }

    public static String previous(String self) {
        StringBuilder buffer = new StringBuilder(self);
        if (buffer.length() == 0) {
            throw new IllegalArgumentException("the string is empty");
        }
        char last2 = buffer.charAt(buffer.length() - 1);
        if (last2 == '\u0000') {
            buffer.deleteCharAt(buffer.length() - 1);
        } else {
            char next2 = last2;
            next2 = (char)(next2 - '\u0001');
            buffer.setCharAt(buffer.length() - 1, next2);
        }
        return buffer.toString();
    }

    public static void putAt(StringBuffer self, EmptyRange range2, Object value2) {
        DefaultGroovyMethodsSupport.RangeInfo info = StringGroovyMethods.subListBorders(self.length(), range2);
        self.replace(info.from, info.to, value2.toString());
    }

    public static void putAt(StringBuffer self, IntRange range2, Object value2) {
        DefaultGroovyMethodsSupport.RangeInfo info = StringGroovyMethods.subListBorders(self.length(), range2);
        self.replace(info.from, info.to, value2.toString());
    }

    public static List<CharSequence> readLines(CharSequence self) throws IOException {
        return new ArrayList<CharSequence>(StringGroovyMethods.readLines(self.toString()));
    }

    public static List<String> readLines(String self) throws IOException {
        return IOGroovyMethods.readLines(new StringReader(self));
    }

    public static CharSequence replaceAll(CharSequence self, CharSequence regex, CharSequence replacement) {
        return self.toString().replaceAll(regex.toString(), replacement.toString());
    }

    public static CharSequence replaceAll(CharSequence self, CharSequence regex, Closure closure) {
        return StringGroovyMethods.replaceAll(self.toString(), Pattern.compile(regex.toString()), closure);
    }

    public static CharSequence replaceAll(CharSequence self, Pattern pattern, CharSequence replacement) {
        return pattern.matcher(self).replaceAll(replacement.toString());
    }

    public static String replaceAll(CharSequence self, Pattern pattern, Closure closure) {
        return StringGroovyMethods.replaceAll(self.toString(), pattern, closure);
    }

    public static String replaceAll(String self, Pattern pattern, Closure closure) {
        Matcher matcher = pattern.matcher(self);
        if (matcher.find()) {
            StringBuffer sb = new StringBuffer(self.length() + 16);
            do {
                String replacement = StringGroovyMethods.getReplacement(matcher, closure);
                matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
            } while (matcher.find());
            matcher.appendTail(sb);
            return sb.toString();
        }
        return self;
    }

    public static String replaceAll(String self, Pattern pattern, String replacement) {
        return pattern.matcher(self).replaceAll(replacement);
    }

    public static String replaceAll(String self, String regex, Closure closure) {
        return StringGroovyMethods.replaceAll(self, Pattern.compile(regex), closure);
    }

    public static String replaceFirst(CharSequence self, CharSequence regex, CharSequence replacement) {
        return self.toString().replaceFirst(regex.toString(), replacement.toString());
    }

    public static String replaceFirst(CharSequence self, CharSequence regex, Closure closure) {
        return StringGroovyMethods.replaceFirst(self.toString(), regex.toString(), closure);
    }

    public static CharSequence replaceFirst(CharSequence self, Pattern pattern, CharSequence replacement) {
        return pattern.matcher(self).replaceFirst(replacement.toString());
    }

    public static String replaceFirst(CharSequence self, Pattern pattern, Closure closure) {
        return StringGroovyMethods.replaceFirst(self.toString(), pattern, closure);
    }

    public static String replaceFirst(String self, Pattern pattern, Closure closure) {
        Matcher matcher = pattern.matcher(self);
        if (matcher.find()) {
            StringBuffer sb = new StringBuffer(self.length() + 16);
            String replacement = StringGroovyMethods.getReplacement(matcher, closure);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
            matcher.appendTail(sb);
            return sb.toString();
        }
        return self;
    }

    public static String replaceFirst(String self, Pattern pattern, String replacement) {
        return pattern.matcher(self).replaceFirst(replacement);
    }

    public static String replaceFirst(String self, String regex, Closure closure) {
        return StringGroovyMethods.replaceFirst(self, Pattern.compile(regex), closure);
    }

    public static CharSequence reverse(CharSequence self) {
        return new StringBuilder(self).reverse().toString();
    }

    public static String reverse(String self) {
        return new StringBuilder(self).reverse().toString();
    }

    public static void setIndex(Matcher matcher, int idx) {
        block4: {
            block5: {
                block3: {
                    int count2 = StringGroovyMethods.getCount(matcher);
                    if (idx < -count2 || idx >= count2) {
                        throw new IndexOutOfBoundsException("index is out of range " + -count2 + ".." + (count2 - 1) + " (index = " + idx + ")");
                    }
                    if (idx != 0) break block3;
                    matcher.reset();
                    break block4;
                }
                if (idx <= 0) break block5;
                matcher.reset();
                for (int i = 0; i < idx; ++i) {
                    matcher.find();
                }
                break block4;
            }
            if (idx >= 0) break block4;
            matcher.reset();
            idx += StringGroovyMethods.getCount(matcher);
            for (int i = 0; i < idx; ++i) {
                matcher.find();
            }
        }
    }

    public static int size(CharSequence text2) {
        return text2.length();
    }

    public static long size(Matcher self) {
        return StringGroovyMethods.getCount(self);
    }

    public static int size(String text2) {
        return text2.length();
    }

    public static int size(StringBuffer buffer) {
        return buffer.length();
    }

    public static CharSequence[] split(CharSequence self) {
        return StringGroovyMethods.split(self.toString());
    }

    public static String[] split(GString self) {
        return StringGroovyMethods.split(self.toString());
    }

    public static String[] split(String self) {
        StringTokenizer st = new StringTokenizer(self);
        String[] strings = new String[st.countTokens()];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = st.nextToken();
        }
        return strings;
    }

    public static <T> T splitEachLine(CharSequence self, CharSequence regex, Closure<T> closure) throws IOException {
        return StringGroovyMethods.splitEachLine(self.toString(), regex.toString(), closure);
    }

    public static <T> T splitEachLine(CharSequence self, Pattern pattern, Closure<T> closure) throws IOException {
        return StringGroovyMethods.splitEachLine(self.toString(), pattern, closure);
    }

    public static <T> T splitEachLine(String self, Pattern pattern, Closure<T> closure) throws IOException {
        List<String> list2 = StringGroovyMethods.readLines(self);
        T result2 = null;
        for (String line : list2) {
            List<String> vals = Arrays.asList(pattern.split(line));
            result2 = closure.call((Object)vals);
        }
        return result2;
    }

    public static <T> T splitEachLine(String self, String regex, Closure<T> closure) throws IOException {
        return StringGroovyMethods.splitEachLine(self, Pattern.compile(regex), closure);
    }

    public static CharSequence stripIndent(CharSequence self) {
        return StringGroovyMethods.stripIndent(self.toString());
    }

    public static CharSequence stripIndent(CharSequence self, int numChars) {
        return StringGroovyMethods.stripIndent(self);
    }

    public static String stripIndent(String self) {
        if (self.length() == 0) {
            return self;
        }
        int runningCount = -1;
        try {
            for (String line : StringGroovyMethods.readLines(self)) {
                if (StringGroovyMethods.isAllWhitespace(line)) continue;
                if (runningCount == -1) {
                    runningCount = line.length();
                }
                if ((runningCount = StringGroovyMethods.findMinimumLeadingSpaces(line, runningCount)) != 0) continue;
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return StringGroovyMethods.stripIndent(self, runningCount == -1 ? 0 : runningCount);
    }

    public static String stripIndent(String self, int numChars) {
        if (self.length() == 0 || numChars <= 0) {
            return self;
        }
        try {
            StringBuilder builder = new StringBuilder();
            for (String line : StringGroovyMethods.readLines(self)) {
                if (!StringGroovyMethods.isAllWhitespace(line)) {
                    builder.append(StringGroovyMethods.stripIndentFromLine(line, numChars));
                }
                builder.append("\n");
            }
            if (!self.endsWith("\n")) {
                builder.deleteCharAt(builder.length() - 1);
            }
            return builder.toString();
        }
        catch (IOException iOException) {
            return self;
        }
    }

    private static String stripIndentFromLine(String line, int numChars) {
        int length = line.length();
        return numChars <= length ? line.substring(numChars) : "";
    }

    public static CharSequence stripMargin(CharSequence self) {
        return StringGroovyMethods.stripMargin(self, '|');
    }

    public static CharSequence stripMargin(CharSequence self, char marginChar) {
        return StringGroovyMethods.stripMargin(self.toString(), marginChar);
    }

    public static String stripMargin(CharSequence self, CharSequence marginChar) {
        return StringGroovyMethods.stripMargin(self.toString(), marginChar.toString());
    }

    public static String stripMargin(String self) {
        return StringGroovyMethods.stripMargin(self, '|');
    }

    public static String stripMargin(String self, char marginChar) {
        if (self.length() == 0) {
            return self;
        }
        try {
            StringBuilder builder = new StringBuilder();
            for (String line : StringGroovyMethods.readLines(self)) {
                builder.append(StringGroovyMethods.stripMarginFromLine(line, marginChar));
                builder.append("\n");
            }
            if (!self.endsWith("\n")) {
                builder.deleteCharAt(builder.length() - 1);
            }
            return builder.toString();
        }
        catch (IOException iOException) {
            return self;
        }
    }

    public static String stripMargin(String self, String marginChar) {
        if (marginChar == null || marginChar.length() == 0) {
            return StringGroovyMethods.stripMargin(self, '|');
        }
        return StringGroovyMethods.stripMargin(self, marginChar.charAt(0));
    }

    private static String stripMarginFromLine(String line, char marginChar) {
        int index;
        int length = line.length();
        for (index = 0; index < length && line.charAt(index) <= ' '; ++index) {
        }
        return index < length && line.charAt(index) == marginChar ? line.substring(index + 1) : line;
    }

    public static CharSequence take(CharSequence self, int num) {
        if (num < 0) {
            return self.subSequence(0, 0);
        }
        if (self.length() <= num) {
            return self;
        }
        return self.subSequence(0, num);
    }

    public static CharSequence takeWhile(CharSequence self, Closure condition) {
        int num;
        BooleanClosureWrapper bcw = new BooleanClosureWrapper(condition);
        for (num = 0; num < self.length(); ++num) {
            char value2 = self.charAt(num);
            if (!bcw.call(Character.valueOf(value2))) break;
        }
        return StringGroovyMethods.take(self, num);
    }

    public static BigDecimal toBigDecimal(CharSequence self) {
        return StringGroovyMethods.toBigDecimal(self.toString());
    }

    public static BigDecimal toBigDecimal(String self) {
        return new BigDecimal(self.trim());
    }

    public static BigInteger toBigInteger(CharSequence self) {
        return StringGroovyMethods.toBigInteger(self.toString());
    }

    public static BigInteger toBigInteger(String self) {
        return new BigInteger(self.trim());
    }

    public static Boolean toBoolean(String self) {
        String trimmed = self.trim();
        if ("true".equalsIgnoreCase(trimmed) || "y".equalsIgnoreCase(trimmed) || "1".equals(trimmed)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Character toCharacter(String self) {
        return Character.valueOf(self.charAt(0));
    }

    public static Double toDouble(CharSequence self) {
        return StringGroovyMethods.toDouble(self.toString());
    }

    public static Double toDouble(String self) {
        return Double.valueOf(self.trim());
    }

    public static Float toFloat(CharSequence self) {
        return StringGroovyMethods.toFloat(self.toString());
    }

    public static Float toFloat(String self) {
        return Float.valueOf(self.trim());
    }

    public static Integer toInteger(CharSequence self) {
        return StringGroovyMethods.toInteger(self.toString());
    }

    public static Integer toInteger(String self) {
        return Integer.valueOf(self.trim());
    }

    public static List<CharSequence> tokenize(CharSequence self) {
        return new ArrayList<CharSequence>(StringGroovyMethods.tokenize(self.toString()));
    }

    public static List<CharSequence> tokenize(CharSequence self, Character token2) {
        return StringGroovyMethods.tokenize(self, (CharSequence)token2.toString());
    }

    public static List<CharSequence> tokenize(CharSequence self, CharSequence token2) {
        return new ArrayList<CharSequence>(StringGroovyMethods.tokenize(self.toString(), token2.toString()));
    }

    public static List<String> tokenize(String self) {
        return InvokerHelper.asList(new StringTokenizer(self));
    }

    public static List<String> tokenize(String self, Character token2) {
        return StringGroovyMethods.tokenize(self, token2.toString());
    }

    public static List<String> tokenize(String self, String token2) {
        return InvokerHelper.asList(new StringTokenizer(self, token2));
    }

    public static List<CharSequence> toList(CharSequence self) {
        return new ArrayList<CharSequence>(StringGroovyMethods.toList(self.toString()));
    }

    public static List<String> toList(String self) {
        int size2 = self.length();
        ArrayList<String> answer = new ArrayList<String>(size2);
        for (int i = 0; i < size2; ++i) {
            answer.add(self.substring(i, i + 1));
        }
        return answer;
    }

    public static Long toLong(CharSequence self) {
        return StringGroovyMethods.toLong(self.toString());
    }

    public static Long toLong(String self) {
        return Long.valueOf(self.trim());
    }

    public static Set<CharSequence> toSet(CharSequence self) {
        return new HashSet<CharSequence>(StringGroovyMethods.toList(self));
    }

    public static Set<String> toSet(String self) {
        return new HashSet<String>(StringGroovyMethods.toList(self));
    }

    public static Short toShort(CharSequence self) {
        return StringGroovyMethods.toShort(self.toString());
    }

    public static Short toShort(String self) {
        return Short.valueOf(self.trim());
    }

    public static CharSequence tr(CharSequence self, CharSequence sourceSet, CharSequence replacementSet) throws ClassNotFoundException {
        return StringGroovyMethods.tr(self.toString(), sourceSet.toString(), replacementSet.toString());
    }

    public static String tr(String self, String sourceSet, String replacementSet) throws ClassNotFoundException {
        return (String)InvokerHelper.invokeStaticMethod("org.codehaus.groovy.util.StringUtil", "tr", (Object)new Object[]{self, sourceSet, replacementSet});
    }

    public static CharSequence unexpand(CharSequence self) {
        return StringGroovyMethods.unexpand(self.toString());
    }

    public static CharSequence unexpand(CharSequence self, int tabStop) {
        return StringGroovyMethods.unexpand(self.toString(), tabStop);
    }

    public static String unexpand(String self) {
        return StringGroovyMethods.unexpand(self, 8);
    }

    public static String unexpand(String self, int tabStop) {
        if (self.length() == 0) {
            return self;
        }
        try {
            StringBuilder builder = new StringBuilder();
            for (String line : StringGroovyMethods.readLines(self)) {
                builder.append(StringGroovyMethods.unexpandLine(line, tabStop));
                builder.append("\n");
            }
            if (!self.endsWith("\n")) {
                builder.deleteCharAt(builder.length() - 1);
            }
            return builder.toString();
        }
        catch (IOException iOException) {
            return self;
        }
    }

    public static CharSequence unexpandLine(CharSequence self, int tabStop) {
        return StringGroovyMethods.unexpandLine(self.toString(), tabStop);
    }

    public static String unexpandLine(String self, int tabStop) {
        StringBuilder builder = new StringBuilder(self);
        int index = 0;
        while (index + tabStop < builder.length()) {
            int count2;
            String piece = builder.substring(index, index + tabStop);
            for (count2 = 0; count2 < tabStop && Character.isWhitespace(piece.charAt(tabStop - (count2 + 1))); ++count2) {
            }
            if (count2 > 0) {
                piece = piece.substring(0, tabStop - count2) + '\t';
                builder.replace(index, index + tabStop, piece);
                index = index + tabStop - (count2 - 1);
                continue;
            }
            index += tabStop;
        }
        return builder.toString();
    }
}

