/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyInterceptable;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Range;
import groovy.lang.Script;
import groovy.lang.SpreadMap;
import groovy.lang.SpreadMapEvaluatingException;
import groovy.lang.Tuple;
import groovy.lang.Writable;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.MethodClosure;
import org.codehaus.groovy.runtime.NullObject;
import org.codehaus.groovy.runtime.RegexSupport;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.metaclass.MetaClassRegistryImpl;
import org.codehaus.groovy.runtime.metaclass.MissingMethodExecutionFailed;
import org.codehaus.groovy.runtime.powerassert.PowerAssertionError;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.wrappers.PojoWrapper;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokerHelper {
    private static final Object[] EMPTY_MAIN_ARGS = new Object[]{new String[0]};
    public static final Object[] EMPTY_ARGS = new Object[0];
    protected static final Object[] EMPTY_ARGUMENTS = EMPTY_ARGS;
    protected static final Class[] EMPTY_TYPES = new Class[0];
    public static final MetaClassRegistry metaRegistry = GroovySystem.getMetaClassRegistry();

    public static void removeClass(Class clazz) {
        metaRegistry.removeMetaClass(clazz);
        Introspector.flushFromCaches(clazz);
    }

    public static Object invokeMethodSafe(Object object, String methodName, Object arguments) {
        if (object != null) {
            return InvokerHelper.invokeMethod(object, methodName, arguments);
        }
        return null;
    }

    public static Object invokeStaticMethod(String klass, String methodName, Object arguments) throws ClassNotFoundException {
        Class<?> type = Class.forName(klass);
        return InvokerHelper.invokeStaticMethod(type, methodName, arguments);
    }

    public static Object invokeStaticNoArgumentsMethod(Class type, String methodName) {
        return InvokerHelper.invokeStaticMethod(type, methodName, (Object)EMPTY_ARGS);
    }

    public static Object invokeConstructorOf(String klass, Object arguments) throws ClassNotFoundException {
        Class<?> type = Class.forName(klass);
        return InvokerHelper.invokeConstructorOf(type, arguments);
    }

    public static Object invokeNoArgumentsConstructorOf(Class type) {
        return InvokerHelper.invokeConstructorOf(type, (Object)EMPTY_ARGS);
    }

    public static Object invokeClosure(Object closure, Object arguments) {
        return InvokerHelper.invokeMethod(closure, "doCall", arguments);
    }

    public static List asList(Object value2) {
        if (value2 == null) {
            return Collections.EMPTY_LIST;
        }
        if (value2 instanceof List) {
            return (List)value2;
        }
        if (value2.getClass().isArray()) {
            return Arrays.asList((Object[])value2);
        }
        if (value2 instanceof Enumeration) {
            ArrayList answer = new ArrayList();
            Enumeration e = (Enumeration)value2;
            while (e.hasMoreElements()) {
                answer.add(e.nextElement());
            }
            return answer;
        }
        return Collections.singletonList(value2);
    }

    public static String toString(Object arguments) {
        if (arguments instanceof Object[]) {
            return InvokerHelper.toArrayString((Object[])arguments);
        }
        if (arguments instanceof Collection) {
            return InvokerHelper.toListString((Collection)arguments);
        }
        if (arguments instanceof Map) {
            return InvokerHelper.toMapString((Map)arguments);
        }
        return InvokerHelper.format(arguments, false);
    }

    public static String inspect(Object self) {
        return InvokerHelper.format(self, true);
    }

    public static Object getAttribute(Object object, String attribute) {
        if (object == null) {
            object = NullObject.getNullObject();
        }
        if (object instanceof Class) {
            return metaRegistry.getMetaClass((Class)object).getAttribute(object, attribute);
        }
        if (object instanceof GroovyObject) {
            return ((GroovyObject)object).getMetaClass().getAttribute(object, attribute);
        }
        return metaRegistry.getMetaClass(object.getClass()).getAttribute(object, attribute);
    }

    public static void setAttribute(Object object, String attribute, Object newValue) {
        if (object == null) {
            object = NullObject.getNullObject();
        }
        if (object instanceof Class) {
            metaRegistry.getMetaClass((Class)object).setAttribute(object, attribute, newValue);
        } else if (object instanceof GroovyObject) {
            ((GroovyObject)object).getMetaClass().setAttribute(object, attribute, newValue);
        } else {
            metaRegistry.getMetaClass(object.getClass()).setAttribute(object, attribute, newValue);
        }
    }

    public static Object getProperty(Object object, String property) {
        if (object == null) {
            object = NullObject.getNullObject();
        }
        if (object instanceof GroovyObject) {
            GroovyObject pogo = (GroovyObject)object;
            return pogo.getProperty(property);
        }
        if (object instanceof Class) {
            Class c = (Class)object;
            return metaRegistry.getMetaClass(c).getProperty(object, property);
        }
        return ((MetaClassRegistryImpl)metaRegistry).getMetaClass(object).getProperty(object, property);
    }

    public static Object getPropertySafe(Object object, String property) {
        if (object != null) {
            return InvokerHelper.getProperty(object, property);
        }
        return null;
    }

    public static void setProperty(Object object, String property, Object newValue) {
        if (object == null) {
            object = NullObject.getNullObject();
        }
        if (object instanceof GroovyObject) {
            GroovyObject pogo = (GroovyObject)object;
            pogo.setProperty(property, newValue);
        } else if (object instanceof Class) {
            metaRegistry.getMetaClass((Class)object).setProperty((Class)object, property, newValue);
        } else {
            ((MetaClassRegistryImpl)GroovySystem.getMetaClassRegistry()).getMetaClass(object).setProperty(object, property, newValue);
        }
    }

    public static void setProperty2(Object newValue, Object object, String property) {
        InvokerHelper.setProperty(object, property, newValue);
    }

    public static void setGroovyObjectProperty(Object newValue, GroovyObject object, String property) {
        object.setProperty(property, newValue);
    }

    public static Object getGroovyObjectProperty(GroovyObject object, String property) {
        return object.getProperty(property);
    }

    public static void setPropertySafe2(Object newValue, Object object, String property) {
        if (object != null) {
            InvokerHelper.setProperty2(newValue, object, property);
        }
    }

    public static Closure getMethodPointer(Object object, String methodName) {
        if (object == null) {
            throw new NullPointerException("Cannot access method pointer for '" + methodName + "' on null object");
        }
        return new MethodClosure(object, methodName);
    }

    public static Object unaryMinus(Object value2) {
        if (value2 instanceof Integer) {
            Integer number2 = (Integer)value2;
            return -number2.intValue();
        }
        if (value2 instanceof Long) {
            Long number3 = (Long)value2;
            return -number3.longValue();
        }
        if (value2 instanceof BigInteger) {
            return ((BigInteger)value2).negate();
        }
        if (value2 instanceof BigDecimal) {
            return ((BigDecimal)value2).negate();
        }
        if (value2 instanceof Double) {
            Double number4 = (Double)value2;
            return -number4.doubleValue();
        }
        if (value2 instanceof Float) {
            Float number5 = (Float)value2;
            return Float.valueOf(-number5.floatValue());
        }
        if (value2 instanceof Short) {
            Short number6 = (Short)value2;
            return -number6.shortValue();
        }
        if (value2 instanceof Byte) {
            Byte number7 = (Byte)value2;
            return -number7.byteValue();
        }
        if (value2 instanceof ArrayList) {
            ArrayList<Object> newlist = new ArrayList<Object>();
            Iterator it = ((ArrayList)value2).iterator();
            while (it.hasNext()) {
                newlist.add(InvokerHelper.unaryMinus(it.next()));
            }
            return newlist;
        }
        return InvokerHelper.invokeMethod(value2, "negative", EMPTY_ARGS);
    }

    public static Object unaryPlus(Object value2) {
        if (value2 instanceof Integer || value2 instanceof Long || value2 instanceof BigInteger || value2 instanceof BigDecimal || value2 instanceof Double || value2 instanceof Float || value2 instanceof Short || value2 instanceof Byte) {
            return value2;
        }
        if (value2 instanceof ArrayList) {
            ArrayList<Object> newlist = new ArrayList<Object>();
            Iterator it = ((ArrayList)value2).iterator();
            while (it.hasNext()) {
                newlist.add(InvokerHelper.unaryPlus(it.next()));
            }
            return newlist;
        }
        return InvokerHelper.invokeMethod(value2, "positive", EMPTY_ARGS);
    }

    public static Matcher findRegex(Object left, Object right) {
        String regexToCompareTo;
        String stringToCompare = left instanceof String ? (String)left : InvokerHelper.toString(left);
        if (right instanceof String) {
            regexToCompareTo = (String)right;
        } else {
            if (right instanceof Pattern) {
                Pattern pattern = (Pattern)right;
                return pattern.matcher(stringToCompare);
            }
            regexToCompareTo = InvokerHelper.toString(right);
        }
        return Pattern.compile(regexToCompareTo).matcher(stringToCompare);
    }

    public static boolean matchRegex(Object left, Object right) {
        if (left == null || right == null) {
            return false;
        }
        Pattern pattern = right instanceof Pattern ? (Pattern)right : Pattern.compile(InvokerHelper.toString(right));
        String stringToCompare = InvokerHelper.toString(left);
        Matcher matcher = pattern.matcher(stringToCompare);
        RegexSupport.setLastMatcher(matcher);
        return matcher.matches();
    }

    public static Tuple createTuple(Object[] array) {
        return new Tuple(array);
    }

    public static SpreadMap spreadMap(Object value2) {
        if (value2 instanceof Map) {
            Object[] values2 = new Object[((Map)value2).keySet().size() * 2];
            int index = 0;
            for (Object key : ((Map)value2).keySet()) {
                values2[index++] = key;
                values2[index++] = ((Map)value2).get(key);
            }
            return new SpreadMap(values2);
        }
        throw new SpreadMapEvaluatingException("Cannot spread the map " + value2.getClass().getName() + ", value " + value2);
    }

    public static List createList(Object[] values2) {
        ArrayList<Object> answer = new ArrayList<Object>(values2.length);
        answer.addAll(Arrays.asList(values2));
        return answer;
    }

    public static Map createMap(Object[] values2) {
        LinkedHashMap<Object, Object> answer = new LinkedHashMap<Object, Object>(values2.length / 2);
        int i = 0;
        while (i < values2.length - 1) {
            if (values2[i] instanceof SpreadMap && values2[i + 1] instanceof Map) {
                Map smap = (Map)values2[i + 1];
                for (Object key : smap.keySet()) {
                    answer.put(key, smap.get(key));
                }
                i += 2;
                continue;
            }
            answer.put(values2[i++], values2[i++]);
        }
        return answer;
    }

    public static void assertFailed(Object expression, Object message) {
        if (message == null || "".equals(message)) {
            throw new PowerAssertionError(expression.toString());
        }
        throw new AssertionError((Object)(String.valueOf(message) + ". Expression: " + expression));
    }

    public static Object runScript(Class scriptClass, String[] args) {
        Binding context = new Binding(args);
        Script script = InvokerHelper.createScript(scriptClass, context);
        return InvokerHelper.invokeMethod(script, "run", EMPTY_ARGS);
    }

    public static Script createScript(Class scriptClass, Binding context) {
        Script script = null;
        if (scriptClass == null) {
            script = new Script(){

                public Object run() {
                    return null;
                }
            };
        } else {
            try {
                final GroovyObject object = (GroovyObject)scriptClass.newInstance();
                if (object instanceof Script) {
                    script = (Script)object;
                } else {
                    script = new Script(){

                        public Object run() {
                            Object args = this.getBinding().getVariables().get("args");
                            Object argsToPass = EMPTY_MAIN_ARGS;
                            if (args != null && args instanceof String[]) {
                                argsToPass = args;
                            }
                            object.invokeMethod("main", argsToPass);
                            return null;
                        }
                    };
                    InvokerHelper.setProperties(object, context.getVariables());
                }
            }
            catch (Exception e) {
                throw new GroovyRuntimeException("Failed to create Script instance for class: " + scriptClass + ". Reason: " + e, e);
            }
        }
        script.setBinding(context);
        return script;
    }

    public static void setProperties(Object object, Map map2) {
        MetaClass mc = InvokerHelper.getMetaClass(object);
        Iterator i$ = map2.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry entry2 = o = i$.next();
            String key = entry2.getKey().toString();
            Object value2 = entry2.getValue();
            try {
                mc.setProperty(object, key, value2);
            }
            catch (MissingPropertyException mpe) {}
        }
    }

    public static void write(Writer out, Object object) throws IOException {
        if (object instanceof String) {
            out.write((String)object);
        } else if (object instanceof Object[]) {
            out.write(InvokerHelper.toArrayString((Object[])object));
        } else if (object instanceof Map) {
            out.write(InvokerHelper.toMapString((Map)object));
        } else if (object instanceof Collection) {
            out.write(InvokerHelper.toListString((Collection)object));
        } else if (object instanceof Writable) {
            Writable writable = (Writable)object;
            writable.writeTo(out);
        } else if (object instanceof InputStream || object instanceof Reader) {
            int i;
            Reader reader = object instanceof InputStream ? new InputStreamReader((InputStream)object) : (Reader)object;
            char[] chars = new char[8192];
            while ((i = reader.read(chars)) != -1) {
                out.write(chars, 0, i);
            }
            reader.close();
        } else {
            out.write(InvokerHelper.toString(object));
        }
    }

    public static void append(Appendable out, Object object) throws IOException {
        if (object instanceof String) {
            out.append((String)object);
        } else if (object instanceof Object[]) {
            out.append(InvokerHelper.toArrayString((Object[])object));
        } else if (object instanceof Map) {
            out.append(InvokerHelper.toMapString((Map)object));
        } else if (object instanceof Collection) {
            out.append(InvokerHelper.toListString((Collection)object));
        } else if (object instanceof Writable) {
            Writable writable = (Writable)object;
            StringWriter stringWriter = new StringWriter();
            writable.writeTo(stringWriter);
            out.append(stringWriter.toString());
        } else if (object instanceof InputStream || object instanceof Reader) {
            int i;
            Reader reader = object instanceof InputStream ? new InputStreamReader((InputStream)object) : (Reader)object;
            char[] chars = new char[8192];
            while ((i = reader.read(chars)) != -1) {
                for (int j = 0; j < i; ++j) {
                    out.append(chars[j]);
                }
            }
            reader.close();
        } else {
            out.append(InvokerHelper.toString(object));
        }
    }

    public static Iterator<Object> asIterator(Object o) {
        return (Iterator)InvokerHelper.invokeMethod(o, "iterator", EMPTY_ARGS);
    }

    protected static String format(Object arguments, boolean verbose) {
        return InvokerHelper.format(arguments, verbose, -1);
    }

    public static String format(Object arguments, boolean verbose, int maxSize) {
        if (arguments == null) {
            NullObject nullObject = NullObject.getNullObject();
            return (String)nullObject.getMetaClass().invokeMethod((Object)nullObject, "toString", EMPTY_ARGS);
        }
        if (arguments.getClass().isArray()) {
            if (arguments instanceof char[]) {
                return new String((char[])arguments);
            }
            return InvokerHelper.format(DefaultTypeTransformation.asCollection(arguments), verbose, maxSize);
        }
        if (arguments instanceof Range) {
            Range range2 = (Range)arguments;
            if (verbose) {
                return range2.inspect();
            }
            return range2.toString();
        }
        if (arguments instanceof Collection) {
            return InvokerHelper.formatList((Collection)arguments, verbose, maxSize);
        }
        if (arguments instanceof Map) {
            return InvokerHelper.formatMap((Map)arguments, verbose, maxSize);
        }
        if (arguments instanceof Element) {
            try {
                Method serialize2 = Class.forName("groovy.xml.XmlUtil").getMethod("serialize", Element.class);
                return (String)serialize2.invoke(null, arguments);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if (arguments instanceof String) {
            if (verbose) {
                String arg = ((String)arguments).replaceAll("\\n", "\\\\n");
                arg = arg.replaceAll("\\r", "\\\\r");
                arg = arg.replaceAll("\\t", "\\\\t");
                arg = arg.replaceAll("\\f", "\\\\f");
                arg = arg.replaceAll("'", "\\\\'");
                arg = arg.replaceAll("\\\\", "\\\\");
                return "'" + arg + "'";
            }
            return (String)arguments;
        }
        return arguments.toString();
    }

    private static String formatMap(Map map2, boolean verbose, int maxSize) {
        if (map2.isEmpty()) {
            return "[:]";
        }
        StringBuilder buffer = new StringBuilder("[");
        boolean first = true;
        for (Map.Entry o : map2.entrySet()) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            if (maxSize != -1 && buffer.length() > maxSize) {
                buffer.append("...");
                break;
            }
            Map.Entry entry2 = o;
            buffer.append(InvokerHelper.format(entry2.getKey(), verbose));
            buffer.append(":");
            if (entry2.getValue() == map2) {
                buffer.append("(this Map)");
                continue;
            }
            buffer.append(InvokerHelper.format(entry2.getValue(), verbose, InvokerHelper.sizeLeft(maxSize, buffer)));
        }
        buffer.append("]");
        return buffer.toString();
    }

    private static int sizeLeft(int maxSize, StringBuilder buffer) {
        return maxSize == -1 ? maxSize : Math.max(0, maxSize - buffer.length());
    }

    private static String formatList(Collection collection, boolean verbose, int maxSize) {
        StringBuilder buffer = new StringBuilder("[");
        boolean first = true;
        for (Object item : collection) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            if (maxSize != -1 && buffer.length() > maxSize) {
                buffer.append("...");
                break;
            }
            if (item == collection) {
                buffer.append("(this Collection)");
                continue;
            }
            buffer.append(InvokerHelper.format(item, verbose, InvokerHelper.sizeLeft(maxSize, buffer)));
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static String toTypeString(Object[] arguments) {
        if (arguments == null) {
            return "null";
        }
        StringBuilder argBuf = new StringBuilder();
        for (int i = 0; i < arguments.length; ++i) {
            if (i > 0) {
                argBuf.append(", ");
            }
            argBuf.append(arguments[i] != null ? arguments[i].getClass().getName() : "null");
        }
        return argBuf.toString();
    }

    public static String toMapString(Map arg) {
        return InvokerHelper.toMapString(arg, -1);
    }

    public static String toMapString(Map arg, int maxSize) {
        return InvokerHelper.formatMap(arg, false, maxSize);
    }

    public static String toListString(Collection arg) {
        return InvokerHelper.toListString(arg, -1);
    }

    public static String toListString(Collection arg, int maxSize) {
        return InvokerHelper.formatList(arg, false, maxSize);
    }

    public static String toArrayString(Object[] arguments) {
        if (arguments == null) {
            return "null";
        }
        String sbdry = "[";
        String ebdry = "]";
        StringBuilder argBuf = new StringBuilder(sbdry);
        for (int i = 0; i < arguments.length; ++i) {
            if (i > 0) {
                argBuf.append(", ");
            }
            argBuf.append(InvokerHelper.format(arguments[i], false));
        }
        argBuf.append(ebdry);
        return argBuf.toString();
    }

    public static List createRange(Object from2, Object to2, boolean inclusive2) {
        try {
            return ScriptBytecodeAdapter.createRange(from2, to2, inclusive2);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Object bitwiseNegate(Object value2) {
        if (value2 instanceof Integer) {
            Integer number2 = (Integer)value2;
            return ~number2.intValue();
        }
        if (value2 instanceof Long) {
            Long number3 = (Long)value2;
            return number3 ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (value2 instanceof BigInteger) {
            return ((BigInteger)value2).not();
        }
        if (value2 instanceof String) {
            return StringGroovyMethods.bitwiseNegate(value2.toString());
        }
        if (value2 instanceof GString) {
            return StringGroovyMethods.bitwiseNegate(value2.toString());
        }
        if (value2 instanceof ArrayList) {
            ArrayList<Object> newlist = new ArrayList<Object>();
            Iterator it = ((ArrayList)value2).iterator();
            while (it.hasNext()) {
                newlist.add(InvokerHelper.bitwiseNegate(it.next()));
            }
            return newlist;
        }
        return InvokerHelper.invokeMethod(value2, "bitwiseNegate", EMPTY_ARGS);
    }

    public static MetaClassRegistry getMetaRegistry() {
        return metaRegistry;
    }

    public static MetaClass getMetaClass(Object object) {
        if (object instanceof GroovyObject) {
            return ((GroovyObject)object).getMetaClass();
        }
        return ((MetaClassRegistryImpl)GroovySystem.getMetaClassRegistry()).getMetaClass(object);
    }

    public static MetaClass getMetaClass(Class cls) {
        return metaRegistry.getMetaClass(cls);
    }

    public static Object invokeMethod(Object object, String methodName, Object arguments) {
        if (object == null) {
            object = NullObject.getNullObject();
        }
        if (object instanceof Class) {
            Class theClass = (Class)object;
            MetaClass metaClass = metaRegistry.getMetaClass(theClass);
            return metaClass.invokeStaticMethod(object, methodName, InvokerHelper.asArray(arguments));
        }
        if (!(object instanceof GroovyObject)) {
            return InvokerHelper.invokePojoMethod(object, methodName, arguments);
        }
        return InvokerHelper.invokePogoMethod(object, methodName, arguments);
    }

    static Object invokePojoMethod(Object object, String methodName, Object arguments) {
        MetaClass metaClass = InvokerHelper.getMetaClass(object);
        return metaClass.invokeMethod(object, methodName, InvokerHelper.asArray(arguments));
    }

    static Object invokePogoMethod(Object object, String methodName, Object arguments) {
        GroovyObject groovy = (GroovyObject)object;
        boolean intercepting = groovy instanceof GroovyInterceptable;
        try {
            if (intercepting) {
                return groovy.invokeMethod(methodName, InvokerHelper.asUnwrappedArray(arguments));
            }
            return groovy.getMetaClass().invokeMethod(object, methodName, InvokerHelper.asArray(arguments));
        }
        catch (MissingMethodException e) {
            if (e instanceof MissingMethodExecutionFailed) {
                throw (MissingMethodException)e.getCause();
            }
            if (!intercepting && e.getMethod().equals(methodName) && object.getClass() == e.getType()) {
                return groovy.invokeMethod(methodName, InvokerHelper.asUnwrappedArray(arguments));
            }
            throw e;
        }
    }

    public static Object invokeSuperMethod(Object object, String methodName, Object arguments) {
        if (object == null) {
            throw new NullPointerException("Cannot invoke method " + methodName + "() on null object");
        }
        Class<?> theClass = object.getClass();
        MetaClass metaClass = metaRegistry.getMetaClass(theClass.getSuperclass());
        return metaClass.invokeMethod(object, methodName, InvokerHelper.asArray(arguments));
    }

    public static Object invokeStaticMethod(Class type, String method, Object arguments) {
        MetaClass metaClass = metaRegistry.getMetaClass(type);
        return metaClass.invokeStaticMethod(type, method, InvokerHelper.asArray(arguments));
    }

    public static Object invokeConstructorOf(Class type, Object arguments) {
        MetaClass metaClass = metaRegistry.getMetaClass(type);
        return metaClass.invokeConstructor(InvokerHelper.asArray(arguments));
    }

    public static Object[] asArray(Object arguments) {
        if (arguments == null) {
            return EMPTY_ARGUMENTS;
        }
        if (arguments instanceof Object[]) {
            return (Object[])arguments;
        }
        return new Object[]{arguments};
    }

    public static Object[] asUnwrappedArray(Object arguments) {
        Object[] args = InvokerHelper.asArray(arguments);
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof PojoWrapper)) continue;
            args[i] = ((PojoWrapper)args[i]).unwrap();
        }
        return args;
    }
}

