/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control.customizers.builder;

import groovy.lang.Closure;
import groovy.util.AbstractFactory;
import groovy.util.FactoryBuilderSupport;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.SourceAwareCustomizer;
import org.codehaus.groovy.control.customizers.builder.PostCompletionFactory;

public class SourceAwareCustomizerFactory
extends AbstractFactory
implements PostCompletionFactory {
    public Object newInstance(FactoryBuilderSupport builder, Object name, Object value2, Map attributes) throws InstantiationException, IllegalAccessException {
        SourceOptions data2 = new SourceOptions();
        if (value2 instanceof CompilationCustomizer) {
            data2.delegate = (CompilationCustomizer)value2;
        }
        return data2;
    }

    public void setChild(FactoryBuilderSupport builder, Object parent, Object child) {
        if (child instanceof CompilationCustomizer && parent instanceof SourceOptions) {
            ((SourceOptions)parent).delegate = (CompilationCustomizer)child;
        }
    }

    public Object postCompleteNode(FactoryBuilderSupport factory, Object parent, Object node) {
        SourceOptions data2 = (SourceOptions)node;
        SourceAwareCustomizer sourceAwareCustomizer = new SourceAwareCustomizer(data2.delegate);
        if (data2.extensionValidator != null && (data2.extension != null || data2.extensions != null)) {
            throw new RuntimeException("You must choose between an extension name validator or an explicit extension name");
        }
        if (data2.basenameValidator != null && (data2.basename != null || data2.basenames != null)) {
            throw new RuntimeException("You must choose between an base name validator or an explicit base name");
        }
        this.addExtensionValidator(sourceAwareCustomizer, data2);
        this.addBasenameValidator(sourceAwareCustomizer, data2);
        if (data2.unitValidator != null) {
            sourceAwareCustomizer.setSourceUnitValidator(data2.unitValidator);
        }
        return sourceAwareCustomizer;
    }

    private void addExtensionValidator(SourceAwareCustomizer sourceAwareCustomizer, SourceOptions data2) {
        Closure<Boolean> extensionValidator;
        LinkedList<String> extensions;
        LinkedList<String> linkedList = extensions = data2.extensions != null ? data2.extensions : new LinkedList<String>();
        if (data2.extension != null) {
            extensions.add(data2.extension);
        }
        if ((extensionValidator = data2.extensionValidator) == null && !extensions.isEmpty()) {
            extensionValidator = new Closure<Boolean>((Object)sourceAwareCustomizer){

                @Override
                public Boolean call(Object arguments) {
                    return extensions.contains(arguments);
                }
            };
        }
        sourceAwareCustomizer.setExtensionValidator(extensionValidator);
    }

    private void addBasenameValidator(SourceAwareCustomizer sourceAwareCustomizer, SourceOptions data2) {
        Closure<Boolean> basenameValidator;
        LinkedList<String> basenames;
        LinkedList<String> linkedList = basenames = data2.basenames != null ? data2.basenames : new LinkedList<String>();
        if (data2.basename != null) {
            basenames.add(data2.basename);
        }
        if ((basenameValidator = data2.basenameValidator) == null && !basenames.isEmpty()) {
            basenameValidator = new Closure<Boolean>((Object)sourceAwareCustomizer){

                @Override
                public Boolean call(Object arguments) {
                    return basenames.contains(arguments);
                }
            };
        }
        sourceAwareCustomizer.setBaseNameValidator(basenameValidator);
    }

    public static class SourceOptions {
        public CompilationCustomizer delegate;
        public Closure<Boolean> extensionValidator;
        public Closure<Boolean> unitValidator;
        public Closure<Boolean> basenameValidator;
        public String extension;
        public String basename;
        public List<String> extensions;
        public List<String> basenames;
    }
}

