/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.Parser;

public class GroovyPosixParser
extends Parser {
    private List tokens = new ArrayList();
    private boolean eatTheRest;
    private Option currentOption;
    private Options options;

    private void init() {
        this.eatTheRest = false;
        this.tokens.clear();
    }

    protected String[] flatten(Options options, String[] arguments, boolean stopAtNonOption) {
        this.init();
        this.options = options;
        Iterator<String> iter2 = Arrays.asList(arguments).iterator();
        while (iter2.hasNext()) {
            String token2 = iter2.next();
            if (token2.startsWith("--")) {
                String opt2;
                int pos = token2.indexOf(61);
                String string2 = opt2 = pos == -1 ? token2 : token2.substring(0, pos);
                if (!options.hasOption(opt2)) {
                    this.processNonOptionToken(token2, stopAtNonOption);
                } else {
                    this.tokens.add(opt2);
                    if (pos != -1) {
                        this.tokens.add(token2.substring(pos + 1));
                    } else {
                        this.currentOption = options.getOption(opt2);
                    }
                }
            } else if ("-".equals(token2)) {
                this.tokens.add(token2);
            } else if (token2.startsWith("-")) {
                if (token2.length() == 2 || options.hasOption(token2)) {
                    this.processOptionToken(token2, stopAtNonOption);
                } else {
                    this.burstToken(token2, stopAtNonOption);
                }
            } else {
                this.processNonOptionToken(token2, stopAtNonOption);
            }
            this.gobble(iter2);
        }
        return this.tokens.toArray(new String[this.tokens.size()]);
    }

    private void gobble(Iterator iter2) {
        if (this.eatTheRest) {
            while (iter2.hasNext()) {
                this.tokens.add(iter2.next());
            }
        }
    }

    private void processNonOptionToken(String value2, boolean stopAtNonOption) {
        if (stopAtNonOption && (this.currentOption == null || !this.currentOption.hasArg())) {
            this.eatTheRest = true;
            this.tokens.add("--");
        }
        this.tokens.add(value2);
        this.currentOption = null;
    }

    private void processOptionToken(String token2, boolean stopAtNonOption) {
        if (stopAtNonOption && !this.options.hasOption(token2)) {
            this.eatTheRest = true;
        }
        this.currentOption = this.options.hasOption(token2) ? this.options.getOption(token2) : null;
        this.tokens.add(token2);
    }

    protected void burstToken(String token2, boolean stopAtNonOption) {
        for (int i = 1; i < token2.length(); ++i) {
            String ch = String.valueOf(token2.charAt(i));
            if (this.options.hasOption(ch)) {
                this.tokens.add("-" + ch);
                this.currentOption = this.options.getOption(ch);
                if (!this.currentOption.hasArg() || token2.length() == i + 1) continue;
                this.tokens.add(token2.substring(i + 1));
                break;
            }
            if (stopAtNonOption) {
                this.processNonOptionToken(token2.substring(i), true);
                break;
            }
            this.tokens.add(token2);
            break;
        }
    }
}

