/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen.asm.sc;

import groovyjarjarasm.asm.Label;
import groovyjarjarasm.asm.MethodVisitor;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.classgen.asm.BytecodeVariable;
import org.codehaus.groovy.classgen.asm.CompileStack;
import org.codehaus.groovy.classgen.asm.OperandStack;
import org.codehaus.groovy.classgen.asm.StatementWriter;
import org.codehaus.groovy.classgen.asm.TypeChooser;
import org.codehaus.groovy.classgen.asm.sc.StaticTypesWriterController;

public class StaticTypesStatementWriter
extends StatementWriter {
    private static final ClassNode ITERABLE_CLASSNODE = ClassHelper.make(Iterable.class);
    private StaticTypesWriterController controller;

    public StaticTypesStatementWriter(StaticTypesWriterController controller) {
        super(controller);
        this.controller = controller;
    }

    public void writeBlockStatement(BlockStatement statement) {
        this.controller.switchToFastPath();
        super.writeBlockStatement(statement);
        this.controller.switchToSlowPath();
    }

    protected void writeForInLoop(ForStatement loop2) {
        this.controller.getAcg().onLineNumber(loop2, "visitForLoop");
        this.writeStatementLabel(loop2);
        CompileStack compileStack = this.controller.getCompileStack();
        MethodVisitor mv = this.controller.getMethodVisitor();
        OperandStack operandStack = this.controller.getOperandStack();
        compileStack.pushLoop(loop2.getVariableScope(), loop2.getStatementLabel());
        BytecodeVariable variable = compileStack.defineVariable(loop2.getVariable(), false);
        TypeChooser typeChooser = this.controller.getTypeChooser();
        Expression collectionExpression = loop2.getCollectionExpression();
        ClassNode collectionType = typeChooser.resolveType(collectionExpression, this.controller.getClassNode());
        if (collectionType.implementsInterface(ITERABLE_CLASSNODE)) {
            MethodCallExpression iterator2 = new MethodCallExpression(collectionExpression, "iterator", (Expression)new ArgumentListExpression());
            iterator2.setMethodTarget(collectionType.getMethod("iterator", Parameter.EMPTY_ARRAY));
            iterator2.setImplicitThis(false);
            iterator2.visit(this.controller.getAcg());
        } else {
            collectionExpression.visit(this.controller.getAcg());
            mv.visitMethodInsn(184, "org/codehaus/groovy/runtime/DefaultGroovyMethods", "iterator", "(Ljava/lang/Object;)Ljava/util/Iterator;");
        }
        int iteratorIdx = compileStack.defineTemporaryVariable("iterator", ClassHelper.Iterator_TYPE, true);
        Label continueLabel = compileStack.getContinueLabel();
        Label breakLabel = compileStack.getBreakLabel();
        mv.visitLabel(continueLabel);
        mv.visitVarInsn(25, iteratorIdx);
        this.writeIteratorHasNext(mv);
        mv.visitJumpInsn(153, breakLabel);
        mv.visitVarInsn(25, iteratorIdx);
        this.writeIteratorNext(mv);
        operandStack.push(ClassHelper.OBJECT_TYPE);
        operandStack.storeVar(variable);
        loop2.getLoopBlock().visit(this.controller.getAcg());
        mv.visitJumpInsn(167, continueLabel);
        mv.visitLabel(breakLabel);
        compileStack.pop();
    }
}

