/*
 * Decompiled with CFR 0.152.
 */
package org.cliffc.high_scale_lib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.cliffc.high_scale_lib.Counter;
import org.cliffc.high_scale_lib.IntIterator;
import org.cliffc.high_scale_lib.UtilUnsafe;
import sun.misc.Unsafe;

public class NonBlockingSetInt
extends AbstractSet<Integer>
implements Serializable {
    private static final long serialVersionUID = 1234123412341234123L;
    private static final Unsafe _unsafe = UtilUnsafe.getUnsafe();
    private static final long _nbsi_offset;
    private transient NBSI _nbsi;

    private final boolean CAS_nbsi(NBSI old, NBSI nnn) {
        return _unsafe.compareAndSwapObject(this, _nbsi_offset, old, nnn);
    }

    public NonBlockingSetInt() {
        this._nbsi = new NBSI(63, new Counter(), this);
    }

    private NonBlockingSetInt(NonBlockingSetInt a, NonBlockingSetInt b) {
        this._nbsi = new NBSI(a._nbsi, b._nbsi, new Counter(), this);
    }

    @Override
    public boolean add(Integer i) {
        return this.add((int)i);
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof Integer ? this.contains((Integer)o) : false;
    }

    @Override
    public boolean remove(Object o) {
        return o instanceof Integer ? this.remove((Integer)o) : false;
    }

    @Override
    public boolean add(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("" + i);
        }
        return this._nbsi.add(i);
    }

    public boolean contains(int i) {
        return i < 0 ? false : this._nbsi.contains(i);
    }

    public boolean remove(int i) {
        return i < 0 ? false : this._nbsi.remove(i);
    }

    @Override
    public int size() {
        return this._nbsi.size();
    }

    @Override
    public void clear() {
        NBSI cleared = new NBSI(63, new Counter(), this);
        while (!this.CAS_nbsi(this._nbsi, cleared)) {
        }
    }

    public int sizeInBytes() {
        return this._nbsi.sizeInBytes();
    }

    public NonBlockingSetInt intersect(NonBlockingSetInt op) {
        NonBlockingSetInt res = new NonBlockingSetInt(this, op);
        res._nbsi.intersect(res._nbsi, this._nbsi, op._nbsi);
        return res;
    }

    public NonBlockingSetInt union(NonBlockingSetInt op) {
        NonBlockingSetInt res = new NonBlockingSetInt(this, op);
        res._nbsi.union(res._nbsi, this._nbsi, op._nbsi);
        return res;
    }

    public void print() {
        this._nbsi.print(0);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new iter();
    }

    public IntIterator intIterator() {
        return new NBSIIntIterator();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        NBSI nbsi = this._nbsi;
        int len = this._nbsi._bits.length << 6;
        s.writeInt(len);
        for (int i = 0; i < len; ++i) {
            s.writeBoolean(this._nbsi.contains(i));
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int len = s.readInt();
        this._nbsi = new NBSI(len, new Counter(), this);
        for (int i = 0; i < len; ++i) {
            if (!s.readBoolean()) continue;
            this._nbsi.add(i);
        }
    }

    static {
        Field f2 = null;
        try {
            f2 = NonBlockingSetInt.class.getDeclaredField("_nbsi");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        _nbsi_offset = _unsafe.objectFieldOffset(f2);
    }

    private static final class NBSI {
        private final transient NonBlockingSetInt _non_blocking_set_int;
        private final transient Counter _size;
        private final long[] _bits;
        private static final int _Lbase = NonBlockingSetInt.access$600().arrayBaseOffset(long[].class);
        private static final int _Lscale = NonBlockingSetInt.access$600().arrayIndexScale(long[].class);
        private NBSI _new;
        private static final long _new_offset;
        private final transient AtomicInteger _copyIdx;
        private final transient AtomicInteger _copyDone;
        private final transient int _sum_bits_length;
        private final NBSI _nbsi64;

        private static long rawIndex(long[] ary, int idx) {
            assert (idx >= 0 && idx < ary.length);
            return _Lbase + idx * _Lscale;
        }

        private final boolean CAS(int idx, long old, long nnn) {
            return _unsafe.compareAndSwapLong(this._bits, NBSI.rawIndex(this._bits, idx), old, nnn);
        }

        private final boolean CAS_new(NBSI nnn) {
            return _unsafe.compareAndSwapObject(this, _new_offset, null, nnn);
        }

        private static final long mask(int i) {
            return 1L << (i & 0x3F);
        }

        private NBSI(int max_elem, Counter ctr, NonBlockingSetInt nonb) {
            this._non_blocking_set_int = nonb;
            this._size = ctr;
            this._copyIdx = ctr == null ? null : new AtomicInteger();
            this._copyDone = ctr == null ? null : new AtomicInteger();
            this._bits = new long[(int)((long)max_elem + 63L >>> 6)];
            this._nbsi64 = max_elem + 1 >>> 6 == 0 ? null : new NBSI(max_elem + 1 >>> 6, null, null);
            this._sum_bits_length = this._bits.length + (this._nbsi64 == null ? 0 : this._nbsi64._sum_bits_length);
        }

        private NBSI(NBSI a, NBSI b, Counter ctr, NonBlockingSetInt nonb) {
            this._non_blocking_set_int = nonb;
            this._size = ctr;
            this._copyIdx = ctr == null ? null : new AtomicInteger();
            AtomicInteger atomicInteger = this._copyDone = ctr == null ? null : new AtomicInteger();
            if (!NBSI.has_bits(a) && !NBSI.has_bits(b)) {
                this._bits = null;
                this._nbsi64 = null;
                this._sum_bits_length = 0;
                return;
            }
            if (!NBSI.has_bits(a)) {
                this._bits = new long[b._bits.length];
                this._nbsi64 = new NBSI(null, b._nbsi64, null, null);
            } else if (!NBSI.has_bits(b)) {
                this._bits = new long[a._bits.length];
                this._nbsi64 = new NBSI(null, a._nbsi64, null, null);
            } else {
                int bit_length = a._bits.length > b._bits.length ? a._bits.length : b._bits.length;
                this._bits = new long[bit_length];
                this._nbsi64 = new NBSI(a._nbsi64, b._nbsi64, null, null);
            }
            this._sum_bits_length = this._bits.length + this._nbsi64._sum_bits_length;
        }

        private static boolean has_bits(NBSI n) {
            return n != null && n._bits != null;
        }

        public boolean add(int i) {
            long old;
            if (i >> 6 >= this._bits.length) {
                return this.install_larger_new_bits(i).help_copy().add(i);
            }
            NBSI nbsi = this;
            int j = i;
            while ((j & 0x3F) == 63) {
                nbsi = nbsi._nbsi64;
                j >>= 6;
            }
            long mask = NBSI.mask(j);
            do {
                if ((old = nbsi._bits[j >> 6]) < 0L) {
                    return this.help_copy_impl(i).help_copy().add(i);
                }
                if ((old & mask) == 0L) continue;
                return false;
            } while (!nbsi.CAS(j >> 6, old, old | mask));
            this._size.add(1L);
            return true;
        }

        public boolean remove(int i) {
            long old;
            if (i >> 6 >= this._bits.length) {
                return this._new == null ? false : this.help_copy().remove(i);
            }
            NBSI nbsi = this;
            int j = i;
            while ((j & 0x3F) == 63) {
                nbsi = nbsi._nbsi64;
                j >>= 6;
            }
            long mask = NBSI.mask(j);
            do {
                if ((old = nbsi._bits[j >> 6]) < 0L) {
                    return this.help_copy_impl(i).help_copy().remove(i);
                }
                if ((old & mask) != 0L) continue;
                return false;
            } while (!nbsi.CAS(j >> 6, old, old & (mask ^ 0xFFFFFFFFFFFFFFFFL)));
            this._size.add(-1L);
            return true;
        }

        public boolean contains(int i) {
            if (i >> 6 >= this._bits.length) {
                return this._new == null ? false : this.help_copy().contains(i);
            }
            NBSI nbsi = this;
            int j = i;
            while ((j & 0x3F) == 63) {
                nbsi = nbsi._nbsi64;
                j >>= 6;
            }
            long mask = NBSI.mask(j);
            long old = nbsi._bits[j >> 6];
            if (old < 0L) {
                return this.help_copy_impl(i).help_copy().contains(i);
            }
            return (old & mask) != 0L;
        }

        public boolean intersect(NBSI dest, NBSI a, NBSI b) {
            if (!NBSI.has_bits(a) || !NBSI.has_bits(b)) {
                return true;
            }
            for (int i = 0; i < dest._bits.length; ++i) {
                long left = a.safe_read_word(i, 0L);
                long right = b.safe_read_word(i, 0L);
                dest._bits[i] = left & right & Long.MAX_VALUE;
            }
            return this.intersect(dest._nbsi64, a._nbsi64, b._nbsi64);
        }

        public boolean union(NBSI dest, NBSI a, NBSI b) {
            if (!NBSI.has_bits(a) && !NBSI.has_bits(b)) {
                return true;
            }
            if (NBSI.has_bits(a) || NBSI.has_bits(b)) {
                for (int i = 0; i < dest._bits.length; ++i) {
                    long left = a.safe_read_word(i, 0L);
                    long right = b.safe_read_word(i, 0L);
                    dest._bits[i] = (left | right) & Long.MAX_VALUE;
                }
            }
            return this.union(dest._nbsi64, a._nbsi64, b._nbsi64);
        }

        private long safe_read_word(int i, long default_word) {
            if (i >= this._bits.length) {
                return default_word;
            }
            long word = this._bits[i];
            if (word < 0L) {
                word = this.help_copy_impl((int)i).help_copy()._bits[i];
            }
            return word;
        }

        public int sizeInBytes() {
            return this._bits.length;
        }

        public int size() {
            return (int)this._size.get();
        }

        private NBSI install_larger_new_bits(int i) {
            if (this._new == null) {
                int sz = this._bits.length << 6 << 1;
                this.CAS_new(new NBSI(sz, this._size, this._non_blocking_set_int));
            }
            return this;
        }

        private NBSI help_copy() {
            NBSI top_nbsi = this._non_blocking_set_int._nbsi;
            int HELP = 8;
            int idx = top_nbsi._copyIdx.getAndAdd(512);
            for (int i = 0; i < 8; ++i) {
                int j = idx + i * 64;
                top_nbsi.help_copy_impl(j %= top_nbsi._bits.length << 6);
                top_nbsi.help_copy_impl(j + 63);
            }
            if (top_nbsi._copyDone.get() != top_nbsi._sum_bits_length || this._non_blocking_set_int.CAS_nbsi(top_nbsi, top_nbsi._new)) {
                // empty if block
            }
            return this._new;
        }

        private NBSI help_copy_impl(int i) {
            NBSI old = this;
            NBSI nnn = this._new;
            if (nnn == null) {
                return this;
            }
            int j = i;
            while ((j & 0x3F) == 63) {
                old = old._nbsi64;
                nnn = nnn._nbsi64;
                j >>= 6;
            }
            long bits2 = old._bits[j >> 6];
            while (bits2 >= 0L) {
                long oldbits = bits2;
                if (old.CAS(j >> 6, oldbits, bits2 |= NBSI.mask(63))) {
                    if (oldbits != 0L) break;
                    this._copyDone.addAndGet(1);
                    break;
                }
                bits2 = old._bits[j >> 6];
            }
            if (bits2 != NBSI.mask(63)) {
                long new_bits = nnn._bits[j >> 6];
                if (new_bits == 0L) {
                    new_bits = bits2 & (NBSI.mask(63) ^ 0xFFFFFFFFFFFFFFFFL);
                    if (!nnn.CAS(j >> 6, 0L, new_bits)) {
                        new_bits = nnn._bits[j >> 6];
                    }
                    assert (new_bits != 0L);
                }
                if (old.CAS(j >> 6, bits2, NBSI.mask(63))) {
                    this._copyDone.addAndGet(1);
                }
            }
            return this;
        }

        private void print(int d, String msg) {
            for (int i = 0; i < d; ++i) {
                System.out.print("  ");
            }
            System.out.println(msg);
        }

        private void print(int d) {
            StringBuffer buf = new StringBuffer();
            buf.append("NBSI - _bits.len=");
            NBSI x2 = this;
            while (x2 != null) {
                buf.append(" " + x2._bits.length);
                x2 = x2._nbsi64;
            }
            this.print(d, buf.toString());
            x2 = this;
            while (x2 != null) {
                for (int i = 0; i < x2._bits.length; ++i) {
                    System.out.print(Long.toHexString(x2._bits[i]) + " ");
                }
                x2 = x2._nbsi64;
                System.out.println();
            }
            if (this._copyIdx.get() != 0 || this._copyDone.get() != 0) {
                this.print(d, "_copyIdx=" + this._copyIdx.get() + " _copyDone=" + this._copyDone.get() + " _words_to_cpy=" + this._sum_bits_length);
            }
            if (this._new != null) {
                this.print(d, "__has_new - ");
                this._new.print(d + 1);
            }
        }

        static {
            Field f2 = null;
            try {
                f2 = NBSI.class.getDeclaredField("_new");
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            _new_offset = _unsafe.objectFieldOffset(f2);
        }
    }

    private class iter
    implements Iterator<Integer> {
        NBSIIntIterator intIterator;

        iter() {
            this.intIterator = new NBSIIntIterator();
        }

        @Override
        public boolean hasNext() {
            return this.intIterator.hasNext();
        }

        @Override
        public Integer next() {
            return this.intIterator.next();
        }

        @Override
        public void remove() {
            this.intIterator.remove();
        }
    }

    private class NBSIIntIterator
    implements IntIterator {
        NBSI nbsi;
        int index = -1;
        int prev = -1;

        NBSIIntIterator() {
            this.nbsi = NonBlockingSetInt.this._nbsi;
            this.advance();
        }

        private void advance() {
            do {
                ++this.index;
                while (this.index >> 6 >= this.nbsi._bits.length) {
                    if (this.nbsi._new == null) {
                        this.index = -2;
                        return;
                    }
                    this.nbsi = this.nbsi._new;
                }
            } while (!this.nbsi.contains(this.index));
        }

        @Override
        public int next() {
            if (this.index == -1) {
                throw new NoSuchElementException();
            }
            this.prev = this.index;
            this.advance();
            return this.prev;
        }

        @Override
        public boolean hasNext() {
            return this.index != -2;
        }

        public void remove() {
            if (this.prev == -1) {
                throw new IllegalStateException();
            }
            this.nbsi.remove(this.prev);
            this.prev = -1;
        }
    }
}

