/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.util.Arrays;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.AbstractAppendingLongBuffer;
import org.apache.lucene.util.packed.PackedInts;

public final class MonotonicAppendingLongBuffer
extends AbstractAppendingLongBuffer {
    float[] averages;
    long[] minValues;

    static long zigZagDecode(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    static long zigZagEncode(long n) {
        return n >> 63 ^ n << 1;
    }

    public MonotonicAppendingLongBuffer(int initialPageCount, int pageSize, float acceptableOverheadRatio) {
        super(initialPageCount, pageSize, acceptableOverheadRatio);
        this.averages = new float[this.values.length];
        this.minValues = new long[this.values.length];
    }

    public MonotonicAppendingLongBuffer() {
        this(16, 1024, 0.2f);
    }

    public MonotonicAppendingLongBuffer(float acceptableOverheadRatio) {
        this(16, 1024, acceptableOverheadRatio);
    }

    @Override
    long get(int block, int element) {
        if (block == this.valuesOff) {
            return this.pending[element];
        }
        long base = this.minValues[block] + (long)(this.averages[block] * (float)element);
        if (this.values[block] == null) {
            return base;
        }
        return base + MonotonicAppendingLongBuffer.zigZagDecode(this.values[block].get(element));
    }

    @Override
    int get(int block, int element, long[] arr, int off, int len) {
        if (block == this.valuesOff) {
            int sysCopyToRead = Math.min(len, this.pendingOff - element);
            System.arraycopy(this.pending, element, arr, off, sysCopyToRead);
            return sysCopyToRead;
        }
        if (this.values[block] == null) {
            int toFill = Math.min(len, this.pending.length - element);
            int r = 0;
            while (r < toFill) {
                arr[off] = this.minValues[block] + (long)(this.averages[block] * (float)element);
                ++r;
                ++off;
                ++element;
            }
            return toFill;
        }
        int read2 = this.values[block].get(element, arr, off, len);
        int r = 0;
        while (r < read2) {
            arr[off] = this.minValues[block] + (long)(this.averages[block] * (float)element) + MonotonicAppendingLongBuffer.zigZagDecode(arr[off]);
            ++r;
            ++off;
            ++element;
        }
        return read2;
    }

    @Override
    void grow(int newBlockCount) {
        super.grow(newBlockCount);
        this.averages = Arrays.copyOf(this.averages, newBlockCount);
        this.minValues = Arrays.copyOf(this.minValues, newBlockCount);
    }

    @Override
    void packPendingValues() {
        assert (this.pendingOff > 0);
        this.minValues[this.valuesOff] = this.pending[0];
        this.averages[this.valuesOff] = this.pendingOff == 1 ? 0.0f : (float)(this.pending[this.pendingOff - 1] - this.pending[0]) / (float)(this.pendingOff - 1);
        for (int i = 0; i < this.pendingOff; ++i) {
            this.pending[i] = MonotonicAppendingLongBuffer.zigZagEncode(this.pending[i] - this.minValues[this.valuesOff] - (long)(this.averages[this.valuesOff] * (float)i));
        }
        long maxDelta = 0L;
        for (int i = 0; i < this.pendingOff; ++i) {
            if (this.pending[i] < 0L) {
                maxDelta = -1L;
                break;
            }
            maxDelta = Math.max(maxDelta, this.pending[i]);
        }
        if (maxDelta == 0L) {
            this.values[this.valuesOff] = new PackedInts.NullReader(this.pendingOff);
        } else {
            int bitsRequired = maxDelta < 0L ? 64 : PackedInts.bitsRequired(maxDelta);
            PackedInts.Mutable mutable = PackedInts.getMutable(this.pendingOff, bitsRequired, this.acceptableOverheadRatio);
            for (int i = 0; i < this.pendingOff; i += mutable.set(i, this.pending, i, this.pendingOff - i)) {
            }
            this.values[this.valuesOff] = mutable;
        }
    }

    @Override
    long baseRamBytesUsed() {
        return super.baseRamBytesUsed() + (long)(2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
    }

    @Override
    public long ramBytesUsed() {
        return super.ramBytesUsed() + RamUsageEstimator.sizeOf(this.averages) + RamUsageEstimator.sizeOf(this.minValues);
    }
}

