/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.util.Arrays;
import org.apache.lucene.util.ToStringUtils;
import org.apache.lucene.util.packed.EliasFanoDecoder;

public class EliasFanoEncoder {
    final long numValues;
    private final long upperBound;
    final int numLowBits;
    final long lowerBitsMask;
    final long[] upperLongs;
    final long[] lowerLongs;
    private static final int LOG2_LONG_SIZE = Long.numberOfTrailingZeros(64L);
    long numEncoded = 0L;
    long lastEncoded = 0L;
    public static final long DEFAULT_INDEX_INTERVAL = 256L;
    final long numIndexEntries;
    final long indexInterval;
    final int nIndexEntryBits;
    final long[] upperZeroBitPositionIndex;
    long currentEntryIndex;

    public EliasFanoEncoder(long numValues, long upperBound, long indexInterval) {
        long lowBitsFac;
        if (numValues < 0L) {
            throw new IllegalArgumentException("numValues should not be negative: " + numValues);
        }
        this.numValues = numValues;
        if (numValues > 0L && upperBound < 0L) {
            throw new IllegalArgumentException("upperBound should not be negative: " + upperBound + " when numValues > 0");
        }
        this.upperBound = numValues > 0L ? upperBound : -1L;
        int nLowBits = 0;
        if (this.numValues > 0L && (lowBitsFac = this.upperBound / this.numValues) > 0L) {
            nLowBits = 63 - Long.numberOfLeadingZeros(lowBitsFac);
        }
        this.numLowBits = nLowBits;
        this.lowerBitsMask = Long.MAX_VALUE >>> 63 - this.numLowBits;
        long numLongsForLowBits = EliasFanoEncoder.numLongsForBits(numValues * (long)this.numLowBits);
        if (numLongsForLowBits > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("numLongsForLowBits too large to index a long array: " + numLongsForLowBits);
        }
        this.lowerLongs = new long[(int)numLongsForLowBits];
        long numHighBitsClear = (this.upperBound > 0L ? this.upperBound : 0L) >>> this.numLowBits;
        assert (numHighBitsClear <= 2L * this.numValues);
        long numHighBitsSet = this.numValues;
        long numLongsForHighBits = EliasFanoEncoder.numLongsForBits(numHighBitsClear + numHighBitsSet);
        if (numLongsForHighBits > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("numLongsForHighBits too large to index a long array: " + numLongsForHighBits);
        }
        this.upperLongs = new long[(int)numLongsForHighBits];
        if (indexInterval < 2L) {
            throw new IllegalArgumentException("indexInterval should at least 2: " + indexInterval);
        }
        long maxHighValue = upperBound >>> this.numLowBits;
        long nIndexEntries = maxHighValue / indexInterval;
        this.numIndexEntries = nIndexEntries >= 0L ? nIndexEntries : 0L;
        long maxIndexEntry = maxHighValue + numValues - 1L;
        this.nIndexEntryBits = maxIndexEntry <= 0L ? 0 : 64 - Long.numberOfLeadingZeros(maxIndexEntry - 1L);
        long numLongsForIndexBits = EliasFanoEncoder.numLongsForBits(this.numIndexEntries * (long)this.nIndexEntryBits);
        if (numLongsForIndexBits > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("numLongsForIndexBits too large to index a long array: " + numLongsForIndexBits);
        }
        this.upperZeroBitPositionIndex = new long[(int)numLongsForIndexBits];
        this.currentEntryIndex = 0L;
        this.indexInterval = indexInterval;
    }

    public EliasFanoEncoder(long numValues, long upperBound) {
        this(numValues, upperBound, 256L);
    }

    private static long numLongsForBits(long numBits) {
        assert (numBits >= 0L) : numBits;
        return numBits + 63L >>> LOG2_LONG_SIZE;
    }

    public void encodeNext(long x2) {
        if (this.numEncoded >= this.numValues) {
            throw new IllegalStateException("encodeNext called more than " + this.numValues + " times.");
        }
        if (this.lastEncoded > x2) {
            throw new IllegalArgumentException(x2 + " smaller than previous " + this.lastEncoded);
        }
        if (x2 > this.upperBound) {
            throw new IllegalArgumentException(x2 + " larger than upperBound " + this.upperBound);
        }
        long highValue = x2 >>> this.numLowBits;
        this.encodeUpperBits(highValue);
        this.encodeLowerBits(x2 & this.lowerBitsMask);
        this.lastEncoded = x2;
        for (long indexValue = (this.currentEntryIndex + 1L) * this.indexInterval; indexValue <= highValue; indexValue += this.indexInterval) {
            long afterZeroBitPosition = indexValue + this.numEncoded;
            EliasFanoEncoder.packValue(afterZeroBitPosition, this.upperZeroBitPositionIndex, this.nIndexEntryBits, this.currentEntryIndex);
            ++this.currentEntryIndex;
        }
        ++this.numEncoded;
    }

    private void encodeUpperBits(long highValue) {
        long nextHighBitNum = this.numEncoded + highValue;
        int n = (int)(nextHighBitNum >>> LOG2_LONG_SIZE);
        this.upperLongs[n] = this.upperLongs[n] | 1L << (int)(nextHighBitNum & 0x3FL);
    }

    private void encodeLowerBits(long lowValue) {
        EliasFanoEncoder.packValue(lowValue, this.lowerLongs, this.numLowBits, this.numEncoded);
    }

    private static void packValue(long value2, long[] longArray, int numBits, long packIndex) {
        if (numBits != 0) {
            long bitPos = (long)numBits * packIndex;
            int index = (int)(bitPos >>> LOG2_LONG_SIZE);
            int bitPosAtIndex = (int)(bitPos & 0x3FL);
            int n = index;
            longArray[n] = longArray[n] | value2 << bitPosAtIndex;
            if (bitPosAtIndex + numBits > 64) {
                longArray[index + 1] = value2 >>> 64 - bitPosAtIndex;
            }
        }
    }

    public static boolean sufficientlySmallerThanBitSet(long numValues, long upperBound) {
        return upperBound > 256L && upperBound / 7L > numValues;
    }

    public EliasFanoDecoder getDecoder() {
        return new EliasFanoDecoder(this);
    }

    public long[] getLowerBits() {
        return this.lowerLongs;
    }

    public long[] getUpperBits() {
        return this.upperLongs;
    }

    public long[] getIndexBits() {
        return this.upperZeroBitPositionIndex;
    }

    public String toString() {
        int i;
        StringBuilder s = new StringBuilder("EliasFanoSequence");
        s.append(" numValues " + this.numValues);
        s.append(" numEncoded " + this.numEncoded);
        s.append(" upperBound " + this.upperBound);
        s.append(" lastEncoded " + this.lastEncoded);
        s.append(" numLowBits " + this.numLowBits);
        s.append("\nupperLongs[" + this.upperLongs.length + "]");
        for (i = 0; i < this.upperLongs.length; ++i) {
            s.append(" " + ToStringUtils.longHex(this.upperLongs[i]));
        }
        s.append("\nlowerLongs[" + this.lowerLongs.length + "]");
        for (i = 0; i < this.lowerLongs.length; ++i) {
            s.append(" " + ToStringUtils.longHex(this.lowerLongs[i]));
        }
        s.append("\nindexInterval: " + this.indexInterval + ", nIndexEntryBits: " + this.nIndexEntryBits);
        s.append("\nupperZeroBitPositionIndex[" + this.upperZeroBitPositionIndex.length + "]");
        for (i = 0; i < this.upperZeroBitPositionIndex.length; ++i) {
            s.append(" " + ToStringUtils.longHex(this.upperZeroBitPositionIndex[i]));
        }
        return s.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof EliasFanoEncoder)) {
            return false;
        }
        EliasFanoEncoder oefs = (EliasFanoEncoder)other;
        return this.numValues == oefs.numValues && this.numEncoded == oefs.numEncoded && this.numLowBits == oefs.numLowBits && this.numIndexEntries == oefs.numIndexEntries && this.indexInterval == oefs.indexInterval && Arrays.equals(this.upperLongs, oefs.upperLongs) && Arrays.equals(this.lowerLongs, oefs.lowerLongs);
    }

    public int hashCode() {
        int h = (int)(31L * (this.numValues + 7L * (this.numEncoded + 5L * ((long)this.numLowBits + 3L * (this.numIndexEntries + 11L * this.indexInterval))))) ^ Arrays.hashCode(this.upperLongs) ^ Arrays.hashCode(this.lowerLongs);
        return h;
    }
}

