/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.packed.AbstractBlockPackedWriter;
import org.apache.lucene.util.packed.PackedInts;

public final class BlockPackedWriter
extends AbstractBlockPackedWriter {
    public BlockPackedWriter(DataOutput out, int blockSize) {
        super(out, blockSize);
    }

    @Override
    protected void flush() throws IOException {
        int bitsRequired;
        assert (this.off > 0);
        long min2 = Long.MAX_VALUE;
        long max2 = Long.MIN_VALUE;
        for (int i = 0; i < this.off; ++i) {
            min2 = Math.min(this.values[i], min2);
            max2 = Math.max(this.values[i], max2);
        }
        long delta = max2 - min2;
        int n = delta < 0L ? 64 : (bitsRequired = delta == 0L ? 0 : PackedInts.bitsRequired(delta));
        if (bitsRequired == 64) {
            min2 = 0L;
        } else if (min2 > 0L) {
            min2 = Math.max(0L, max2 - PackedInts.maxValue(bitsRequired));
        }
        int token2 = bitsRequired << 1 | (min2 == 0L ? 1 : 0);
        this.out.writeByte((byte)token2);
        if (min2 != 0L) {
            BlockPackedWriter.writeVLong(this.out, BlockPackedWriter.zigZagEncode(min2) - 1L);
        }
        if (bitsRequired > 0) {
            if (min2 != 0L) {
                int i = 0;
                while (i < this.off) {
                    int n2 = i++;
                    this.values[n2] = this.values[n2] - min2;
                }
            }
            this.writeValues(bitsRequired);
        }
        this.off = 0;
    }
}

