/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.fst.Outputs;

public final class ListOfOutputs<T>
extends Outputs<Object> {
    private final Outputs<T> outputs;

    public ListOfOutputs(Outputs<T> outputs) {
        this.outputs = outputs;
    }

    @Override
    public Object common(Object output1, Object output2) {
        return this.outputs.common(output1, output2);
    }

    @Override
    public Object subtract(Object object, Object inc) {
        return this.outputs.subtract(object, inc);
    }

    @Override
    public Object add(Object prefix, Object output2) {
        assert (!(prefix instanceof List));
        if (!(output2 instanceof List)) {
            return this.outputs.add(prefix, output2);
        }
        List outputList = (List)output2;
        ArrayList<Object> addedList = new ArrayList<Object>(outputList.size());
        for (Object _output : outputList) {
            addedList.add(this.outputs.add(prefix, _output));
        }
        return addedList;
    }

    @Override
    public void write(Object output2, DataOutput out) throws IOException {
        assert (!(output2 instanceof List));
        this.outputs.write(output2, out);
    }

    @Override
    public void writeFinalOutput(Object output2, DataOutput out) throws IOException {
        if (!(output2 instanceof List)) {
            out.writeVInt(1);
            this.outputs.write(output2, out);
        } else {
            List outputList = (List)output2;
            out.writeVInt(outputList.size());
            for (Object eachOutput : outputList) {
                this.outputs.write(eachOutput, out);
            }
        }
    }

    @Override
    public Object read(DataInput in) throws IOException {
        return this.outputs.read(in);
    }

    @Override
    public Object readFinalOutput(DataInput in) throws IOException {
        int count2 = in.readVInt();
        if (count2 == 1) {
            return this.outputs.read(in);
        }
        ArrayList<T> outputList = new ArrayList<T>(count2);
        for (int i = 0; i < count2; ++i) {
            outputList.add(this.outputs.read(in));
        }
        return outputList;
    }

    @Override
    public Object getNoOutput() {
        return this.outputs.getNoOutput();
    }

    @Override
    public String outputToString(Object output2) {
        if (!(output2 instanceof List)) {
            return this.outputs.outputToString(output2);
        }
        List outputList = (List)output2;
        StringBuilder b = new StringBuilder();
        b.append('[');
        for (int i = 0; i < outputList.size(); ++i) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(this.outputs.outputToString(outputList.get(i)));
        }
        b.append(']');
        return b.toString();
    }

    @Override
    public Object merge(Object first, Object second) {
        ArrayList<Object> outputList = new ArrayList<Object>();
        if (!(first instanceof List)) {
            outputList.add(first);
        } else {
            outputList.addAll((List)first);
        }
        if (!(second instanceof List)) {
            outputList.add(second);
        } else {
            outputList.addAll((List)second);
        }
        return outputList;
    }

    public String toString() {
        return "OneOrMoreOutputs(" + this.outputs + ")";
    }

    public List<T> asList(Object output2) {
        if (!(output2 instanceof List)) {
            ArrayList<Object> result2 = new ArrayList<Object>(1);
            result2.add(output2);
            return result2;
        }
        return (List)output2;
    }
}

