/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.GrowableByteArrayDataOutput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.MonotonicAppendingLongBuffer;
import org.apache.lucene.util.packed.PackedInts;

public final class PForDeltaDocIdSet
extends DocIdSet {
    static final int BLOCK_SIZE = 128;
    static final int MAX_EXCEPTIONS = 24;
    static final PackedInts.Decoder[] DECODERS = new PackedInts.Decoder[32];
    static final int[] ITERATIONS = new int[32];
    static final int[] BYTE_BLOCK_COUNTS = new int[32];
    static final int MAX_BYTE_BLOCK_COUNT;
    static final MonotonicAppendingLongBuffer SINGLE_ZERO_BUFFER;
    static final PForDeltaDocIdSet EMPTY;
    static final int LAST_BLOCK = 32;
    static final int HAS_EXCEPTIONS = 64;
    static final int UNARY = 128;
    final byte[] data;
    final MonotonicAppendingLongBuffer docIDs;
    final MonotonicAppendingLongBuffer offsets;
    final int cardinality;
    final int indexInterval;

    PForDeltaDocIdSet(byte[] data2, int cardinality, int indexInterval, MonotonicAppendingLongBuffer docIDs, MonotonicAppendingLongBuffer offsets) {
        this.data = data2;
        this.cardinality = cardinality;
        this.indexInterval = indexInterval;
        this.docIDs = docIDs;
        this.offsets = offsets;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public DocIdSetIterator iterator() {
        if (this.data == null) {
            return null;
        }
        return new Iterator(this.data, this.cardinality, this.indexInterval, this.docIDs, this.offsets);
    }

    public int cardinality() {
        return this.cardinality;
    }

    public long ramBytesUsed() {
        return RamUsageEstimator.alignObjectSize(3 * RamUsageEstimator.NUM_BYTES_OBJECT_REF) + this.docIDs.ramBytesUsed() + this.offsets.ramBytesUsed();
    }

    static {
        SINGLE_ZERO_BUFFER = new MonotonicAppendingLongBuffer(0, 64, 0.0f);
        EMPTY = new PForDeltaDocIdSet(null, 0, Integer.MAX_VALUE, SINGLE_ZERO_BUFFER, SINGLE_ZERO_BUFFER);
        SINGLE_ZERO_BUFFER.add(0L);
        SINGLE_ZERO_BUFFER.freeze();
        int maxByteBLockCount = 0;
        for (int i = 1; i < ITERATIONS.length; ++i) {
            PForDeltaDocIdSet.DECODERS[i] = PackedInts.getDecoder(PackedInts.Format.PACKED, 1, i);
            assert (128 % DECODERS[i].byteValueCount() == 0);
            PForDeltaDocIdSet.ITERATIONS[i] = 128 / DECODERS[i].byteValueCount();
            PForDeltaDocIdSet.BYTE_BLOCK_COUNTS[i] = ITERATIONS[i] * DECODERS[i].byteBlockCount();
            maxByteBLockCount = Math.max(maxByteBLockCount, DECODERS[i].byteBlockCount());
        }
        MAX_BYTE_BLOCK_COUNT = maxByteBLockCount;
    }

    static class Iterator
    extends DocIdSetIterator {
        final int indexInterval;
        final MonotonicAppendingLongBuffer docIDs;
        final MonotonicAppendingLongBuffer offsets;
        final int cardinality;
        final byte[] data;
        int offset;
        final int[] nextDocs;
        int i;
        final int[] nextExceptions;
        int blockIdx;
        int docID;

        Iterator(byte[] data2, int cardinality, int indexInterval, MonotonicAppendingLongBuffer docIDs, MonotonicAppendingLongBuffer offsets) {
            this.data = data2;
            this.cardinality = cardinality;
            this.indexInterval = indexInterval;
            this.docIDs = docIDs;
            this.offsets = offsets;
            this.offset = 0;
            this.nextDocs = new int[128];
            Arrays.fill(this.nextDocs, -1);
            this.i = 128;
            this.nextExceptions = new int[128];
            this.blockIdx = -1;
            this.docID = -1;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        void pforDecompress(byte token2) {
            int bitsPerValue = token2 & 0x1F;
            if (bitsPerValue == 0) {
                Arrays.fill(this.nextDocs, 0);
            } else {
                DECODERS[bitsPerValue].decode(this.data, this.offset, this.nextDocs, 0, ITERATIONS[bitsPerValue]);
                this.offset += BYTE_BLOCK_COUNTS[bitsPerValue];
            }
            if ((token2 & 0x40) != 0) {
                int numExceptions = this.data[this.offset++];
                byte bitsPerException = this.data[this.offset++];
                int numIterations = (numExceptions + DECODERS[bitsPerException].byteValueCount() - 1) / DECODERS[bitsPerException].byteValueCount();
                DECODERS[bitsPerException].decode(this.data, this.offset, this.nextExceptions, 0, numIterations);
                this.offset = (int)((long)this.offset + PackedInts.Format.PACKED.byteCount(1, numExceptions, bitsPerException));
                for (int i = 0; i < numExceptions; ++i) {
                    byte by2 = this.data[this.offset++];
                    this.nextDocs[by2] = this.nextDocs[by2] | this.nextExceptions[i] << bitsPerValue;
                }
            }
            int previousDoc = this.docID;
            for (int i = 0; i < 128; ++i) {
                int doc;
                previousDoc = this.nextDocs[i] = (doc = previousDoc + 1 + this.nextDocs[i]);
            }
        }

        void unaryDecompress(byte token2) {
            assert ((token2 & 0x40) == 0);
            int docID = this.docID;
            int i = 0;
            while (i < 128) {
                byte b = this.data[this.offset++];
                for (int bitList = BitUtil.bitList(b); bitList != 0; bitList >>>= 4) {
                    this.nextDocs[i] = docID + (bitList & 0xF);
                    ++i;
                }
                docID += 8;
            }
        }

        void decompressBlock() {
            byte token2;
            if (((token2 = this.data[this.offset++]) & 0x80) != 0) {
                this.unaryDecompress(token2);
            } else {
                this.pforDecompress(token2);
            }
            if ((token2 & 0x20) != 0) {
                byte blockSize = this.data[this.offset++];
                Arrays.fill(this.nextDocs, (int)blockSize, 128, Integer.MAX_VALUE);
            }
            ++this.blockIdx;
        }

        void skipBlock() {
            assert (this.i == 128);
            this.decompressBlock();
            this.docID = this.nextDocs[127];
        }

        @Override
        public int nextDoc() {
            if (this.i == 128) {
                this.decompressBlock();
                this.i = 0;
            }
            this.docID = this.nextDocs[this.i++];
            return this.docID;
        }

        int forwardBinarySearch(int target) {
            int indexSize = (int)this.docIDs.size();
            int lo = Math.max(this.blockIdx / this.indexInterval, 0);
            int hi = lo + 1;
            assert (this.blockIdx == -1 || this.docIDs.get(lo) <= (long)this.docID);
            assert ((long)(lo + 1) == this.docIDs.size() || this.docIDs.get(lo + 1) > (long)this.docID);
            while (true) {
                if (hi >= indexSize) {
                    hi = indexSize - 1;
                    break;
                }
                if (this.docIDs.get(hi) >= (long)target) break;
                int newLo = hi;
                hi += hi - lo << 1;
                lo = newLo;
            }
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                int midDocID = (int)this.docIDs.get(mid);
                if (midDocID <= target) {
                    lo = mid + 1;
                    continue;
                }
                hi = mid - 1;
            }
            assert (this.docIDs.get(hi) <= (long)target);
            assert ((long)(hi + 1) == this.docIDs.size() || this.docIDs.get(hi + 1) > (long)target);
            return hi;
        }

        @Override
        public int advance(int target) throws IOException {
            int index;
            int offset;
            assert (target > this.docID);
            if (this.nextDocs[127] < target && (offset = (int)this.offsets.get(index = this.forwardBinarySearch(target))) > this.offset) {
                this.offset = offset;
                this.docID = (int)this.docIDs.get(index) - 1;
                this.blockIdx = index * this.indexInterval - 1;
                while (true) {
                    this.decompressBlock();
                    if (this.nextDocs[127] >= target) break;
                    this.docID = this.nextDocs[127];
                }
                this.i = 0;
            }
            return this.slowAdvance(target);
        }

        @Override
        public long cost() {
            return this.cardinality;
        }
    }

    public static class Builder {
        final GrowableByteArrayDataOutput data;
        final int[] buffer = new int[128];
        final int[] exceptionIndices = new int[128];
        final int[] exceptions = new int[128];
        int bufferSize = 0;
        int previousDoc = -1;
        int cardinality = 0;
        int indexInterval = 2;
        int numBlocks = 0;
        final int[] freqs = new int[32];
        int bitsPerValue;
        int numExceptions;
        int bitsPerException;

        public Builder() {
            this.data = new GrowableByteArrayDataOutput(128);
        }

        public Builder setIndexInterval(int indexInterval) {
            if (indexInterval < 1) {
                throw new IllegalArgumentException("indexInterval must be >= 1");
            }
            this.indexInterval = indexInterval;
            return this;
        }

        public Builder add(int doc) {
            if (doc <= this.previousDoc) {
                throw new IllegalArgumentException("Doc IDs must be provided in order, but previousDoc=" + this.previousDoc + " and doc=" + doc);
            }
            this.buffer[this.bufferSize++] = doc - this.previousDoc - 1;
            if (this.bufferSize == 128) {
                this.encodeBlock();
                this.bufferSize = 0;
            }
            this.previousDoc = doc;
            ++this.cardinality;
            return this;
        }

        public Builder add(DocIdSetIterator it) throws IOException {
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                this.add(doc);
                doc = it.nextDoc();
            }
            return this;
        }

        void computeFreqs() {
            Arrays.fill(this.freqs, 0);
            for (int i = 0; i < this.bufferSize; ++i) {
                int n = 32 - Integer.numberOfLeadingZeros(this.buffer[i]);
                this.freqs[n] = this.freqs[n] + 1;
            }
        }

        int pforBlockSize(int bitsPerValue, int numExceptions, int bitsPerException) {
            PackedInts.Format format2 = PackedInts.Format.PACKED;
            long blockSize = 1L + format2.byteCount(1, 128, bitsPerValue);
            if (numExceptions > 0) {
                blockSize += (long)(2 + numExceptions) + format2.byteCount(1, numExceptions, bitsPerException);
            }
            if (this.bufferSize < 128) {
                ++blockSize;
            }
            return (int)blockSize;
        }

        int unaryBlockSize() {
            int deltaSum = 0;
            for (int i = 0; i < 128; ++i) {
                deltaSum += 1 + this.buffer[i];
            }
            int blockSize = deltaSum + 7 >>> 3;
            ++blockSize;
            if (this.bufferSize < 128) {
                ++blockSize;
            }
            return blockSize;
        }

        int computeOptimalNumberOfBits() {
            this.computeFreqs();
            this.bitsPerValue = 31;
            this.numExceptions = 0;
            while (this.bitsPerValue > 0 && this.freqs[this.bitsPerValue] == 0) {
                --this.bitsPerValue;
            }
            int actualBitsPerValue = this.bitsPerValue;
            int blockSize = this.pforBlockSize(this.bitsPerValue, this.numExceptions, this.bitsPerException);
            int bitsPerValue = this.bitsPerValue - 1;
            for (int numExceptions = this.freqs[this.bitsPerValue]; bitsPerValue >= 0 && numExceptions <= 24; numExceptions += this.freqs[bitsPerValue--]) {
                int newBlockSize = this.pforBlockSize(bitsPerValue, numExceptions, actualBitsPerValue - bitsPerValue);
                if (newBlockSize >= blockSize) continue;
                this.bitsPerValue = bitsPerValue;
                this.numExceptions = numExceptions;
                blockSize = newBlockSize;
            }
            this.bitsPerException = actualBitsPerValue - this.bitsPerValue;
            assert (this.bufferSize < 128 || this.numExceptions < this.bufferSize);
            return blockSize;
        }

        void pforEncode() {
            int numIterations;
            int i;
            if (this.numExceptions > 0) {
                int mask = (1 << this.bitsPerValue) - 1;
                int ex = 0;
                for (i = 0; i < this.bufferSize; ++i) {
                    if (this.buffer[i] <= mask) continue;
                    this.exceptionIndices[ex] = i;
                    this.exceptions[ex++] = this.buffer[i] >>> this.bitsPerValue;
                    int n = i;
                    this.buffer[n] = this.buffer[n] & mask;
                }
                assert (ex == this.numExceptions);
                Arrays.fill(this.exceptions, this.numExceptions, 128, 0);
            }
            if (this.bitsPerValue > 0) {
                PackedInts.Encoder encoder2 = PackedInts.getEncoder(PackedInts.Format.PACKED, 1, this.bitsPerValue);
                numIterations = ITERATIONS[this.bitsPerValue];
                encoder2.encode(this.buffer, 0, this.data.bytes, this.data.length, numIterations);
                this.data.length += encoder2.byteBlockCount() * numIterations;
            }
            if (this.numExceptions > 0) {
                assert (this.bitsPerException > 0);
                this.data.writeByte((byte)this.numExceptions);
                this.data.writeByte((byte)this.bitsPerException);
                PackedInts.Encoder encoder3 = PackedInts.getEncoder(PackedInts.Format.PACKED, 1, this.bitsPerException);
                numIterations = (this.numExceptions + encoder3.byteValueCount() - 1) / encoder3.byteValueCount();
                encoder3.encode(this.exceptions, 0, this.data.bytes, this.data.length, numIterations);
                this.data.length = (int)((long)this.data.length + PackedInts.Format.PACKED.byteCount(1, this.numExceptions, this.bitsPerException));
                for (i = 0; i < this.numExceptions; ++i) {
                    this.data.writeByte((byte)this.exceptionIndices[i]);
                }
            }
        }

        void unaryEncode() {
            int current = 0;
            int doc = -1;
            for (int i = 0; i < 128; ++i) {
                doc += 1 + this.buffer[i];
                while (doc >= 8) {
                    this.data.writeByte((byte)current);
                    current = 0;
                    doc -= 8;
                }
                current |= 1 << doc;
            }
            if (current != 0) {
                this.data.writeByte((byte)current);
            }
        }

        void encodeBlock() {
            int blockSize;
            int originalLength = this.data.length;
            Arrays.fill(this.buffer, this.bufferSize, 128, 0);
            int unaryBlockSize = this.unaryBlockSize();
            int pforBlockSize = this.computeOptimalNumberOfBits();
            if (pforBlockSize <= unaryBlockSize) {
                blockSize = pforBlockSize;
                this.data.bytes = ArrayUtil.grow(this.data.bytes, this.data.length + blockSize + MAX_BYTE_BLOCK_COUNT);
                int token2 = this.bufferSize < 128 ? 32 : 0;
                token2 |= this.bitsPerValue;
                if (this.numExceptions > 0) {
                    token2 |= 0x40;
                }
                this.data.writeByte((byte)token2);
                this.pforEncode();
            } else {
                blockSize = unaryBlockSize;
                int token3 = 0x80 | (this.bufferSize < 128 ? 32 : 0);
                this.data.writeByte((byte)token3);
                this.unaryEncode();
            }
            if (this.bufferSize < 128) {
                this.data.writeByte((byte)this.bufferSize);
            }
            ++this.numBlocks;
            assert (this.data.length - originalLength == blockSize) : this.data.length - originalLength + " <> " + blockSize;
        }

        public PForDeltaDocIdSet build() {
            MonotonicAppendingLongBuffer docIDs;
            MonotonicAppendingLongBuffer offsets;
            assert (this.bufferSize < 128);
            if (this.cardinality == 0) {
                assert (this.previousDoc == -1);
                return EMPTY;
            }
            this.encodeBlock();
            byte[] dataArr = Arrays.copyOf(this.data.bytes, this.data.length + MAX_BYTE_BLOCK_COUNT);
            int indexSize = (this.numBlocks - 1) / this.indexInterval + 1;
            if (indexSize <= 1) {
                docIDs = offsets = SINGLE_ZERO_BUFFER;
            } else {
                int pageSize = 128;
                int initialPageCount = (indexSize + 128 - 1) / 128;
                docIDs = new MonotonicAppendingLongBuffer(initialPageCount, 128, 0.0f);
                offsets = new MonotonicAppendingLongBuffer(initialPageCount, 128, 0.0f);
                Iterator it = new Iterator(dataArr, this.cardinality, Integer.MAX_VALUE, SINGLE_ZERO_BUFFER, SINGLE_ZERO_BUFFER);
                block0: for (int k = 0; k < indexSize; ++k) {
                    docIDs.add(it.docID() + 1);
                    offsets.add(it.offset);
                    for (int i = 0; i < this.indexInterval; ++i) {
                        it.skipBlock();
                        if (it.docID() == Integer.MAX_VALUE) break block0;
                    }
                }
                docIDs.freeze();
                offsets.freeze();
            }
            return new PForDeltaDocIdSet(dataArr, this.cardinality, this.indexInterval, docIDs, offsets);
        }
    }
}

