/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.OpenBitSet;

public class OpenBitSetIterator
extends DocIdSetIterator {
    final long[] arr;
    final int words;
    private int i = -1;
    private long word;
    private int wordShift;
    private int indexArray;
    private int curDocId = -1;

    public OpenBitSetIterator(OpenBitSet obs) {
        this(obs.getBits(), obs.getNumWords());
    }

    public OpenBitSetIterator(long[] bits2, int numWords) {
        this.arr = bits2;
        this.words = numWords;
    }

    private void shift() {
        if ((int)this.word == 0) {
            this.wordShift += 32;
            this.word >>>= 32;
        }
        if ((this.word & 0xFFFFL) == 0L) {
            this.wordShift += 16;
            this.word >>>= 16;
        }
        if ((this.word & 0xFFL) == 0L) {
            this.wordShift += 8;
            this.word >>>= 8;
        }
        this.indexArray = BitUtil.bitList((byte)this.word);
    }

    @Override
    public int nextDoc() {
        if (this.indexArray == 0) {
            if (this.word != 0L) {
                this.word >>>= 8;
                this.wordShift += 8;
            }
            while (this.word == 0L) {
                if (++this.i >= this.words) {
                    this.curDocId = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                this.word = this.arr[this.i];
                this.wordShift = -1;
            }
            this.shift();
        }
        int bitIndex = (this.indexArray & 0xF) + this.wordShift;
        this.indexArray >>>= 4;
        this.curDocId = (this.i << 6) + bitIndex;
        return this.curDocId;
    }

    @Override
    public int advance(int target) {
        this.indexArray = 0;
        this.i = target >> 6;
        if (this.i >= this.words) {
            this.word = 0L;
            this.curDocId = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        this.wordShift = target & 0x3F;
        this.word = this.arr[this.i] >>> this.wordShift;
        if (this.word != 0L) {
            --this.wordShift;
        } else {
            while (this.word == 0L) {
                if (++this.i >= this.words) {
                    this.curDocId = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                this.word = this.arr[this.i];
            }
            this.wordShift = -1;
        }
        this.shift();
        int bitIndex = (this.indexArray & 0xF) + this.wordShift;
        this.indexArray >>>= 4;
        this.curDocId = (this.i << 6) + bitIndex;
        return this.curDocId;
    }

    @Override
    public int docID() {
        return this.curDocId;
    }

    @Override
    public long cost() {
        return this.words / 64;
    }
}

