/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.util.IOUtils;

public abstract class Directory
implements Closeable {
    public abstract String[] listAll() throws IOException;

    public abstract boolean fileExists(String var1) throws IOException;

    public abstract void deleteFile(String var1) throws IOException;

    public abstract long fileLength(String var1) throws IOException;

    public abstract IndexOutput createOutput(String var1, IOContext var2) throws IOException;

    public abstract void sync(Collection<String> var1) throws IOException;

    public abstract IndexInput openInput(String var1, IOContext var2) throws IOException;

    public abstract Lock makeLock(String var1);

    public abstract void clearLock(String var1) throws IOException;

    @Override
    public abstract void close() throws IOException;

    public abstract void setLockFactory(LockFactory var1) throws IOException;

    public abstract LockFactory getLockFactory();

    public String getLockID() {
        return this.toString();
    }

    public String toString() {
        return super.toString() + " lockFactory=" + this.getLockFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void copy(Directory to2, String src, String dest, IOContext context) throws IOException {
        IndexOutput os = null;
        IndexInput is = null;
        IOException priorException = null;
        os = to2.createOutput(dest, context);
        is = this.openInput(src, context);
        os.copyBytes(is, is.length());
        boolean success2 = false;
        try {
            IOUtils.closeWhileHandlingException(priorException, os, is);
            success2 = true;
        }
        finally {
            if (!success2) {
                try {
                    to2.deleteFile(dest);
                }
                catch (Throwable t) {}
            }
        }
        catch (IOException ioe) {
            try {
                priorException = ioe;
                success3 = false;
            }
            catch (Throwable throwable) {
                boolean success32 = false;
                try {
                    IOUtils.closeWhileHandlingException(priorException, os, is);
                    success32 = true;
                }
                finally {
                    if (!success32) {
                        try {
                            to2.deleteFile(dest);
                        }
                        catch (Throwable t) {}
                    }
                }
                throw throwable;
            }
            try {
                IOUtils.closeWhileHandlingException(priorException, os, is);
                success3 = true;
            }
            finally {
                if (!success3) {
                    try {
                        to2.deleteFile(dest);
                    }
                    catch (Throwable t) {}
                }
            }
        }
    }

    public IndexInputSlicer createSlicer(final String name, final IOContext context) throws IOException {
        this.ensureOpen();
        return new IndexInputSlicer(){
            private final IndexInput base;
            {
                this.base = Directory.this.openInput(name, context);
            }

            @Override
            public IndexInput openSlice(String sliceDescription, long offset, long length) {
                return new SlicedIndexInput("SlicedIndexInput(" + sliceDescription + " in " + this.base + ")", this.base, offset, length);
            }

            @Override
            public void close() throws IOException {
                this.base.close();
            }

            @Override
            public IndexInput openFullSlice() {
                return this.base.clone();
            }
        };
    }

    protected void ensureOpen() throws AlreadyClosedException {
    }

    private static final class SlicedIndexInput
    extends BufferedIndexInput {
        IndexInput base;
        long fileOffset;
        long length;

        SlicedIndexInput(String sliceDescription, IndexInput base, long fileOffset, long length) {
            this(sliceDescription, base, fileOffset, length, 1024);
        }

        SlicedIndexInput(String sliceDescription, IndexInput base, long fileOffset, long length, int readBufferSize) {
            super("SlicedIndexInput(" + sliceDescription + " in " + base + " slice=" + fileOffset + ":" + (fileOffset + length) + ")", readBufferSize);
            this.base = base.clone();
            this.fileOffset = fileOffset;
            this.length = length;
        }

        @Override
        public SlicedIndexInput clone() {
            SlicedIndexInput clone2 = (SlicedIndexInput)super.clone();
            clone2.base = this.base.clone();
            clone2.fileOffset = this.fileOffset;
            clone2.length = this.length;
            return clone2;
        }

        @Override
        protected void readInternal(byte[] b, int offset, int len) throws IOException {
            long start = this.getFilePointer();
            if (start + (long)len > this.length) {
                throw new EOFException("read past EOF: " + this);
            }
            this.base.seek(this.fileOffset + start);
            this.base.readBytes(b, offset, len, false);
        }

        @Override
        protected void seekInternal(long pos) {
        }

        @Override
        public void close() throws IOException {
            this.base.close();
        }

        @Override
        public long length() {
            return this.length;
        }
    }

    public abstract class IndexInputSlicer
    implements Closeable {
        public abstract IndexInput openSlice(String var1, long var2, long var4) throws IOException;

        @Deprecated
        public abstract IndexInput openFullSlice() throws IOException;
    }
}

