/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.EOFException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.WeakIdentityMap;

abstract class ByteBufferIndexInput
extends IndexInput {
    private ByteBuffer[] buffers;
    private final long chunkSizeMask;
    private final int chunkSizePower;
    private int offset;
    private long length;
    private String sliceDescription;
    private int curBufIndex;
    private ByteBuffer curBuf;
    private boolean isClone = false;
    private final WeakIdentityMap<ByteBufferIndexInput, Boolean> clones;

    ByteBufferIndexInput(String resourceDescription, ByteBuffer[] buffers, long length, int chunkSizePower, boolean trackClones) throws IOException {
        super(resourceDescription);
        this.buffers = buffers;
        this.length = length;
        this.chunkSizePower = chunkSizePower;
        this.chunkSizeMask = (1L << chunkSizePower) - 1L;
        WeakIdentityMap<Object, Object> weakIdentityMap = this.clones = trackClones ? WeakIdentityMap.newConcurrentHashMap() : null;
        assert (chunkSizePower >= 0 && chunkSizePower <= 30);
        assert (length >>> chunkSizePower < Integer.MAX_VALUE);
        this.seek(0L);
    }

    @Override
    public final byte readByte() throws IOException {
        try {
            return this.curBuf.get();
        }
        catch (BufferUnderflowException e) {
            do {
                ++this.curBufIndex;
                if (this.curBufIndex >= this.buffers.length) {
                    throw new EOFException("read past EOF: " + this);
                }
                this.curBuf = this.buffers[this.curBufIndex];
                this.curBuf.position(0);
            } while (!this.curBuf.hasRemaining());
            return this.curBuf.get();
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public final void readBytes(byte[] b, int offset, int len) throws IOException {
        try {
            this.curBuf.get(b, offset, len);
        }
        catch (BufferUnderflowException e) {
            int curAvail = this.curBuf.remaining();
            while (len > curAvail) {
                this.curBuf.get(b, offset, curAvail);
                len -= curAvail;
                offset += curAvail;
                ++this.curBufIndex;
                if (this.curBufIndex >= this.buffers.length) {
                    throw new EOFException("read past EOF: " + this);
                }
                this.curBuf = this.buffers[this.curBufIndex];
                this.curBuf.position(0);
                curAvail = this.curBuf.remaining();
            }
            this.curBuf.get(b, offset, len);
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public final short readShort() throws IOException {
        try {
            return this.curBuf.getShort();
        }
        catch (BufferUnderflowException e) {
            return super.readShort();
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public final int readInt() throws IOException {
        try {
            return this.curBuf.getInt();
        }
        catch (BufferUnderflowException e) {
            return super.readInt();
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public final long readLong() throws IOException {
        try {
            return this.curBuf.getLong();
        }
        catch (BufferUnderflowException e) {
            return super.readLong();
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public final long getFilePointer() {
        try {
            return ((long)this.curBufIndex << this.chunkSizePower) + (long)this.curBuf.position() - (long)this.offset;
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public final void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IllegalArgumentException("Seeking to negative position: " + this);
        }
        int bi = (int)((pos += (long)this.offset) >> this.chunkSizePower);
        try {
            ByteBuffer b = this.buffers[bi];
            b.position((int)(pos & this.chunkSizeMask));
            this.curBufIndex = bi;
            this.curBuf = b;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new EOFException("seek past EOF: " + this);
        }
        catch (IllegalArgumentException iae) {
            throw new EOFException("seek past EOF: " + this);
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public final long length() {
        return this.length;
    }

    @Override
    public final ByteBufferIndexInput clone() {
        ByteBufferIndexInput clone2 = this.buildSlice(0L, this.length);
        try {
            clone2.seek(this.getFilePointer());
        }
        catch (IOException ioe) {
            throw new RuntimeException("Should never happen: " + this, ioe);
        }
        return clone2;
    }

    public final ByteBufferIndexInput slice(String sliceDescription, long offset, long length) {
        if (this.isClone) {
            throw new IllegalStateException("cannot slice() " + sliceDescription + " from a cloned IndexInput: " + this);
        }
        ByteBufferIndexInput clone2 = this.buildSlice(offset, length);
        clone2.sliceDescription = sliceDescription;
        try {
            clone2.seek(0L);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Should never happen: " + this, ioe);
        }
        return clone2;
    }

    private ByteBufferIndexInput buildSlice(long offset, long length) {
        if (this.buffers == null) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
        if (offset < 0L || length < 0L || offset + length > this.length) {
            throw new IllegalArgumentException("slice() " + this.sliceDescription + " out of bounds: offset=" + offset + ",length=" + length + ",fileLength=" + this.length + ": " + this);
        }
        offset += (long)this.offset;
        ByteBufferIndexInput clone2 = (ByteBufferIndexInput)super.clone();
        clone2.isClone = true;
        assert (clone2.clones == this.clones);
        clone2.buffers = this.buildSlice(this.buffers, offset, length);
        clone2.offset = (int)(offset & this.chunkSizeMask);
        clone2.length = length;
        if (this.clones != null) {
            this.clones.put(clone2, Boolean.TRUE);
        }
        return clone2;
    }

    private ByteBuffer[] buildSlice(ByteBuffer[] buffers, long offset, long length) {
        long sliceEnd = offset + length;
        int startIndex = (int)(offset >>> this.chunkSizePower);
        int endIndex = (int)(sliceEnd >>> this.chunkSizePower);
        ByteBuffer[] slices = new ByteBuffer[endIndex - startIndex + 1];
        for (int i = 0; i < slices.length; ++i) {
            slices[i] = buffers[startIndex + i].duplicate();
        }
        slices[slices.length - 1].limit((int)(sliceEnd & this.chunkSizeMask));
        return slices;
    }

    private void unsetBuffers() {
        this.buffers = null;
        this.curBuf = null;
        this.curBufIndex = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        try {
            if (this.buffers == null) {
                return;
            }
            ByteBuffer[] bufs = this.buffers;
            this.unsetBuffers();
            if (this.clones != null) {
                this.clones.remove(this);
            }
            if (this.isClone) {
                return;
            }
            if (this.clones != null) {
                Iterator<ByteBufferIndexInput> it = this.clones.keyIterator();
                while (it.hasNext()) {
                    ByteBufferIndexInput clone2 = it.next();
                    assert (clone2.isClone);
                    clone2.unsetBuffers();
                }
                this.clones.clear();
            }
            for (ByteBuffer b : bufs) {
                this.freeBuffer(b);
            }
        }
        finally {
            this.unsetBuffers();
        }
    }

    protected abstract void freeBuffer(ByteBuffer var1) throws IOException;

    @Override
    public final String toString() {
        if (this.sliceDescription != null) {
            return super.toString() + " [slice=" + this.sliceDescription + "]";
        }
        return super.toString();
    }
}

