/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.query;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.shape.Shape;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;

public class SpatialArgsParser {
    public static final String DIST_ERR_PCT = "distErrPct";
    public static final String DIST_ERR = "distErr";

    static String writeSpatialArgs(SpatialArgs args) {
        StringBuilder str = new StringBuilder();
        str.append(args.getOperation().getName());
        str.append('(');
        str.append(args.getShape().toString());
        if (args.getDistErrPct() != null) {
            str.append(" distErrPct=").append(String.format(Locale.ROOT, "%.2f%%", args.getDistErrPct() * 100.0));
        }
        if (args.getDistErr() != null) {
            str.append(" distErr=").append(args.getDistErr());
        }
        str.append(')');
        return str.toString();
    }

    public SpatialArgs parse(String v, SpatialContext ctx) throws IllegalArgumentException, InvalidShapeException {
        int idx = v.indexOf(40);
        int edx = v.lastIndexOf(41);
        if (idx < 0 || idx > edx) {
            throw new IllegalArgumentException("missing parens: " + v, null);
        }
        SpatialOperation op = SpatialOperation.get(v.substring(0, idx).trim());
        String body = v.substring(idx + 1, edx).trim();
        if (body.length() < 1) {
            throw new IllegalArgumentException("missing body : " + v, null);
        }
        Shape shape = ctx.readShape(body);
        SpatialArgs args = new SpatialArgs(op, shape);
        if (v.length() > edx + 1 && (body = v.substring(edx + 1).trim()).length() > 0) {
            Map<String, String> aa = SpatialArgsParser.parseMap(body);
            args.setDistErrPct(SpatialArgsParser.readDouble(aa.remove(DIST_ERR_PCT)));
            args.setDistErr(SpatialArgsParser.readDouble(aa.remove(DIST_ERR)));
            if (!aa.isEmpty()) {
                throw new IllegalArgumentException("unused parameters: " + aa, null);
            }
        }
        args.validate();
        return args;
    }

    protected static Double readDouble(String v) {
        return v == null ? null : Double.valueOf(v);
    }

    protected static boolean readBool(String v, boolean defaultValue) {
        return v == null ? defaultValue : Boolean.parseBoolean(v);
    }

    protected static Map<String, String> parseMap(String body) {
        HashMap<String, String> map2 = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(body, " \n\t");
        while (st.hasMoreTokens()) {
            String a = st.nextToken();
            int idx = a.indexOf(61);
            if (idx > 0) {
                String k = a.substring(0, idx);
                String v = a.substring(idx + 1);
                map2.put(k, v);
                continue;
            }
            map2.put(a, a);
        }
        return map2;
    }
}

