/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.spatial.prefix.AbstractPrefixTreeFilter;
import org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SentinelIntSet;

public class ContainsPrefixTreeFilter
extends AbstractPrefixTreeFilter {
    protected final boolean multiOverlappingIndexedShapes;

    public ContainsPrefixTreeFilter(Shape queryShape, String fieldName, SpatialPrefixTree grid, int detailLevel, boolean multiOverlappingIndexedShapes) {
        super(queryShape, fieldName, grid, detailLevel);
        this.multiOverlappingIndexedShapes = multiOverlappingIndexedShapes;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        return this.multiOverlappingIndexedShapes == ((ContainsPrefixTreeFilter)o).multiOverlappingIndexedShapes;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + (this.multiOverlappingIndexedShapes ? 1 : 0);
    }

    @Override
    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        return new ContainsVisitor(context, acceptDocs).visit(this.grid.getWorldCell(), acceptDocs);
    }

    private static class SmallDocSet
    extends DocIdSet
    implements Bits {
        private final SentinelIntSet intSet;
        private int maxInt = 0;

        public SmallDocSet(int size2) {
            this.intSet = new SentinelIntSet(size2, -1);
        }

        @Override
        public boolean get(int index) {
            return this.intSet.exists(index);
        }

        public void set(int index) {
            this.intSet.put(index);
            if (index > this.maxInt) {
                this.maxInt = index;
            }
        }

        @Override
        public int length() {
            return this.maxInt;
        }

        public int size() {
            return this.intSet.size();
        }

        public SmallDocSet union(SmallDocSet other) {
            SmallDocSet smaller;
            SmallDocSet bigger;
            if (other.intSet.size() > this.intSet.size()) {
                bigger = other;
                smaller = this;
            } else {
                bigger = this;
                smaller = other;
            }
            for (int v : smaller.intSet.keys) {
                if (v == smaller.intSet.emptyVal) continue;
                bigger.set(v);
            }
            return bigger;
        }

        @Override
        public Bits bits() throws IOException {
            return this.size() > 4 ? this : null;
        }

        @Override
        public DocIdSetIterator iterator() throws IOException {
            if (this.size() == 0) {
                return null;
            }
            int d = 0;
            final int[] docs = new int[this.intSet.size()];
            for (int v : this.intSet.keys) {
                if (v == this.intSet.emptyVal) continue;
                docs[d++] = v;
            }
            assert (d == this.intSet.size());
            final int size2 = d;
            Arrays.sort(docs, 0, size2);
            return new DocIdSetIterator(){
                int idx = -1;

                @Override
                public int docID() {
                    if (this.idx >= 0 && this.idx < size2) {
                        return docs[this.idx];
                    }
                    return -1;
                }

                @Override
                public int nextDoc() throws IOException {
                    if (++this.idx < size2) {
                        return docs[this.idx];
                    }
                    return Integer.MAX_VALUE;
                }

                @Override
                public int advance(int target) throws IOException {
                    return this.slowAdvance(target);
                }

                @Override
                public long cost() {
                    return size2;
                }
            };
        }
    }

    private class ContainsVisitor
    extends AbstractPrefixTreeFilter.BaseTermsEnumTraverser {
        BytesRef termBytes;
        Cell nextCell;
        private Cell lastLeaf;

        public ContainsVisitor(AtomicReaderContext context, Bits acceptDocs) throws IOException {
            super(context, acceptDocs);
            this.termBytes = new BytesRef();
            this.lastLeaf = null;
        }

        private SmallDocSet visit(Cell cell, Bits acceptContains) throws IOException {
            Cell subCell;
            if (this.termsEnum == null) {
                return null;
            }
            SmallDocSet leafDocs = this.getLeafDocs(cell, acceptContains);
            SmallDocSet combinedSubResults = null;
            Shape subCellsFilter = ContainsPrefixTreeFilter.this.queryShape;
            if (cell.getLevel() != 0 && (cell.getShapeRel() == null || cell.getShapeRel() == SpatialRelation.WITHIN)) {
                subCellsFilter = null;
                assert (cell.getShape().relate(ContainsPrefixTreeFilter.this.queryShape) == SpatialRelation.WITHIN);
            }
            Collection<Cell> subCells = cell.getSubCells(subCellsFilter);
            Iterator<Cell> i$ = subCells.iterator();
            while (i$.hasNext() && (combinedSubResults = !this.seekExact(subCell = i$.next()) ? null : (subCell.getLevel() == ContainsPrefixTreeFilter.this.detailLevel ? this.getDocs(subCell, acceptContains) : (!ContainsPrefixTreeFilter.this.multiOverlappingIndexedShapes && subCell.getShapeRel() == SpatialRelation.WITHIN ? this.getLeafDocs(subCell, acceptContains) : this.visit(subCell, acceptContains)))) != null) {
                acceptContains = combinedSubResults;
            }
            if (combinedSubResults != null) {
                if (leafDocs == null) {
                    return combinedSubResults;
                }
                return leafDocs.union(combinedSubResults);
            }
            return leafDocs;
        }

        private boolean seekExact(Cell cell) throws IOException {
            assert (new BytesRef(cell.getTokenBytes()).compareTo(this.termBytes) > 0);
            this.termBytes.bytes = cell.getTokenBytes();
            this.termBytes.length = this.termBytes.bytes.length;
            if (this.termsEnum == null) {
                return false;
            }
            return this.termsEnum.seekExact(this.termBytes);
        }

        private SmallDocSet getDocs(Cell cell, Bits acceptContains) throws IOException {
            assert (new BytesRef(cell.getTokenBytes()).equals(this.termBytes));
            return this.collectDocs(acceptContains);
        }

        private SmallDocSet getLeafDocs(Cell leafCell, Bits acceptContains) throws IOException {
            assert (new BytesRef(leafCell.getTokenBytes()).equals(this.termBytes));
            assert (!leafCell.equals(this.lastLeaf));
            this.lastLeaf = leafCell;
            if (this.termsEnum == null) {
                return null;
            }
            BytesRef nextTerm = this.termsEnum.next();
            if (nextTerm == null) {
                this.termsEnum = null;
                return null;
            }
            this.nextCell = ContainsPrefixTreeFilter.this.grid.getCell(nextTerm.bytes, nextTerm.offset, nextTerm.length, this.nextCell);
            if (this.nextCell.getLevel() == leafCell.getLevel() && this.nextCell.isLeaf()) {
                return this.collectDocs(acceptContains);
            }
            return null;
        }

        private SmallDocSet collectDocs(Bits acceptContains) throws IOException {
            int docid;
            SmallDocSet set = null;
            this.docsEnum = this.termsEnum.docs(acceptContains, this.docsEnum, 0);
            while ((docid = this.docsEnum.nextDoc()) != Integer.MAX_VALUE) {
                if (set == null) {
                    int size2 = this.termsEnum.docFreq();
                    if (size2 <= 0) {
                        size2 = 16;
                    }
                    set = new SmallDocSet(size2);
                }
                set.set(docid);
            }
            return set;
        }
    }
}

