/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.tst;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.suggest.InputIterator;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.SortedInputIterator;
import org.apache.lucene.search.suggest.tst.TSTAutocomplete;
import org.apache.lucene.search.suggest.tst.TernaryTreeNode;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.UnicodeUtil;

public class TSTLookup
extends Lookup {
    TernaryTreeNode root = new TernaryTreeNode();
    TSTAutocomplete autocomplete = new TSTAutocomplete();
    private static final byte LO_KID = 1;
    private static final byte EQ_KID = 2;
    private static final byte HI_KID = 4;
    private static final byte HAS_TOKEN = 8;
    private static final byte HAS_VALUE = 16;

    @Override
    public void build(InputIterator tfit) throws IOException {
        BytesRef spare;
        if (tfit.hasPayloads()) {
            throw new IllegalArgumentException("this suggester doesn't support payloads");
        }
        this.root = new TernaryTreeNode();
        if (tfit.getComparator() != BytesRef.getUTF8SortedAsUTF16Comparator()) {
            tfit = new SortedInputIterator(tfit, BytesRef.getUTF8SortedAsUTF16Comparator());
        }
        ArrayList<String> tokens = new ArrayList<String>();
        ArrayList<Long> vals = new ArrayList<Long>();
        CharsRef charsSpare = new CharsRef();
        while ((spare = tfit.next()) != null) {
            charsSpare.grow(spare.length);
            UnicodeUtil.UTF8toUTF16(spare.bytes, spare.offset, spare.length, charsSpare);
            tokens.add(charsSpare.toString());
            vals.add(tfit.weight());
        }
        this.autocomplete.balancedTree(tokens.toArray(), vals.toArray(), 0, tokens.size() - 1, this.root);
    }

    public boolean add(CharSequence key, Object value2) {
        this.autocomplete.insert(this.root, key, value2, 0);
        return true;
    }

    public Object get(CharSequence key) {
        ArrayList<TernaryTreeNode> list2 = this.autocomplete.prefixCompletion(this.root, key, 0);
        if (list2 == null || list2.isEmpty()) {
            return null;
        }
        for (TernaryTreeNode n : list2) {
            if (!TSTLookup.charSeqEquals(n.token, key)) continue;
            return n.val;
        }
        return null;
    }

    private static boolean charSeqEquals(CharSequence left, CharSequence right) {
        int len = left.length();
        if (len != right.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (left.charAt(i) == right.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, boolean onlyMorePopular, int num) {
        ArrayList<TernaryTreeNode> list2 = this.autocomplete.prefixCompletion(this.root, key, 0);
        ArrayList<Lookup.LookupResult> res = new ArrayList<Lookup.LookupResult>();
        if (list2 == null || list2.size() == 0) {
            return res;
        }
        int maxCnt = Math.min(num, list2.size());
        if (onlyMorePopular) {
            Lookup.LookupPriorityQueue queue = new Lookup.LookupPriorityQueue(num);
            for (TernaryTreeNode ttn : list2) {
                queue.insertWithOverflow(new Lookup.LookupResult(ttn.token, ((Number)ttn.val).longValue()));
            }
            for (Lookup.LookupResult lr : queue.getResults()) {
                res.add(lr);
            }
        } else {
            for (int i = 0; i < maxCnt; ++i) {
                TernaryTreeNode ttn = (TernaryTreeNode)list2.get(i);
                res.add(new Lookup.LookupResult(ttn.token, ((Number)ttn.val).longValue()));
            }
        }
        return res;
    }

    private void readRecursively(DataInputStream in, TernaryTreeNode node) throws IOException {
        node.splitchar = in.readChar();
        byte mask = in.readByte();
        if ((mask & 8) != 0) {
            node.token = in.readUTF();
        }
        if ((mask & 0x10) != 0) {
            node.val = in.readLong();
        }
        if ((mask & 1) != 0) {
            node.loKid = new TernaryTreeNode();
            this.readRecursively(in, node.loKid);
        }
        if ((mask & 2) != 0) {
            node.eqKid = new TernaryTreeNode();
            this.readRecursively(in, node.eqKid);
        }
        if ((mask & 4) != 0) {
            node.hiKid = new TernaryTreeNode();
            this.readRecursively(in, node.hiKid);
        }
    }

    private void writeRecursively(DataOutputStream out, TernaryTreeNode node) throws IOException {
        out.writeChar(node.splitchar);
        int mask = 0;
        if (node.eqKid != null) {
            mask = (byte)(mask | 2);
        }
        if (node.loKid != null) {
            mask = (byte)(mask | 1);
        }
        if (node.hiKid != null) {
            mask = (byte)(mask | 4);
        }
        if (node.token != null) {
            mask = (byte)(mask | 8);
        }
        if (node.val != null) {
            mask = (byte)(mask | 0x10);
        }
        out.writeByte(mask);
        if (node.token != null) {
            out.writeUTF(node.token);
        }
        if (node.val != null) {
            out.writeLong(((Number)node.val).longValue());
        }
        if (node.loKid != null) {
            this.writeRecursively(out, node.loKid);
        }
        if (node.eqKid != null) {
            this.writeRecursively(out, node.eqKid);
        }
        if (node.hiKid != null) {
            this.writeRecursively(out, node.hiKid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean store(OutputStream output2) throws IOException {
        DataOutputStream out = new DataOutputStream(output2);
        try {
            this.writeRecursively(out, this.root);
            out.flush();
        }
        catch (Throwable throwable) {
            IOUtils.close(output2);
            throw throwable;
        }
        IOUtils.close(output2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean load(InputStream input2) throws IOException {
        DataInputStream in = new DataInputStream(input2);
        this.root = new TernaryTreeNode();
        try {
            this.readRecursively(in, this.root);
        }
        catch (Throwable throwable) {
            IOUtils.close(in);
            throw throwable;
        }
        IOUtils.close(in);
        return true;
    }

    @Override
    public long sizeInBytes() {
        return RamUsageEstimator.sizeOf(this.autocomplete);
    }
}

