/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.tst;

import java.util.ArrayList;
import java.util.Stack;
import org.apache.lucene.search.suggest.tst.TernaryTreeNode;

public class TSTAutocomplete {
    TSTAutocomplete() {
    }

    public void balancedTree(Object[] tokens, Object[] vals, int lo, int hi, TernaryTreeNode root2) {
        if (lo > hi) {
            return;
        }
        int mid = (lo + hi) / 2;
        root2 = this.insert(root2, (String)tokens[mid], vals[mid], 0);
        this.balancedTree(tokens, vals, lo, mid - 1, root2);
        this.balancedTree(tokens, vals, mid + 1, hi, root2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public TernaryTreeNode insert(TernaryTreeNode currentNode, CharSequence s, Object val, int x2) {
        if (s == null) return currentNode;
        if (s.length() <= x2) {
            return currentNode;
        }
        if (currentNode == null) {
            TernaryTreeNode newNode = new TernaryTreeNode();
            newNode.splitchar = s.charAt(x2);
            currentNode = newNode;
            if (x2 < s.length() - 1) {
                currentNode.eqKid = this.insert(currentNode.eqKid, s, val, x2 + 1);
                return currentNode;
            }
            currentNode.token = ((Object)s).toString();
            currentNode.val = val;
            return currentNode;
        }
        if (currentNode.splitchar > s.charAt(x2)) {
            currentNode.loKid = this.insert(currentNode.loKid, s, val, x2);
            return currentNode;
        }
        if (currentNode.splitchar != s.charAt(x2)) {
            currentNode.hiKid = this.insert(currentNode.hiKid, s, val, x2);
            return currentNode;
        }
        if (x2 < s.length() - 1) {
            currentNode.eqKid = this.insert(currentNode.eqKid, s, val, x2 + 1);
            return currentNode;
        }
        currentNode.token = ((Object)s).toString();
        currentNode.val = val;
        return currentNode;
    }

    public ArrayList<TernaryTreeNode> prefixCompletion(TernaryTreeNode root2, CharSequence s, int x2) {
        TernaryTreeNode p = root2;
        ArrayList<TernaryTreeNode> suggest = new ArrayList<TernaryTreeNode>();
        while (p != null) {
            if (s.charAt(x2) < p.splitchar) {
                p = p.loKid;
                continue;
            }
            if (s.charAt(x2) == p.splitchar) {
                if (x2 == s.length() - 1) break;
                ++x2;
                p = p.eqKid;
                continue;
            }
            p = p.hiKid;
        }
        if (p == null) {
            return suggest;
        }
        if (p.eqKid == null && p.token == null) {
            return suggest;
        }
        if (p.eqKid == null && p.token != null) {
            suggest.add(p);
            return suggest;
        }
        if (p.token != null) {
            suggest.add(p);
        }
        p = p.eqKid;
        Stack<TernaryTreeNode> st = new Stack<TernaryTreeNode>();
        st.push(p);
        while (!st.empty()) {
            TernaryTreeNode top = (TernaryTreeNode)st.peek();
            st.pop();
            if (top.token != null) {
                suggest.add(top);
            }
            if (top.eqKid != null) {
                st.push(top.eqKid);
            }
            if (top.loKid != null) {
                st.push(top.loKid);
            }
            if (top.hiKid == null) continue;
            st.push(top.hiKid);
        }
        return suggest;
    }
}

