/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.jaspell;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.suggest.InputIterator;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.UnsortedInputIterator;
import org.apache.lucene.search.suggest.jaspell.JaspellTernarySearchTrie;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.UnicodeUtil;

public class JaspellLookup
extends Lookup {
    JaspellTernarySearchTrie trie = new JaspellTernarySearchTrie();
    private boolean usePrefix = true;
    private int editDistance = 2;
    private static final byte LO_KID = 1;
    private static final byte EQ_KID = 2;
    private static final byte HI_KID = 4;
    private static final byte HAS_VALUE = 8;

    @Override
    public void build(InputIterator tfit) throws IOException {
        BytesRef spare;
        if (tfit.hasPayloads()) {
            throw new IllegalArgumentException("this suggester doesn't support payloads");
        }
        if (tfit.getComparator() != null) {
            tfit = new UnsortedInputIterator(tfit);
        }
        this.trie = new JaspellTernarySearchTrie();
        this.trie.setMatchAlmostDiff(this.editDistance);
        CharsRef charsSpare = new CharsRef();
        while ((spare = tfit.next()) != null) {
            long weight = tfit.weight();
            if (spare.length == 0) continue;
            charsSpare.grow(spare.length);
            UnicodeUtil.UTF8toUTF16(spare.bytes, spare.offset, spare.length, charsSpare);
            this.trie.put(charsSpare.toString(), weight);
        }
    }

    public boolean add(CharSequence key, Object value2) {
        this.trie.put(key, value2);
        return false;
    }

    public Object get(CharSequence key) {
        return this.trie.get(key);
    }

    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, boolean onlyMorePopular, int num) {
        ArrayList<Lookup.LookupResult> res = new ArrayList<Lookup.LookupResult>();
        int count2 = onlyMorePopular ? num * 2 : num;
        List<String> list2 = this.usePrefix ? this.trie.matchPrefix(key, count2) : this.trie.matchAlmost(key, count2);
        if (list2 == null || list2.size() == 0) {
            return res;
        }
        int maxCnt = Math.min(num, list2.size());
        if (onlyMorePopular) {
            Lookup.LookupPriorityQueue queue = new Lookup.LookupPriorityQueue(num);
            for (String s : list2) {
                long freq = ((Number)this.trie.get(s)).longValue();
                queue.insertWithOverflow(new Lookup.LookupResult(new CharsRef(s), freq));
            }
            for (Lookup.LookupResult lr : queue.getResults()) {
                res.add(lr);
            }
        } else {
            for (int i = 0; i < maxCnt; ++i) {
                String s = list2.get(i);
                long freq = ((Number)this.trie.get(s)).longValue();
                res.add(new Lookup.LookupResult(new CharsRef(s), freq));
            }
        }
        return res;
    }

    private void readRecursively(DataInputStream in, JaspellTernarySearchTrie.TSTNode node) throws IOException {
        JaspellTernarySearchTrie.TSTNode kid;
        node.splitchar = in.readChar();
        byte mask = in.readByte();
        if ((mask & 8) != 0) {
            node.data = in.readLong();
        }
        if ((mask & 1) != 0) {
            JaspellTernarySearchTrie jaspellTernarySearchTrie = this.trie;
            jaspellTernarySearchTrie.getClass();
            node.relatives[1] = kid = new JaspellTernarySearchTrie.TSTNode(jaspellTernarySearchTrie, '\u0000', node);
            this.readRecursively(in, kid);
        }
        if ((mask & 2) != 0) {
            JaspellTernarySearchTrie jaspellTernarySearchTrie = this.trie;
            jaspellTernarySearchTrie.getClass();
            node.relatives[2] = kid = new JaspellTernarySearchTrie.TSTNode(jaspellTernarySearchTrie, '\u0000', node);
            this.readRecursively(in, kid);
        }
        if ((mask & 4) != 0) {
            JaspellTernarySearchTrie jaspellTernarySearchTrie = this.trie;
            jaspellTernarySearchTrie.getClass();
            node.relatives[3] = kid = new JaspellTernarySearchTrie.TSTNode(jaspellTernarySearchTrie, '\u0000', node);
            this.readRecursively(in, kid);
        }
    }

    private void writeRecursively(DataOutputStream out, JaspellTernarySearchTrie.TSTNode node) throws IOException {
        if (node == null) {
            return;
        }
        out.writeChar(node.splitchar);
        byte mask = 0;
        if (node.relatives[1] != null) {
            mask = (byte)(mask | 1);
        }
        if (node.relatives[2] != null) {
            mask = (byte)(mask | 2);
        }
        if (node.relatives[3] != null) {
            mask = (byte)(mask | 4);
        }
        if (node.data != null) {
            mask = (byte)(mask | 8);
        }
        out.writeByte(mask);
        if (node.data != null) {
            out.writeLong(((Number)node.data).longValue());
        }
        this.writeRecursively(out, node.relatives[1]);
        this.writeRecursively(out, node.relatives[2]);
        this.writeRecursively(out, node.relatives[3]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean store(OutputStream output2) throws IOException {
        JaspellTernarySearchTrie.TSTNode root2 = this.trie.getRoot();
        if (root2 == null) {
            return false;
        }
        DataOutputStream out = new DataOutputStream(output2);
        try {
            this.writeRecursively(out, root2);
            out.flush();
        }
        catch (Throwable throwable) {
            IOUtils.close(out);
            throw throwable;
        }
        IOUtils.close(out);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean load(InputStream input2) throws IOException {
        DataInputStream in = new DataInputStream(input2);
        JaspellTernarySearchTrie jaspellTernarySearchTrie = this.trie;
        jaspellTernarySearchTrie.getClass();
        JaspellTernarySearchTrie.TSTNode root2 = new JaspellTernarySearchTrie.TSTNode(jaspellTernarySearchTrie, '\u0000', null);
        try {
            this.readRecursively(in, root2);
            this.trie.setRoot(root2);
        }
        catch (Throwable throwable) {
            IOUtils.close(in);
            throw throwable;
        }
        IOUtils.close(in);
        return true;
    }

    @Override
    public long sizeInBytes() {
        return RamUsageEstimator.sizeOf(this.trie);
    }
}

