/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.fst;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.search.suggest.InputIterator;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.Sort;
import org.apache.lucene.search.suggest.SortedInputIterator;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.store.OutputStreamDataOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;

public class WFSTCompletionLookup
extends Lookup {
    private FST<Long> fst = null;
    private final boolean exactFirst;
    static final Comparator<Long> weightComparator = new Comparator<Long>(){

        @Override
        public int compare(Long left, Long right) {
            return left.compareTo(right);
        }
    };

    public WFSTCompletionLookup() {
        this(true);
    }

    public WFSTCompletionLookup(boolean exactFirst) {
        this.exactFirst = exactFirst;
    }

    @Override
    public void build(InputIterator iterator2) throws IOException {
        if (iterator2.hasPayloads()) {
            throw new IllegalArgumentException("this suggester doesn't support payloads");
        }
        BytesRef scratch = new BytesRef();
        WFSTInputIterator iter2 = new WFSTInputIterator(iterator2);
        IntsRef scratchInts = new IntsRef();
        BytesRef previous = null;
        PositiveIntOutputs outputs = PositiveIntOutputs.getSingleton();
        Builder<Long> builder = new Builder<Long>(FST.INPUT_TYPE.BYTE1, outputs);
        while ((scratch = iter2.next()) != null) {
            long cost = iter2.weight();
            if (previous == null) {
                previous = new BytesRef();
            } else if (scratch.equals(previous)) continue;
            Util.toIntsRef(scratch, scratchInts);
            builder.add(scratchInts, cost);
            previous.copyBytes(scratch);
        }
        this.fst = builder.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean store(OutputStream output2) throws IOException {
        block3: {
            boolean bl;
            try {
                if (this.fst != null) break block3;
                bl = false;
            }
            catch (Throwable throwable) {
                IOUtils.close(output2);
                throw throwable;
            }
            IOUtils.close(output2);
            return bl;
        }
        this.fst.save(new OutputStreamDataOutput(output2));
        IOUtils.close(output2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean load(InputStream input2) throws IOException {
        try {
            this.fst = new FST<Long>(new InputStreamDataInput(input2), PositiveIntOutputs.getSingleton());
        }
        catch (Throwable throwable) {
            IOUtils.close(input2);
            throw throwable;
        }
        IOUtils.close(input2);
        return true;
    }

    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, boolean onlyMorePopular, int num) {
        assert (num > 0);
        if (onlyMorePopular) {
            throw new IllegalArgumentException("this suggester only works with onlyMorePopular=false");
        }
        if (this.fst == null) {
            return Collections.emptyList();
        }
        BytesRef scratch = new BytesRef(key);
        int prefixLength = scratch.length;
        FST.Arc<Long> arc = new FST.Arc<Long>();
        Long prefixOutput = null;
        try {
            prefixOutput = this.lookupPrefix(scratch, arc);
        }
        catch (IOException bogus) {
            throw new RuntimeException(bogus);
        }
        if (prefixOutput == null) {
            return Collections.emptyList();
        }
        ArrayList<Lookup.LookupResult> results = new ArrayList<Lookup.LookupResult>(num);
        CharsRef spare = new CharsRef();
        if (this.exactFirst && arc.isFinal()) {
            spare.grow(scratch.length);
            UnicodeUtil.UTF8toUTF16(scratch, spare);
            results.add(new Lookup.LookupResult(spare.toString(), WFSTCompletionLookup.decodeWeight(prefixOutput + (Long)arc.nextFinalOutput)));
            if (--num == 0) {
                return results;
            }
        }
        Util.MinResult<Long>[] completions = null;
        try {
            completions = Util.shortestPaths(this.fst, arc, prefixOutput, weightComparator, num, !this.exactFirst);
        }
        catch (IOException bogus) {
            throw new RuntimeException(bogus);
        }
        BytesRef suffix = new BytesRef(8);
        for (Util.MinResult<Long> completion : completions) {
            scratch.length = prefixLength;
            Util.toBytesRef(completion.input, suffix);
            scratch.append(suffix);
            spare.grow(scratch.length);
            UnicodeUtil.UTF8toUTF16(scratch, spare);
            results.add(new Lookup.LookupResult(spare.toString(), WFSTCompletionLookup.decodeWeight((Long)completion.output)));
        }
        return results;
    }

    private Long lookupPrefix(BytesRef scratch, FST.Arc<Long> arc) throws IOException {
        assert (0L == (Long)this.fst.outputs.getNoOutput());
        long output2 = 0L;
        FST.BytesReader bytesReader = this.fst.getBytesReader();
        this.fst.getFirstArc(arc);
        byte[] bytes = scratch.bytes;
        int pos = scratch.offset;
        int end = pos + scratch.length;
        while (pos < end) {
            if (this.fst.findTargetArc(bytes[pos++] & 0xFF, arc, arc, bytesReader) == null) {
                return null;
            }
            output2 += ((Long)arc.output).longValue();
        }
        return output2;
    }

    public Object get(CharSequence key) {
        if (this.fst == null) {
            return null;
        }
        FST.Arc<Long> arc = new FST.Arc<Long>();
        Long result2 = null;
        try {
            result2 = this.lookupPrefix(new BytesRef(key), arc);
        }
        catch (IOException bogus) {
            throw new RuntimeException(bogus);
        }
        if (result2 == null || !arc.isFinal()) {
            return null;
        }
        return WFSTCompletionLookup.decodeWeight(result2 + (Long)arc.nextFinalOutput);
    }

    private static int decodeWeight(long encoded) {
        return (int)(Integer.MAX_VALUE - encoded);
    }

    private static int encodeWeight(long value2) {
        if (value2 < 0L || value2 > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("cannot encode value: " + value2);
        }
        return Integer.MAX_VALUE - (int)value2;
    }

    @Override
    public long sizeInBytes() {
        return this.fst == null ? 0L : this.fst.sizeInBytes();
    }

    private final class WFSTInputIterator
    extends SortedInputIterator {
        WFSTInputIterator(InputIterator source) throws IOException {
            super(source);
            assert (!source.hasPayloads());
        }

        @Override
        protected void encode(Sort.ByteSequencesWriter writer, ByteArrayDataOutput output2, byte[] buffer, BytesRef spare, BytesRef payload, long weight) throws IOException {
            if (spare.length + 4 >= buffer.length) {
                buffer = ArrayUtil.grow(buffer, spare.length + 4);
            }
            output2.reset(buffer);
            output2.writeBytes(spare.bytes, spare.offset, spare.length);
            output2.writeInt(WFSTCompletionLookup.encodeWeight(weight));
            writer.write(buffer, 0, output2.getPosition());
        }

        @Override
        protected long decode(BytesRef scratch, ByteArrayDataInput tmpInput) {
            scratch.length -= 4;
            tmpInput.reset(scratch.bytes, scratch.offset + scratch.length, 4);
            return tmpInput.readInt();
        }
    }
}

