/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.analyzing;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.shingle.ShingleFilter;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.suggest.InputIterator;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.Sort;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.store.OutputStreamDataOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.Version;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;

public class FreeTextSuggester
extends Lookup {
    public static final String CODEC_NAME = "freetextsuggest";
    public static final int VERSION_START = 0;
    public static final int VERSION_CURRENT = 0;
    public static final int DEFAULT_GRAMS = 2;
    public static final double ALPHA = 0.4;
    private FST<Long> fst;
    private final Analyzer indexAnalyzer;
    private long totTokens;
    private final Analyzer queryAnalyzer;
    private final int grams;
    private final byte separator;
    public static final byte DEFAULT_SEPARATOR = 30;
    static final Comparator<Long> weightComparator = new Comparator<Long>(){

        @Override
        public int compare(Long left, Long right) {
            return left.compareTo(right);
        }
    };

    public FreeTextSuggester(Analyzer analyzer) {
        this(analyzer, analyzer, 2);
    }

    public FreeTextSuggester(Analyzer indexAnalyzer, Analyzer queryAnalyzer) {
        this(indexAnalyzer, queryAnalyzer, 2);
    }

    public FreeTextSuggester(Analyzer indexAnalyzer, Analyzer queryAnalyzer, int grams) {
        this(indexAnalyzer, queryAnalyzer, grams, 30);
    }

    public FreeTextSuggester(Analyzer indexAnalyzer, Analyzer queryAnalyzer, int grams, byte separator) {
        this.grams = grams;
        this.indexAnalyzer = this.addShingles(indexAnalyzer);
        this.queryAnalyzer = this.addShingles(queryAnalyzer);
        if (grams < 1) {
            throw new IllegalArgumentException("grams must be >= 1");
        }
        if ((separator & 0x80) != 0) {
            throw new IllegalArgumentException("separator must be simple ascii character");
        }
        this.separator = separator;
    }

    @Override
    public long sizeInBytes() {
        if (this.fst == null) {
            return 0L;
        }
        return this.fst.sizeInBytes();
    }

    private Analyzer addShingles(final Analyzer other) {
        if (this.grams == 1) {
            return other;
        }
        return new AnalyzerWrapper(other.getReuseStrategy()){

            @Override
            protected Analyzer getWrappedAnalyzer(String fieldName) {
                return other;
            }

            @Override
            protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
                ShingleFilter shingles = new ShingleFilter(components.getTokenStream(), 2, FreeTextSuggester.this.grams);
                shingles.setTokenSeparator(Character.toString((char)FreeTextSuggester.this.separator));
                return new Analyzer.TokenStreamComponents(components.getTokenizer(), shingles);
            }
        };
    }

    @Override
    public void build(InputIterator iterator2) throws IOException {
        this.build(iterator2, 16.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void build(InputIterator iterator2, double ramBufferSizeMB) throws IOException {
        if (iterator2.hasPayloads()) {
            throw new IllegalArgumentException("payloads are not supported");
        }
        String prefix = this.getClass().getSimpleName();
        File directory = Sort.defaultTempDir();
        File tempIndexPath = null;
        Random random = new Random();
        while (!(tempIndexPath = new File(directory, prefix + ".index." + random.nextInt(Integer.MAX_VALUE))).mkdir()) {
        }
        FSDirectory dir = FSDirectory.open(tempIndexPath);
        IndexWriterConfig iwc = new IndexWriterConfig(Version.LUCENE_46, this.indexAnalyzer);
        iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        iwc.setRAMBufferSizeMB(ramBufferSizeMB);
        IndexWriter writer = new IndexWriter(dir, iwc);
        FieldType ft = new FieldType(TextField.TYPE_NOT_STORED);
        ft.setIndexOptions(FieldInfo.IndexOptions.DOCS_AND_FREQS);
        ft.setOmitNorms(true);
        ft.freeze();
        Document doc = new Document();
        Field field2 = new Field("body", "", ft);
        doc.add(field2);
        this.totTokens = 0L;
        DirectoryReader reader = null;
        boolean success2 = false;
        try {
            Terms terms;
            while (true) {
                BytesRef surfaceForm;
                if ((surfaceForm = iterator2.next()) == null) {
                    reader = DirectoryReader.open(writer, false);
                    terms = MultiFields.getTerms(reader, "body");
                    if (terms == null) {
                        throw new IllegalArgumentException("need at least one suggestion");
                    }
                    break;
                }
                field2.setStringValue(surfaceForm.utf8ToString());
                writer.addDocument(doc);
            }
            TermsEnum termsEnum = terms.iterator(null);
            PositiveIntOutputs outputs = PositiveIntOutputs.getSingleton();
            Builder<Long> builder = new Builder<Long>(FST.INPUT_TYPE.BYTE1, outputs);
            IntsRef scratchInts = new IntsRef();
            while (true) {
                BytesRef term;
                if ((term = termsEnum.next()) == null) {
                    this.fst = builder.finish();
                    if (this.fst == null) {
                        throw new IllegalArgumentException("need at least one suggestion");
                    }
                    break;
                }
                int ngramCount = this.countGrams(term);
                if (ngramCount > this.grams) {
                    throw new IllegalArgumentException("tokens must not contain separator byte; got token=" + term + " but gramCount=" + ngramCount + ", which is greater than expected max ngram size=" + this.grams);
                }
                if (ngramCount == 1) {
                    this.totTokens += termsEnum.totalTermFreq();
                }
                builder.add(Util.toIntsRef(term, scratchInts), this.encodeWeight(termsEnum.totalTermFreq()));
            }
            success2 = true;
        }
        catch (Throwable throwable) {
            try {
                if (success2) {
                    IOUtils.close(writer, reader);
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException(writer, reader);
                throw throwable;
            }
            finally {
                for (String file : ((Directory)dir).listAll()) {
                    File path = new File(tempIndexPath, file);
                    if (path.delete()) continue;
                    throw new IllegalStateException("failed to remove " + path);
                }
                if (!tempIndexPath.delete()) {
                    throw new IllegalStateException("failed to remove " + tempIndexPath);
                }
                ((Directory)dir).close();
            }
        }
        try {
            if (success2) {
                IOUtils.close(writer, reader);
                return;
            }
            IOUtils.closeWhileHandlingException(writer, reader);
            return;
        }
        finally {
            for (String file : ((Directory)dir).listAll()) {
                File path = new File(tempIndexPath, file);
                if (path.delete()) continue;
                throw new IllegalStateException("failed to remove " + path);
            }
            if (!tempIndexPath.delete()) {
                throw new IllegalStateException("failed to remove " + tempIndexPath);
            }
            ((Directory)dir).close();
        }
    }

    @Override
    public boolean store(OutputStream output2) throws IOException {
        OutputStreamDataOutput out = new OutputStreamDataOutput(output2);
        CodecUtil.writeHeader(out, CODEC_NAME, 0);
        ((DataOutput)out).writeByte(this.separator);
        out.writeVInt(this.grams);
        out.writeVLong(this.totTokens);
        this.fst.save(out);
        return true;
    }

    @Override
    public boolean load(InputStream input2) throws IOException {
        InputStreamDataInput in = new InputStreamDataInput(input2);
        CodecUtil.checkHeader(in, CODEC_NAME, 0, 0);
        byte separatorOrig = ((DataInput)in).readByte();
        if (separatorOrig != this.separator) {
            throw new IllegalStateException("separator=" + this.separator + " is incorrect: original model was built with separator=" + separatorOrig);
        }
        int gramsOrig = in.readVInt();
        if (gramsOrig != this.grams) {
            throw new IllegalStateException("grams=" + this.grams + " is incorrect: original model was built with grams=" + gramsOrig);
        }
        this.totTokens = in.readVLong();
        this.fst = new FST<Long>(in, PositiveIntOutputs.getSingleton());
        return true;
    }

    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, boolean onlyMorePopular, int num) {
        try {
            return this.lookup(key, num);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private int countGrams(BytesRef token2) {
        int count2 = 1;
        for (int i = 0; i < token2.length; ++i) {
            if (token2.bytes[token2.offset + i] != this.separator) continue;
            ++count2;
        }
        return count2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Lookup.LookupResult> lookup(CharSequence key, int num) throws IOException {
        ArrayList<Lookup.LookupResult> arrayList;
        TokenStream ts = this.queryAnalyzer.tokenStream("", ((Object)key).toString());
        try {
            boolean lastTokenEnded;
            TermToBytesRefAttribute termBytesAtt = ts.addAttribute(TermToBytesRefAttribute.class);
            OffsetAttribute offsetAtt = ts.addAttribute(OffsetAttribute.class);
            PositionLengthAttribute posLenAtt = ts.addAttribute(PositionLengthAttribute.class);
            PositionIncrementAttribute posIncAtt = ts.addAttribute(PositionIncrementAttribute.class);
            ts.reset();
            BytesRef[] lastTokens = new BytesRef[this.grams];
            BytesRef tokenBytes = termBytesAtt.getBytesRef();
            int maxEndOffset = -1;
            boolean sawRealToken = false;
            while (ts.incrementToken()) {
                termBytesAtt.fillBytesRef();
                sawRealToken |= tokenBytes.length > 0;
                int gramCount = posLenAtt.getPositionLength();
                assert (gramCount <= this.grams);
                if (this.countGrams(tokenBytes) != gramCount) {
                    throw new IllegalArgumentException("tokens must not contain separator byte; got token=" + tokenBytes + " but gramCount=" + gramCount + " does not match recalculated count=" + this.countGrams(tokenBytes));
                }
                maxEndOffset = Math.max(maxEndOffset, offsetAtt.endOffset());
                lastTokens[gramCount - 1] = BytesRef.deepCopyOf(tokenBytes);
            }
            ts.end();
            if (!sawRealToken) {
                throw new IllegalArgumentException("no tokens produced by analyzer, or the only tokens were empty strings");
            }
            int endPosInc = posIncAtt.getPositionIncrement();
            boolean bl = lastTokenEnded = offsetAtt.endOffset() > maxEndOffset || endPosInc > 0;
            if (lastTokenEnded) {
                for (int i = this.grams - 1; i > 0; --i) {
                    BytesRef token2 = lastTokens[i - 1];
                    if (token2 == null) continue;
                    token2.grow(token2.length + 1);
                    token2.bytes[token2.length] = this.separator;
                    ++token2.length;
                    lastTokens[i] = token2;
                }
                lastTokens[0] = new BytesRef();
            }
            FST.Arc<Long> arc = new FST.Arc<Long>();
            FST.BytesReader bytesReader = this.fst.getBytesReader();
            double backoff = 1.0;
            ArrayList<Lookup.LookupResult> results = new ArrayList<Lookup.LookupResult>(num);
            final HashSet<BytesRef> seen = new HashSet<BytesRef>();
            for (int gram = this.grams - 1; gram >= 0; --gram) {
                BytesRef token3 = lastTokens[gram];
                if (token3 == null || token3.length == 0 && key.length() > 0) continue;
                if (endPosInc > 0 && gram <= endPosInc) break;
                Long prefixOutput = null;
                try {
                    prefixOutput = this.lookupPrefix(this.fst, bytesReader, token3, arc);
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
                if (prefixOutput == null) {
                    backoff *= 0.4;
                    continue;
                }
                long contextCount = this.totTokens;
                BytesRef lastTokenFragment = null;
                for (int i = token3.length - 1; i >= 0; --i) {
                    if (token3.bytes[token3.offset + i] != this.separator) continue;
                    BytesRef context = new BytesRef(token3.bytes, token3.offset, i);
                    Long output2 = Util.get(this.fst, Util.toIntsRef(context, new IntsRef()));
                    assert (output2 != null);
                    contextCount = this.decodeWeight(output2);
                    lastTokenFragment = new BytesRef(token3.bytes, token3.offset + i + 1, token3.length - i - 1);
                    break;
                }
                final BytesRef finalLastToken = lastTokenFragment == null ? BytesRef.deepCopyOf(token3) : BytesRef.deepCopyOf(lastTokenFragment);
                assert (finalLastToken.offset == 0);
                CharsRef spare = new CharsRef();
                Util.MinResult<T>[] completions = null;
                try {
                    Util.TopNSearcher<Long> searcher = new Util.TopNSearcher<Long>(this.fst, num, num + seen.size(), weightComparator){
                        BytesRef scratchBytes;
                        {
                            super(x0, x1, x2, x3);
                            this.scratchBytes = new BytesRef();
                        }

                        @Override
                        protected void addIfCompetitive(Util.FSTPath<Long> path) {
                            if (path.arc.label != FreeTextSuggester.this.separator) {
                                super.addIfCompetitive(path);
                            }
                        }

                        @Override
                        protected boolean acceptResult(IntsRef input2, Long output2) {
                            Util.toBytesRef(input2, this.scratchBytes);
                            finalLastToken.grow(finalLastToken.length + this.scratchBytes.length);
                            int lenSav = finalLastToken.length;
                            finalLastToken.append(this.scratchBytes);
                            boolean ret = !seen.contains(finalLastToken);
                            finalLastToken.length = lenSav;
                            return ret;
                        }
                    };
                    searcher.addStartPaths(arc, prefixOutput, true, new IntsRef());
                    completions = searcher.search();
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
                int prefixLength = token3.length;
                BytesRef suffix = new BytesRef(8);
                for (Util.MinResult completion : completions) {
                    token3.length = prefixLength;
                    Util.toBytesRef(completion.input, suffix);
                    token3.append(suffix);
                    BytesRef lastToken = token3;
                    for (int i = token3.length - 1; i >= 0; --i) {
                        if (token3.bytes[token3.offset + i] != this.separator) continue;
                        assert (token3.length - i - 1 > 0);
                        lastToken = new BytesRef(token3.bytes, token3.offset + i + 1, token3.length - i - 1);
                        break;
                    }
                    if (seen.contains(lastToken)) continue;
                    seen.add(BytesRef.deepCopyOf(lastToken));
                    spare.grow(token3.length);
                    UnicodeUtil.UTF8toUTF16(token3, spare);
                    Lookup.LookupResult result2 = new Lookup.LookupResult(spare.toString(), (long)(9.223372036854776E18 * backoff * (double)this.decodeWeight((Long)completion.output) / (double)contextCount));
                    results.add(result2);
                    assert (results.size() == seen.size());
                }
                backoff *= 0.4;
            }
            Collections.sort(results, new Comparator<Lookup.LookupResult>(){

                @Override
                public int compare(Lookup.LookupResult a, Lookup.LookupResult b) {
                    if (a.value > b.value) {
                        return -1;
                    }
                    if (a.value < b.value) {
                        return 1;
                    }
                    return ((String)a.key).compareTo((String)b.key);
                }
            });
            if (results.size() > num) {
                results.subList(num, results.size()).clear();
            }
            arrayList = results;
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(ts);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(ts);
        return arrayList;
    }

    private long encodeWeight(long ngramCount) {
        return Long.MAX_VALUE - ngramCount;
    }

    private long decodeWeight(Long output2) {
        assert (output2 != null);
        return (int)(Long.MAX_VALUE - output2);
    }

    private Long lookupPrefix(FST<Long> fst, FST.BytesReader bytesReader, BytesRef scratch, FST.Arc<Long> arc) throws IOException {
        Long output2 = (Long)fst.outputs.getNoOutput();
        fst.getFirstArc(arc);
        byte[] bytes = scratch.bytes;
        int pos = scratch.offset;
        int end = pos + scratch.length;
        while (pos < end) {
            if (fst.findTargetArc(bytes[pos++] & 0xFF, arc, arc, bytesReader) == null) {
                return null;
            }
            output2 = fst.outputs.add(output2, (Long)arc.output);
        }
        return output2;
    }

    public Object get(CharSequence key) {
        throw new UnsupportedOperationException();
    }

    private static class AnalyzingComparator
    implements Comparator<BytesRef> {
        private final ByteArrayDataInput readerA = new ByteArrayDataInput();
        private final ByteArrayDataInput readerB = new ByteArrayDataInput();
        private final BytesRef scratchA = new BytesRef();
        private final BytesRef scratchB = new BytesRef();

        private AnalyzingComparator() {
        }

        @Override
        public int compare(BytesRef a, BytesRef b) {
            this.readerA.reset(a.bytes, a.offset, a.length);
            this.readerB.reset(b.bytes, b.offset, b.length);
            this.scratchA.length = this.readerA.readShort();
            this.scratchA.bytes = a.bytes;
            this.scratchA.offset = this.readerA.getPosition();
            this.scratchB.bytes = b.bytes;
            this.scratchB.length = this.readerB.readShort();
            this.scratchB.offset = this.readerB.getPosition();
            int cmp = this.scratchA.compareTo(this.scratchB);
            if (cmp != 0) {
                return cmp;
            }
            this.readerA.skipBytes(this.scratchA.length);
            this.readerB.skipBytes(this.scratchB.length);
            cmp = a.length - b.length;
            if (cmp != 0) {
                return cmp;
            }
            this.scratchA.offset = this.readerA.getPosition();
            this.scratchA.length = a.length - this.scratchA.offset;
            this.scratchB.offset = this.readerB.getPosition();
            this.scratchB.length = b.length - this.scratchB.offset;
            return this.scratchA.compareTo(this.scratchB);
        }
    }
}

