/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.suggest.InputIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.PriorityQueue;

public abstract class Lookup {
    public static final Comparator<CharSequence> CHARSEQUENCE_COMPARATOR = new CharSequenceComparator();

    public void build(Dictionary dict) throws IOException {
        BytesRefIterator it = dict.getWordsIterator();
        InputIterator tfit = it instanceof InputIterator ? (InputIterator)it : new InputIterator.InputIteratorWrapper(it);
        this.build(tfit);
    }

    public abstract void build(InputIterator var1) throws IOException;

    public abstract List<LookupResult> lookup(CharSequence var1, boolean var2, int var3);

    public abstract boolean store(OutputStream var1) throws IOException;

    public abstract boolean load(InputStream var1) throws IOException;

    public abstract long sizeInBytes();

    public static final class LookupPriorityQueue
    extends PriorityQueue<LookupResult> {
        public LookupPriorityQueue(int size2) {
            super(size2);
        }

        @Override
        protected boolean lessThan(LookupResult a, LookupResult b) {
            return a.value < b.value;
        }

        public LookupResult[] getResults() {
            int size2 = this.size();
            LookupResult[] res = new LookupResult[size2];
            for (int i = size2 - 1; i >= 0; --i) {
                res[i] = (LookupResult)this.pop();
            }
            return res;
        }
    }

    private static class CharSequenceComparator
    implements Comparator<CharSequence> {
        private CharSequenceComparator() {
        }

        @Override
        public int compare(CharSequence o1, CharSequence o2) {
            int l1 = o1.length();
            int l2 = o2.length();
            int aStop = Math.min(l1, l2);
            for (int i = 0; i < aStop; ++i) {
                int diff2 = o1.charAt(i) - o2.charAt(i);
                if (diff2 == 0) continue;
                return diff2;
            }
            return l1 - l2;
        }
    }

    public static final class LookupResult
    implements Comparable<LookupResult> {
        public final CharSequence key;
        public final Object highlightKey;
        public final long value;
        public final BytesRef payload;

        public LookupResult(CharSequence key, long value2) {
            this(key, value2, null);
        }

        public LookupResult(CharSequence key, long value2, BytesRef payload) {
            this.key = key;
            this.highlightKey = null;
            this.value = value2;
            this.payload = payload;
        }

        public LookupResult(CharSequence key, Object highlightKey, long value2, BytesRef payload) {
            this.key = key;
            this.highlightKey = highlightKey;
            this.value = value2;
            this.payload = payload;
        }

        public String toString() {
            return this.key + "/" + this.value;
        }

        @Override
        public int compareTo(LookupResult o) {
            return CHARSEQUENCE_COMPARATOR.compare(this.key, o.key);
        }
    }
}

