/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest;

import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.SimpleBindings;
import org.apache.lucene.expressions.js.JavascriptCompiler;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.suggest.DocumentDictionary;
import org.apache.lucene.util.BytesRefIterator;

public class DocumentExpressionDictionary
extends DocumentDictionary {
    private ValueSource weightsValueSource;

    public DocumentExpressionDictionary(IndexReader reader, String field2, String weightExpression, Set<SortField> sortFields) {
        this(reader, field2, weightExpression, sortFields, null);
    }

    public DocumentExpressionDictionary(IndexReader reader, String field2, String weightExpression, Set<SortField> sortFields, String payload) {
        super(reader, field2, null, payload);
        Expression expression = null;
        try {
            expression = JavascriptCompiler.compile(weightExpression);
        }
        catch (ParseException e) {
            throw new RuntimeException();
        }
        SimpleBindings bindings = new SimpleBindings();
        for (SortField sortField : sortFields) {
            bindings.add(sortField);
        }
        this.weightsValueSource = expression.getValueSource(bindings);
    }

    @Override
    public BytesRefIterator getWordsIterator() throws IOException {
        return new DocumentExpressionInputIterator(this.payloadField != null);
    }

    final class DocumentExpressionInputIterator
    extends DocumentDictionary.DocumentInputIterator {
        private FunctionValues currentWeightValues;
        private int currentLeafIndex;
        private final List<AtomicReaderContext> leaves;
        private final int[] starts;

        public DocumentExpressionInputIterator(boolean hasPayloads) throws IOException {
            super(hasPayloads);
            this.currentLeafIndex = 0;
            this.leaves = DocumentExpressionDictionary.this.reader.leaves();
            if (this.leaves.size() == 0) {
                throw new IllegalArgumentException("Reader has to have at least one leaf");
            }
            this.starts = new int[this.leaves.size() + 1];
            for (int i = 0; i < this.leaves.size(); ++i) {
                this.starts[i] = this.leaves.get((int)i).docBase;
            }
            this.starts[this.leaves.size()] = DocumentExpressionDictionary.this.reader.maxDoc();
            this.currentLeafIndex = 0;
            this.currentWeightValues = DocumentExpressionDictionary.this.weightsValueSource.getValues(new HashMap(), this.leaves.get(this.currentLeafIndex));
        }

        @Override
        protected long getWeight(int docId) {
            int subIndex = ReaderUtil.subIndex(docId, this.starts);
            if (subIndex != this.currentLeafIndex) {
                this.currentLeafIndex = subIndex;
                try {
                    this.currentWeightValues = DocumentExpressionDictionary.this.weightsValueSource.getValues(new HashMap(), this.leaves.get(this.currentLeafIndex));
                }
                catch (IOException e) {
                    throw new RuntimeException();
                }
            }
            return this.currentWeightValues.longVal(docId - this.starts[subIndex]);
        }
    }
}

