/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell;

import java.util.Comparator;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.search.spell.SuggestWordScoreComparator;
import org.apache.lucene.util.PriorityQueue;

public final class SuggestWordQueue
extends PriorityQueue<SuggestWord> {
    public static final Comparator<SuggestWord> DEFAULT_COMPARATOR = new SuggestWordScoreComparator();
    private Comparator<SuggestWord> comparator;

    public SuggestWordQueue(int size2) {
        super(size2);
        this.comparator = DEFAULT_COMPARATOR;
    }

    public SuggestWordQueue(int size2, Comparator<SuggestWord> comparator) {
        super(size2);
        this.comparator = comparator;
    }

    @Override
    protected final boolean lessThan(SuggestWord wa, SuggestWord wb) {
        int val = this.comparator.compare(wa, wb);
        return val < 0;
    }
}

