/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similarities;

import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.similarities.AfterEffect;
import org.apache.lucene.search.similarities.BasicStats;

public class AfterEffectB
extends AfterEffect {
    @Override
    public final float score(BasicStats stats, float tfn) {
        long F = stats.getTotalTermFreq() + 1L;
        long n = stats.getDocFreq() + 1L;
        return (float)(F + 1L) / ((float)n * (tfn + 1.0f));
    }

    @Override
    public final Explanation explain(BasicStats stats, float tfn) {
        Explanation result2 = new Explanation();
        result2.setDescription(this.getClass().getSimpleName() + ", computed from: ");
        result2.setValue(this.score(stats, tfn));
        result2.addDetail(new Explanation(tfn, "tfn"));
        result2.addDetail(new Explanation(stats.getTotalTermFreq(), "totalTermFreq"));
        result2.addDetail(new Explanation(stats.getDocFreq(), "docFreq"));
        return result2;
    }

    @Override
    public String toString() {
        return "B";
    }
}

