/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.join.ToParentBlockJoinFieldComparator;

public class ToParentBlockJoinSortField
extends SortField {
    private final boolean order;
    private final Filter parentFilter;
    private final Filter childFilter;

    public ToParentBlockJoinSortField(String field2, SortField.Type type, boolean reverse2, Filter parentFilter, Filter childFilter) {
        super(field2, type, reverse2);
        this.order = reverse2;
        this.parentFilter = parentFilter;
        this.childFilter = childFilter;
    }

    public ToParentBlockJoinSortField(String field2, SortField.Type type, boolean reverse2, boolean order, Filter parentFilter, Filter childFilter) {
        super(field2, type, reverse2);
        this.order = order;
        this.parentFilter = parentFilter;
        this.childFilter = childFilter;
    }

    @Override
    public FieldComparator<?> getComparator(int numHits, int sortPos) throws IOException {
        FieldComparator<Object> wrappedFieldComparator = super.getComparator(numHits + 1, sortPos);
        if (this.order) {
            return new ToParentBlockJoinFieldComparator.Highest(wrappedFieldComparator, this.parentFilter, this.childFilter, numHits);
        }
        return new ToParentBlockJoinFieldComparator.Lowest(wrappedFieldComparator, this.parentFilter, this.childFilter, numHits);
    }
}

