/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.FixedBitSet;

public abstract class ToParentBlockJoinFieldComparator
extends FieldComparator<Object> {
    private final Filter parentFilter;
    private final Filter childFilter;
    final int spareSlot;
    FieldComparator<Object> wrappedComparator;
    FixedBitSet parentDocuments;
    FixedBitSet childDocuments;

    ToParentBlockJoinFieldComparator(FieldComparator<Object> wrappedComparator, Filter parentFilter, Filter childFilter, int spareSlot) {
        this.wrappedComparator = wrappedComparator;
        this.parentFilter = parentFilter;
        this.childFilter = childFilter;
        this.spareSlot = spareSlot;
    }

    @Override
    public int compare(int slot1, int slot2) {
        return this.wrappedComparator.compare(slot1, slot2);
    }

    @Override
    public void setBottom(int slot) {
        this.wrappedComparator.setBottom(slot);
    }

    @Override
    public FieldComparator<Object> setNextReader(AtomicReaderContext context) throws IOException {
        DocIdSetIterator iterator2;
        DocIdSetIterator iterator3;
        DocIdSet innerDocuments = this.childFilter.getDocIdSet(context, null);
        this.childDocuments = ToParentBlockJoinFieldComparator.isEmpty(innerDocuments) ? null : (innerDocuments instanceof FixedBitSet ? (FixedBitSet)innerDocuments : ((iterator3 = innerDocuments.iterator()) != null ? ToParentBlockJoinFieldComparator.toFixedBitSet(iterator3, context.reader().maxDoc()) : null));
        DocIdSet rootDocuments = this.parentFilter.getDocIdSet(context, null);
        this.parentDocuments = ToParentBlockJoinFieldComparator.isEmpty(rootDocuments) ? null : (rootDocuments instanceof FixedBitSet ? (FixedBitSet)rootDocuments : ((iterator2 = rootDocuments.iterator()) != null ? ToParentBlockJoinFieldComparator.toFixedBitSet(iterator2, context.reader().maxDoc()) : null));
        this.wrappedComparator = this.wrappedComparator.setNextReader(context);
        return this;
    }

    private static boolean isEmpty(DocIdSet set) {
        return set == null;
    }

    private static FixedBitSet toFixedBitSet(DocIdSetIterator iterator2, int numBits) throws IOException {
        int doc;
        FixedBitSet set = new FixedBitSet(numBits);
        while ((doc = iterator2.nextDoc()) != Integer.MAX_VALUE) {
            set.set(doc);
        }
        return set;
    }

    @Override
    public Object value(int slot) {
        return this.wrappedComparator.value(slot);
    }

    public static final class Highest
    extends ToParentBlockJoinFieldComparator {
        public Highest(FieldComparator<Object> wrappedComparator, Filter parentFilter, Filter childFilter, int spareSlot) {
            super(wrappedComparator, parentFilter, childFilter, spareSlot);
        }

        @Override
        public int compareBottom(int parentDoc) throws IOException {
            if (parentDoc == 0 || this.parentDocuments == null || this.childDocuments == null) {
                return 0;
            }
            int prevParentDoc = this.parentDocuments.prevSetBit(parentDoc - 1);
            int childDoc = this.childDocuments.nextSetBit(prevParentDoc + 1);
            if (childDoc >= parentDoc || childDoc == -1) {
                return 0;
            }
            int cmp = this.wrappedComparator.compareBottom(childDoc);
            if (cmp < 0) {
                return cmp;
            }
            while ((childDoc = this.childDocuments.nextSetBit(childDoc + 1)) < parentDoc && childDoc != -1) {
                int cmp1 = this.wrappedComparator.compareBottom(childDoc);
                if (cmp1 < 0) {
                    return cmp1;
                }
                if (cmp1 != 0) continue;
                cmp = 0;
            }
            return cmp;
        }

        @Override
        public void copy(int slot, int parentDoc) throws IOException {
            if (parentDoc == 0 || this.parentDocuments == null || this.childDocuments == null) {
                return;
            }
            int prevParentDoc = this.parentDocuments.prevSetBit(parentDoc - 1);
            int childDoc = this.childDocuments.nextSetBit(prevParentDoc + 1);
            if (childDoc >= parentDoc || childDoc == -1) {
                return;
            }
            this.wrappedComparator.copy(this.spareSlot, childDoc);
            this.wrappedComparator.copy(slot, childDoc);
            while ((childDoc = this.childDocuments.nextSetBit(childDoc + 1)) < parentDoc && childDoc != -1) {
                this.wrappedComparator.copy(this.spareSlot, childDoc);
                if (this.wrappedComparator.compare(this.spareSlot, slot) <= 0) continue;
                this.wrappedComparator.copy(slot, childDoc);
            }
            return;
        }

        @Override
        public int compareDocToValue(int parentDoc, Object value2) throws IOException {
            if (parentDoc == 0 || this.parentDocuments == null || this.childDocuments == null) {
                return 0;
            }
            int prevParentDoc = this.parentDocuments.prevSetBit(parentDoc - 1);
            int childDoc = this.childDocuments.nextSetBit(prevParentDoc + 1);
            if (childDoc >= parentDoc || childDoc == -1) {
                return 0;
            }
            int cmp = this.wrappedComparator.compareBottom(childDoc);
            if (cmp < 0) {
                return cmp;
            }
            while ((childDoc = this.childDocuments.nextSetBit(childDoc + 1)) < parentDoc && childDoc != -1) {
                int cmp1 = this.wrappedComparator.compareDocToValue(childDoc, value2);
                if (cmp1 < 0) {
                    return cmp1;
                }
                if (cmp1 != 0) continue;
                cmp = 0;
            }
            return cmp;
        }
    }

    public static final class Lowest
    extends ToParentBlockJoinFieldComparator {
        public Lowest(FieldComparator<Object> wrappedComparator, Filter parentFilter, Filter childFilter, int spareSlot) {
            super(wrappedComparator, parentFilter, childFilter, spareSlot);
        }

        @Override
        public int compareBottom(int parentDoc) throws IOException {
            if (parentDoc == 0 || this.parentDocuments == null || this.childDocuments == null) {
                return 0;
            }
            int prevParentDoc = this.parentDocuments.prevSetBit(parentDoc - 1);
            int childDoc = this.childDocuments.nextSetBit(prevParentDoc + 1);
            if (childDoc >= parentDoc || childDoc == -1) {
                return 0;
            }
            int cmp = this.wrappedComparator.compareBottom(childDoc);
            if (cmp > 0) {
                return cmp;
            }
            while ((childDoc = this.childDocuments.nextSetBit(childDoc + 1)) < parentDoc && childDoc != -1) {
                int cmp1 = this.wrappedComparator.compareBottom(childDoc);
                if (cmp1 > 0) {
                    return cmp1;
                }
                if (cmp1 != 0) continue;
                cmp = 0;
            }
            return cmp;
        }

        @Override
        public void copy(int slot, int parentDoc) throws IOException {
            if (parentDoc == 0 || this.parentDocuments == null || this.childDocuments == null) {
                return;
            }
            int prevParentDoc = this.parentDocuments.prevSetBit(parentDoc - 1);
            int childDoc = this.childDocuments.nextSetBit(prevParentDoc + 1);
            if (childDoc >= parentDoc || childDoc == -1) {
                return;
            }
            this.wrappedComparator.copy(this.spareSlot, childDoc);
            this.wrappedComparator.copy(slot, childDoc);
            while ((childDoc = this.childDocuments.nextSetBit(childDoc + 1)) < parentDoc && childDoc != -1) {
                this.wrappedComparator.copy(this.spareSlot, childDoc);
                if (this.wrappedComparator.compare(this.spareSlot, slot) >= 0) continue;
                this.wrappedComparator.copy(slot, childDoc);
            }
            return;
        }

        @Override
        public int compareDocToValue(int parentDoc, Object value2) throws IOException {
            if (parentDoc == 0 || this.parentDocuments == null || this.childDocuments == null) {
                return 0;
            }
            int prevParentDoc = this.parentDocuments.prevSetBit(parentDoc - 1);
            int childDoc = this.childDocuments.nextSetBit(prevParentDoc + 1);
            if (childDoc >= parentDoc || childDoc == -1) {
                return 0;
            }
            int cmp = this.wrappedComparator.compareBottom(childDoc);
            if (cmp > 0) {
                return cmp;
            }
            while ((childDoc = this.childDocuments.nextSetBit(childDoc + 1)) < parentDoc && childDoc != -1) {
                int cmp1 = this.wrappedComparator.compareDocToValue(childDoc, value2);
                if (cmp1 > 0) {
                    return cmp1;
                }
                if (cmp1 != 0) continue;
                cmp = 0;
            }
            return cmp;
        }
    }
}

