/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;

abstract class TermsCollector
extends Collector {
    final String field;
    final BytesRefHash collectorTerms = new BytesRefHash();

    TermsCollector(String field2) {
        this.field = field2;
    }

    public BytesRefHash getCollectorTerms() {
        return this.collectorTerms;
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
    }

    @Override
    public boolean acceptsDocsOutOfOrder() {
        return true;
    }

    static TermsCollector create(String field2, boolean multipleValuesPerDocument) {
        return multipleValuesPerDocument ? new MV(field2) : new SV(field2);
    }

    static class SV
    extends TermsCollector {
        final BytesRef spare = new BytesRef();
        private BinaryDocValues fromDocTerms;

        SV(String field2) {
            super(field2);
        }

        @Override
        public void collect(int doc) throws IOException {
            this.fromDocTerms.get(doc, this.spare);
            this.collectorTerms.add(this.spare);
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.fromDocTerms = FieldCache.DEFAULT.getTerms(context.reader(), this.field, false);
        }
    }

    static class MV
    extends TermsCollector {
        final BytesRef scratch = new BytesRef();
        private SortedSetDocValues docTermOrds;

        MV(String field2) {
            super(field2);
        }

        @Override
        public void collect(int doc) throws IOException {
            long ord;
            this.docTermOrds.setDocument(doc);
            while ((ord = this.docTermOrds.nextOrd()) != -1L) {
                this.docTermOrds.lookupOrd(ord, this.scratch);
                this.collectorTerms.add(this.scratch);
            }
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.docTermOrds = FieldCache.DEFAULT.getDocTermOrds(context.reader(), this.field);
        }
    }
}

