/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CollectionUtil;

public final class TokenStreamFromTermPositionVector
extends TokenStream {
    private final List<Token> positionedTokens = new ArrayList<Token>();
    private Iterator<Token> tokensAtCurrentPosition;
    private CharTermAttribute termAttribute = this.addAttribute(CharTermAttribute.class);
    private PositionIncrementAttribute positionIncrementAttribute = this.addAttribute(PositionIncrementAttribute.class);
    private OffsetAttribute offsetAttribute = this.addAttribute(OffsetAttribute.class);
    private static final Comparator<Token> tokenComparator = new Comparator<Token>(){

        @Override
        public int compare(Token o1, Token o2) {
            return o1.getPositionIncrement() - o2.getPositionIncrement();
        }
    };

    public TokenStreamFromTermPositionVector(Terms vector) throws IOException {
        BytesRef text2;
        boolean hasOffsets = vector.hasOffsets();
        TermsEnum termsEnum = vector.iterator(null);
        DocsAndPositionsEnum dpEnum = null;
        while ((text2 = termsEnum.next()) != null) {
            dpEnum = termsEnum.docsAndPositions(null, dpEnum);
            assert (dpEnum != null);
            dpEnum.nextDoc();
            int freq = dpEnum.freq();
            for (int j = 0; j < freq; ++j) {
                Token token2;
                int pos = dpEnum.nextPosition();
                if (hasOffsets) {
                    token2 = new Token(text2.utf8ToString(), dpEnum.startOffset(), dpEnum.endOffset());
                } else {
                    token2 = new Token();
                    token2.setEmpty().append(text2.utf8ToString());
                }
                token2.setPositionIncrement(pos);
                this.positionedTokens.add(token2);
            }
        }
        CollectionUtil.timSort(this.positionedTokens, tokenComparator);
        int lastPosition = -1;
        for (Token token3 : this.positionedTokens) {
            int thisPosition = token3.getPositionIncrement();
            token3.setPositionIncrement(thisPosition - lastPosition);
            lastPosition = thisPosition;
        }
        this.tokensAtCurrentPosition = this.positionedTokens.iterator();
    }

    @Override
    public boolean incrementToken() {
        if (this.tokensAtCurrentPosition.hasNext()) {
            Token next2 = this.tokensAtCurrentPosition.next();
            this.clearAttributes();
            this.termAttribute.setEmpty().append(next2);
            this.positionIncrementAttribute.setPositionIncrement(next2.getPositionIncrement());
            this.offsetAttribute.setOffset(next2.startOffset(), next2.endOffset());
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.tokensAtCurrentPosition = this.positionedTokens.iterator();
    }
}

