/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.highlight.TokenStreamFromTermPositionVector;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;

public class TokenSources {
    public static TokenStream getAnyTokenStream(IndexReader reader, int docId, String field2, Document doc, Analyzer analyzer) throws IOException {
        Terms vector;
        TokenStream ts = null;
        Fields vectors = reader.getTermVectors(docId);
        if (vectors != null && (vector = vectors.terms(field2)) != null) {
            ts = TokenSources.getTokenStream(vector);
        }
        if (ts == null) {
            ts = TokenSources.getTokenStream(doc, field2, analyzer);
        }
        return ts;
    }

    public static TokenStream getAnyTokenStream(IndexReader reader, int docId, String field2, Analyzer analyzer) throws IOException {
        Terms vector;
        TokenStream ts = null;
        Fields vectors = reader.getTermVectors(docId);
        if (vectors != null && (vector = vectors.terms(field2)) != null) {
            ts = TokenSources.getTokenStream(vector);
        }
        if (ts == null) {
            ts = TokenSources.getTokenStream(reader, docId, field2, analyzer);
        }
        return ts;
    }

    public static TokenStream getTokenStream(Terms vector) throws IOException {
        return TokenSources.getTokenStream(vector, false);
    }

    public static TokenStream getTokenStream(Terms tpv, boolean tokenPositionsGuaranteedContiguous) throws IOException {
        BytesRef text2;
        if (!tpv.hasOffsets()) {
            throw new IllegalArgumentException("Cannot create TokenStream from Terms without offsets");
        }
        if (!tokenPositionsGuaranteedContiguous && tpv.hasPositions()) {
            return new TokenStreamFromTermPositionVector(tpv);
        }
        TermsEnum termsEnum = tpv.iterator(null);
        int totalTokens = 0;
        while (termsEnum.next() != null) {
            totalTokens += (int)termsEnum.totalTermFreq();
        }
        Token[] tokensInOriginalOrder = new Token[totalTokens];
        ArrayList<Token> unsortedTokens = null;
        termsEnum = tpv.iterator(null);
        DocsAndPositionsEnum dpEnum = null;
        while ((text2 = termsEnum.next()) != null) {
            if ((dpEnum = termsEnum.docsAndPositions(null, dpEnum)) == null) {
                throw new IllegalArgumentException("Required TermVector Offset information was not found");
            }
            String term = text2.utf8ToString();
            dpEnum.nextDoc();
            int freq = dpEnum.freq();
            for (int posUpto = 0; posUpto < freq; ++posUpto) {
                int pos = dpEnum.nextPosition();
                if (dpEnum.startOffset() < 0) {
                    throw new IllegalArgumentException("Required TermVector Offset information was not found");
                }
                Token token2 = new Token(term, dpEnum.startOffset(), dpEnum.endOffset());
                if (tokenPositionsGuaranteedContiguous && pos != -1) {
                    tokensInOriginalOrder[pos] = token2;
                    continue;
                }
                if (unsortedTokens == null) {
                    unsortedTokens = new ArrayList<Token>();
                }
                unsortedTokens.add(token2);
            }
        }
        if (unsortedTokens != null) {
            tokensInOriginalOrder = unsortedTokens.toArray(new Token[unsortedTokens.size()]);
            ArrayUtil.timSort(tokensInOriginalOrder, new Comparator<Token>(){

                @Override
                public int compare(Token t1, Token t2) {
                    if (t1.startOffset() == t2.startOffset()) {
                        return t1.endOffset() - t2.endOffset();
                    }
                    return t1.startOffset() - t2.startOffset();
                }
            });
        }
        final class StoredTokenStream
        extends TokenStream {
            Token[] tokens;
            int currentToken = 0;
            CharTermAttribute termAtt;
            OffsetAttribute offsetAtt;
            PositionIncrementAttribute posincAtt;

            StoredTokenStream(Token[] tokens) {
                this.tokens = tokens;
                this.termAtt = this.addAttribute(CharTermAttribute.class);
                this.offsetAtt = this.addAttribute(OffsetAttribute.class);
                this.posincAtt = this.addAttribute(PositionIncrementAttribute.class);
            }

            @Override
            public boolean incrementToken() {
                if (this.currentToken >= this.tokens.length) {
                    return false;
                }
                Token token2 = this.tokens[this.currentToken++];
                this.clearAttributes();
                this.termAtt.setEmpty().append(token2);
                this.offsetAtt.setOffset(token2.startOffset(), token2.endOffset());
                this.posincAtt.setPositionIncrement(this.currentToken <= 1 || this.tokens[this.currentToken - 1].startOffset() > this.tokens[this.currentToken - 2].startOffset() ? 1 : 0);
                return true;
            }
        }
        return new StoredTokenStream(tokensInOriginalOrder);
    }

    public static TokenStream getTokenStreamWithOffsets(IndexReader reader, int docId, String field2) throws IOException {
        Fields vectors = reader.getTermVectors(docId);
        if (vectors == null) {
            return null;
        }
        Terms vector = vectors.terms(field2);
        if (vector == null) {
            return null;
        }
        if (!vector.hasPositions() || !vector.hasOffsets()) {
            return null;
        }
        return TokenSources.getTokenStream(vector);
    }

    public static TokenStream getTokenStream(IndexReader reader, int docId, String field2, Analyzer analyzer) throws IOException {
        Document doc = reader.document(docId);
        return TokenSources.getTokenStream(doc, field2, analyzer);
    }

    public static TokenStream getTokenStream(Document doc, String field2, Analyzer analyzer) {
        String contents = doc.get(field2);
        if (contents == null) {
            throw new IllegalArgumentException("Field " + field2 + " in document is not stored and cannot be analyzed");
        }
        return TokenSources.getTokenStream(field2, contents, analyzer);
    }

    public static TokenStream getTokenStream(String field2, String contents, Analyzer analyzer) {
        try {
            return analyzer.tokenStream(field2, contents);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

