/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import org.apache.lucene.search.highlight.Encoder;

public class SimpleHTMLEncoder
implements Encoder {
    @Override
    public String encodeText(String originalText) {
        return SimpleHTMLEncoder.htmlEncode(originalText);
    }

    public static final String htmlEncode(String plainText) {
        if (plainText == null || plainText.length() == 0) {
            return "";
        }
        StringBuilder result2 = new StringBuilder(plainText.length());
        block8: for (int index = 0; index < plainText.length(); ++index) {
            char ch = plainText.charAt(index);
            switch (ch) {
                case '\"': {
                    result2.append("&quot;");
                    continue block8;
                }
                case '&': {
                    result2.append("&amp;");
                    continue block8;
                }
                case '<': {
                    result2.append("&lt;");
                    continue block8;
                }
                case '>': {
                    result2.append("&gt;");
                    continue block8;
                }
                case '\'': {
                    result2.append("&#x27;");
                    continue block8;
                }
                case '/': {
                    result2.append("&#x2F;");
                    continue block8;
                }
                default: {
                    result2.append(ch);
                }
            }
        }
        return result2.toString();
    }
}

