/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping.function;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.grouping.AbstractAllGroupsCollector;
import org.apache.lucene.util.mutable.MutableValue;

public class FunctionAllGroupsCollector
extends AbstractAllGroupsCollector<MutableValue> {
    private final Map<?, ?> vsContext;
    private final ValueSource groupBy;
    private final SortedSet<MutableValue> groups = new TreeSet<MutableValue>();
    private FunctionValues.ValueFiller filler;
    private MutableValue mval;

    public FunctionAllGroupsCollector(ValueSource groupBy2, Map<?, ?> vsContext) {
        this.vsContext = vsContext;
        this.groupBy = groupBy2;
    }

    @Override
    public Collection<MutableValue> getGroups() {
        return this.groups;
    }

    @Override
    public void collect(int doc) throws IOException {
        this.filler.fillValue(doc);
        if (!this.groups.contains(this.mval)) {
            this.groups.add(this.mval.duplicate());
        }
    }

    @Override
    public void setNextReader(AtomicReaderContext context) throws IOException {
        FunctionValues values2 = this.groupBy.getValues(this.vsContext, context);
        this.filler = values2.getValueFiller();
        this.mval = this.filler.getValue();
    }
}

