/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.DisjunctionScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

class DisjunctionMaxScorer
extends DisjunctionScorer {
    private final float tieBreakerMultiplier;
    private int freq = -1;
    private float scoreSum;
    private float scoreMax;

    public DisjunctionMaxScorer(Weight weight, float tieBreakerMultiplier, Scorer[] subScorers) {
        super(weight, subScorers);
        this.tieBreakerMultiplier = tieBreakerMultiplier;
    }

    @Override
    public float score() throws IOException {
        return this.scoreMax + (this.scoreSum - this.scoreMax) * this.tieBreakerMultiplier;
    }

    @Override
    protected void afterNext() throws IOException {
        this.doc = this.subScorers[0].docID();
        if (this.doc != Integer.MAX_VALUE) {
            this.scoreSum = this.scoreMax = this.subScorers[0].score();
            this.freq = 1;
            this.scoreAll(1);
            this.scoreAll(2);
        }
    }

    private void scoreAll(int root2) throws IOException {
        if (root2 < this.numScorers && this.subScorers[root2].docID() == this.doc) {
            float sub = this.subScorers[root2].score();
            ++this.freq;
            this.scoreSum += sub;
            this.scoreMax = Math.max(this.scoreMax, sub);
            this.scoreAll((root2 << 1) + 1);
            this.scoreAll((root2 << 1) + 2);
        }
    }

    @Override
    public int freq() throws IOException {
        return this.freq;
    }
}

